/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentSubsystemSchema;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.xml.VersionedFeature;
import org.jboss.as.controller.xml.VersionedNamespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.IntVersion;
import org.wildfly.extension.io.BufferPoolResourceDefinition;
import org.wildfly.extension.io.IOSubsystemRegistrar;
import org.wildfly.extension.io.OutboundBindAddressResourceDefinition;
import org.wildfly.extension.io.WorkerResourceDefinition;
import org.wildfly.io.OptionAttributeDefinition;

public enum IOSubsystemSchema implements PersistentSubsystemSchema<IOSubsystemSchema>
{
    VERSION_1_1(1, 1),
    VERSION_2_0(2, 0),
    VERSION_3_0(3, 0),
    VERSION_4_0(4, 0);

    static final IOSubsystemSchema CURRENT;
    private final VersionedNamespace<IntVersion, IOSubsystemSchema> namespace;

    private IOSubsystemSchema(int major, int minor) {
        this.namespace = SubsystemSchema.createLegacySubsystemURN((String)"io", (IntVersion)new IntVersion(new int[]{major, minor}));
    }

    public VersionedNamespace<IntVersion, IOSubsystemSchema> getNamespace() {
        return this.namespace;
    }

    public PersistentResourceXMLDescription getXMLDescription() {
        PersistentResourceXMLDescription.Factory factory = PersistentResourceXMLDescription.factory((PersistentSubsystemSchema)this);
        PersistentResourceXMLDescription.Builder builder = factory.builder(IOSubsystemRegistrar.PATH);
        if (this.since((VersionedFeature)VERSION_4_0)) {
            builder.addAttribute(IOSubsystemRegistrar.DEFAULT_WORKER);
        } else {
            builder.setAdditionalOperationsGenerator(new PersistentResourceXMLDescription.AdditionalOperationsGenerator(){

                public void additionalOperations(PathAddress address, ModelNode addOperation, List<ModelNode> operations) {
                    addOperation.get(IOSubsystemRegistrar.DEFAULT_WORKER.getName()).set(IOSubsystemRegistrar.LEGACY_DEFAULT_WORKER);
                }
            });
        }
        Stream<OptionAttributeDefinition> workerAttributes = Stream.of(WorkerResourceDefinition.ATTRIBUTES);
        if (!this.since((VersionedFeature)VERSION_3_0)) {
            workerAttributes = workerAttributes.filter(Predicate.not(arg_0 -> ((OptionAttributeDefinition)WorkerResourceDefinition.WORKER_TASK_CORE_THREADS).equals(arg_0)));
        }
        PersistentResourceXMLDescription.Builder workerBuilder = factory.builder(WorkerResourceDefinition.PATH).addAttributes(workerAttributes);
        if (this.since((VersionedFeature)VERSION_2_0)) {
            workerBuilder.addChild(factory.builder(OutboundBindAddressResourceDefinition.PATH).addAttributes(OutboundBindAddressResourceDefinition.ATTRIBUTES.stream()).build());
        }
        return builder.addChild(workerBuilder.build()).addChild(factory.builder(BufferPoolResourceDefinition.PATH).addAttributes(BufferPoolResourceDefinition.ATTRIBUTES.stream()).build()).build();
    }

    static {
        CURRENT = VERSION_4_0;
    }
}

