/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.wildfly.extension.batch.jberet.BatchSubsystemExtension;
import org.wildfly.extension.batch.jberet.job.repository.CommonAttributes;
import org.wildfly.extension.batch.jberet.job.repository.InMemoryJobRepositoryDefinition;
import org.wildfly.extension.batch.jberet.job.repository.JdbcJobRepositoryDefinition;

public class BatchExtensionTransformerRegistration
implements ExtensionTransformerRegistration {
    public String getSubsystemName() {
        return "batch-jberet";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        ChainedTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getCurrentSubsystemVersion());
        BatchExtensionTransformerRegistration.registerV3Transformers(builder.createBuilder(BatchSubsystemExtension.VERSION_3_0_0, BatchSubsystemExtension.VERSION_2_0_0));
        builder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{BatchSubsystemExtension.VERSION_1_0_0, BatchSubsystemExtension.VERSION_2_0_0, BatchSubsystemExtension.VERSION_3_0_0}});
    }

    private static void registerV3Transformers(ResourceTransformationDescriptionBuilder subsystem) {
        ResourceTransformationDescriptionBuilder inMemoryJobRepository = subsystem.addChildResource(InMemoryJobRepositoryDefinition.PATH);
        BatchExtensionTransformerRegistration.rejectAttribute(inMemoryJobRepository, (AttributeDefinition)CommonAttributes.EXECUTION_RECORDS_LIMIT);
        ResourceTransformationDescriptionBuilder jdbcJobRepository = subsystem.addChildResource(JdbcJobRepositoryDefinition.PATH);
        BatchExtensionTransformerRegistration.rejectAttribute(jdbcJobRepository, (AttributeDefinition)CommonAttributes.EXECUTION_RECORDS_LIMIT);
    }

    private static void rejectAttribute(ResourceTransformationDescriptionBuilder resource, AttributeDefinition attribute) {
        ((AttributeTransformationDescriptionBuilder)resource.getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{attribute})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{attribute});
    }
}

