/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.CountDownLatch;
import javax.security.auth.Subject;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.remote.MarshallingUtil;
import org.jboss.as.controller.remote.OperationAttachmentsProxy;
import org.jboss.as.controller.remote.OperationMessageHandlerProxy;
import org.jboss.as.protocol.ProtocolLogger;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Unmarshaller;

public class TransactionalProtocolOperationHandler
implements ManagementRequestHandlerFactory {
    private final ModelController controller;
    private final ManagementChannelAssociation channelAssociation;

    public TransactionalProtocolOperationHandler(ModelController controller, ManagementChannelAssociation channelAssociation) {
        this.controller = controller;
        this.channelAssociation = channelAssociation;
    }

    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader request) {
        switch (request.getOperationId()) {
            case 71: {
                ExecuteRequestContext executeRequestContext = new ExecuteRequestContext();
                executeRequestContext.operation = handlers.registerActiveOperation(Integer.valueOf(request.getBatchId()), (Object)executeRequestContext, (ActiveOperation.CompletedCallback)executeRequestContext);
                return new ExecuteRequestHandler();
            }
            case 78: {
                return new CompleteTxOperationHandler();
            }
        }
        return handlers.resolveNext();
    }

    protected ModelNode internalExecute(ModelNode operation, ManagementRequestContext<?> context, OperationMessageHandler messageHandler, ProxyController.ProxyOperationControl control, OperationAttachments attachments) {
        return this.controller.execute(operation, messageHandler, control, attachments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendResponse(ManagementRequestContext<ExecuteRequestContext> context, byte responseType, ModelNode response) throws IOException {
        ManagementResponseHeader header = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
        FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)header);
        try {
            output.writeByte((int)responseType);
            response.writeExternal((DataOutput)output);
            output.writeByte(36);
            output.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    static class ExecuteRequestContext
    implements ActiveOperation.CompletedCallback<Void> {
        private boolean prepared;
        private boolean rollbackOnPrepare;
        private ModelController.OperationTransaction activeTx;
        private ActiveOperation<Void, ExecuteRequestContext> operation;
        private ManagementRequestContext<ExecuteRequestContext> responseChannel;
        private final CountDownLatch txCompletedLatch = new CountDownLatch(1);
        private PrivilegedAction<Void> action;

        ExecuteRequestContext() {
        }

        Integer getOperationId() {
            return this.operation.getOperationId();
        }

        ActiveOperation.ResultHandler<Void> getResultHandler() {
            return this.operation.getResultHandler();
        }

        public PrivilegedAction<Void> getAction() {
            return this.action;
        }

        public void setAction(PrivilegedAction<Void> action) {
            this.action = action;
        }

        public void completed(Void result) {
        }

        public synchronized void failed(Exception e) {
            ModelController.OperationTransaction transaction;
            if (this.prepared && (transaction = this.activeTx) != null) {
                transaction.rollback();
                this.txCompletedLatch.countDown();
            }
        }

        public void cancelled() {
        }

        synchronized void initialize(ManagementRequestContext<ExecuteRequestContext> context) {
            assert (!this.prepared);
            assert (this.responseChannel == null);
            assert (this.activeTx == null);
            this.responseChannel = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void prepare(ModelController.OperationTransaction tx, ModelNode result) {
            if (this.rollbackOnPrepare) {
                try {
                    tx.rollback();
                }
                finally {
                    this.txCompletedLatch.countDown();
                }
            }
            assert (!this.prepared);
            assert (this.activeTx == null);
            assert (this.responseChannel != null);
            try {
                TransactionalProtocolOperationHandler.sendResponse(this.responseChannel, (byte)75, result);
                this.activeTx = tx;
                this.prepared = true;
            }
            catch (IOException e) {
                this.getResultHandler().failed((Exception)e);
            }
            finally {
                this.responseChannel = null;
            }
        }

        synchronized void completeTx(ManagementRequestContext<ExecuteRequestContext> context, boolean commit) {
            if (!this.prepared) {
                assert (!commit);
                this.rollbackOnPrepare = true;
                context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

                    public void execute(ManagementRequestContext<ExecuteRequestContext> executeRequestContextManagementRequestContext) throws Exception {
                        ExecuteRequestContext.this.operation.getResultHandler().cancel();
                    }
                });
            } else {
                assert (this.prepared);
                assert (this.activeTx != null);
                assert (this.responseChannel == null);
                this.responseChannel = context;
                if (commit) {
                    this.activeTx.commit();
                } else {
                    this.activeTx.rollback();
                }
                this.txCompletedLatch.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void failed(ModelNode response) {
            if (this.prepared) {
                this.completed(response);
            } else {
                assert (this.responseChannel != null);
                try {
                    TransactionalProtocolOperationHandler.sendResponse(this.responseChannel, (byte)73, response);
                }
                catch (IOException e) {
                    ProtocolLogger.ROOT_LOGGER.debugf((Throwable)e, "failed to process message", new Object[0]);
                }
                finally {
                    this.getResultHandler().done(null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void completed(ModelNode response) {
            assert (this.prepared);
            assert (this.responseChannel != null);
            try {
                TransactionalProtocolOperationHandler.sendResponse(this.responseChannel, (byte)74, response);
            }
            catch (IOException e) {
                ProtocolLogger.ROOT_LOGGER.debugf((Throwable)e, "failed to process message", new Object[0]);
            }
            finally {
                this.getResultHandler().done(null);
            }
        }
    }

    static class ProxyOperationControlProxy
    implements ProxyController.ProxyOperationControl {
        private final ExecuteRequestContext requestContext;

        ProxyOperationControlProxy(ExecuteRequestContext requestContext) {
            this.requestContext = requestContext;
        }

        @Override
        public void operationFailed(ModelNode response) {
            this.requestContext.failed(response);
        }

        @Override
        public void operationCompleted(ModelNode response) {
            this.requestContext.completed(response);
        }

        @Override
        public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
            this.requestContext.prepare(transaction, result);
            try {
                this.requestContext.txCompletedLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class CompleteTxOperationHandler
    implements ManagementRequestHandler<Void, ExecuteRequestContext> {
        private CompleteTxOperationHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ExecuteRequestContext executeRequestContext = (ExecuteRequestContext)context.getAttachment();
            byte commitOrRollback = input.readByte();
            executeRequestContext.completeTx(context, commitOrRollback == 112);
        }
    }

    private class GetSubjectResponseHandler
    extends AbstractManagementRequest<Object, ExecuteRequestContext> {
        private GetSubjectResponseHandler() {
        }

        public byte getOperationType() {
            return 79;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Object> resultHandler, ManagementRequestContext<ExecuteRequestContext> context, FlushableDataOutput output) throws IOException {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Object> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)80);
            int size = input.readInt();
            Subject subject = null;
            if (size == 1) {
                Unmarshaller unmarshaller = MarshallingUtil.getUnmarshaller();
                ByteInput byteInput = MarshallingUtil.createByteInput(input);
                unmarshaller.start(byteInput);
                try {
                    subject = (Subject)unmarshaller.readObject(Subject.class);
                }
                catch (ClassNotFoundException e) {
                    throw ControllerMessages.MESSAGES.unableToUnmarshallSubject(e);
                }
                unmarshaller.finish();
            } else {
                subject = null;
            }
            final Subject finalSubject = subject;
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

                public void execute(final ManagementRequestContext<ExecuteRequestContext> context) throws Exception {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            Subject.doAs(finalSubject, ((ExecuteRequestContext)context.getAttachment()).getAction());
                            return null;
                        }
                    });
                }
            });
        }
    }

    private class ExecuteRequestHandler
    implements ManagementRequestHandler<Void, ExecuteRequestContext> {
        private ExecuteRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, final ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            final ModelNode operation = new ModelNode();
            ProtocolUtils.expectHeader((DataInput)input, (int)97);
            operation.readExternal(input);
            ProtocolUtils.expectHeader((DataInput)input, (int)101);
            final int attachmentsLength = input.readInt();
            PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ExecuteRequestHandler.this.doExecute(operation, attachmentsLength, (ManagementRequestContext<ExecuteRequestContext>)context);
                    return null;
                }
            };
            ((ExecuteRequestContext)context.getAttachment()).setAction(action);
            TransactionalProtocolOperationHandler.this.channelAssociation.executeRequest(((ExecuteRequestContext)context.getAttachment()).getOperationId(), (ManagementRequest)new GetSubjectResponseHandler());
        }

        protected void doExecute(ModelNode operation, int attachmentsLength, ManagementRequestContext<ExecuteRequestContext> context) {
            ModelNode result;
            ExecuteRequestContext executeRequestContext = (ExecuteRequestContext)context.getAttachment();
            executeRequestContext.initialize(context);
            Integer batchId = executeRequestContext.getOperationId();
            OperationMessageHandlerProxy messageHandlerProxy = new OperationMessageHandlerProxy(TransactionalProtocolOperationHandler.this.channelAssociation, batchId);
            ProxyOperationControlProxy control = new ProxyOperationControlProxy(executeRequestContext);
            OperationAttachmentsProxy attachmentsProxy = OperationAttachmentsProxy.create(TransactionalProtocolOperationHandler.this.channelAssociation, batchId, attachmentsLength);
            try {
                result = TransactionalProtocolOperationHandler.this.internalExecute(operation, context, messageHandlerProxy, control, attachmentsProxy);
            }
            catch (Exception e) {
                ModelNode failure = new ModelNode();
                failure.get("outcome").set("failed");
                failure.get("failure-description").set(e.getClass().getName() + ":" + e.getMessage());
                control.operationFailed(failure);
                attachmentsProxy.shutdown(e);
                return;
            }
            if (result.hasDefined("failure-description")) {
                control.operationFailed(result);
            } else {
                control.operationCompleted(result);
            }
        }
    }
}

