/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.FilteredData;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadChildrenNamesHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-children-names", ControllerResolver.getResolver("global")).setParameters(GlobalOperationHandlers.CHILD_TYPE).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();
    static final OperationStepHandler INSTANCE = new ReadChildrenNamesHandler();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        String childType = GlobalOperationHandlers.CHILD_TYPE.resolveModelAttribute(context, operation).asString();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        Map<String, Set<String>> childAddresses = GlobalOperationHandlers.getChildAddresses(context, address, registry, resource, childType);
        Set<String> childNames = childAddresses.get(childType);
        if (childNames == null) {
            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.unknownChildType(childType)));
        }
        childNames = new TreeSet<String>(childNames);
        ModelNode result = context.getResult();
        result.setEmptyList();
        PathAddress childAddress = address.append(PathElement.pathElement(childType));
        ModelNode op = Util.createEmptyOperation("read-resource", childAddress);
        op.get("operation-headers").set(operation.get("operation-headers"));
        ModelNode opAddr = op.get("address");
        ModelNode childProperty = opAddr.require(address.size());
        EnumSet<Action.ActionEffect> actionEffects = EnumSet.of(Action.ActionEffect.ADDRESS);
        FilteredData fd = null;
        for (String childName : childNames) {
            childProperty.set(childType, new ModelNode(childName));
            if (context.authorize(op, actionEffects).getDecision() == AuthorizationResult.Decision.PERMIT) {
                result.add(childName);
                continue;
            }
            if (fd == null) {
                fd = new FilteredData(address);
            }
            fd.addAccessRestrictedResource(PathAddress.pathAddress(opAddr));
        }
        if (fd != null) {
            context.getResponseHeaders().get("access-control").set(fd.toModelNode());
        }
        context.stepCompleted();
    }
}

