/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.constraint.management;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.constraint.ApplicationTypeConstraint;
import org.jboss.as.controller.access.constraint.ConstraintFactory;
import org.jboss.as.controller.access.constraint.management.AccessConstraintDefinition;
import org.jboss.dmr.ModelNode;

public class ApplicationTypeAccessConstraintDefinition
implements AccessConstraintDefinition {
    public static final ApplicationTypeAccessConstraintDefinition DEPLOYMENT = new ApplicationTypeAccessConstraintDefinition(ApplicationTypeConfig.DEPLOYMENT);
    public static final List<AccessConstraintDefinition> DEPLOYMENT_AS_LIST = DEPLOYMENT.wrapAsList();
    private final ApplicationTypeConfig applicationTypeConfig;

    public ApplicationTypeAccessConstraintDefinition(ApplicationTypeConfig applicationTypeConfig) {
        this.applicationTypeConfig = applicationTypeConfig;
        ApplicationTypeConstraint.FACTORY.addApplicationTypeConfig(applicationTypeConfig);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        ModelNode result = new ModelNode();
        result.get("type").set(this.applicationTypeConfig.isCore() ? "core" : this.applicationTypeConfig.getSubsystem());
        return result;
    }

    @Override
    public ConstraintFactory getConstraintFactory() {
        return ApplicationTypeConstraint.FACTORY;
    }

    public ApplicationTypeConfig getApplicationTypeConfig() {
        return this.applicationTypeConfig;
    }

    @Override
    public String getName() {
        return this.applicationTypeConfig.getName();
    }

    @Override
    public AccessConstraintDefinition.Type getType() {
        return AccessConstraintDefinition.Type.APPLICATION;
    }

    public List<AccessConstraintDefinition> wrapAsList() {
        return Collections.singletonList(this);
    }
}

