/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.configadmin.service;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.as.configadmin.ConfigAdminLogger;
import org.jboss.as.configadmin.service.UnmodifiableDictionary;

class ConfigAdminState {
    static final String TRANSIENT_PROPERTY_SERIAL_ID = ".transient.serial.id";
    private final Map<String, Dictionary<String, String>> configurations = new LinkedHashMap<String, Dictionary<String, String>>();
    private final Map<String, AtomicLong> serialids = new HashMap<String, AtomicLong>();

    ConfigAdminState() {
    }

    synchronized Set<String> keySet() {
        return this.configurations.keySet();
    }

    synchronized Dictionary<String, String> get(String pid) {
        return this.configurations.get(pid);
    }

    synchronized boolean remove(String pid) {
        AtomicLong serialId = this.getSerialId(pid);
        Dictionary<String, String> previous = this.configurations.get(pid);
        if (previous == null) {
            ConfigAdminLogger.LOGGER.debugf("Config removed: %s", pid);
            return true;
        }
        serialId.getAndIncrement();
        ConfigAdminLogger.LOGGER.debugf("Config remove: %s", pid);
        this.configurations.remove(pid);
        return true;
    }

    synchronized boolean put(String pid, Dictionary<String, String> source, boolean rollback) {
        AtomicLong serialId = this.getSerialId(pid);
        String sourceid = source.get(TRANSIENT_PROPERTY_SERIAL_ID);
        if (sourceid == null) {
            sourceid = new Long(serialId.incrementAndGet()).toString();
            source.put(TRANSIENT_PROPERTY_SERIAL_ID, sourceid);
        }
        if (rollback) {
            ConfigAdminLogger.LOGGER.debugf("Config rollback: %s => %s", pid, source);
            serialId.set(Long.parseLong(sourceid));
            this.configurations.put(pid, source);
            return true;
        }
        Dictionary<String, String> previous = this.configurations.get(pid);
        if (previous == null) {
            if (Long.parseLong(sourceid) == serialId.get()) {
                ConfigAdminLogger.LOGGER.debugf("Config put: %s => %s", pid, source);
                this.configurations.put(pid, new UnmodifiableDictionary<String, String>(source));
                return true;
            }
            ConfigAdminLogger.LOGGER.debugf("Config skip put: %s => %s", pid, source);
            return false;
        }
        String previd = previous.get(TRANSIENT_PROPERTY_SERIAL_ID);
        if (Long.parseLong(previd) <= Long.parseLong(sourceid)) {
            ConfigAdminLogger.LOGGER.debugf("Config put: %s => %s", pid, source);
            this.configurations.put(pid, new UnmodifiableDictionary<String, String>(source));
            return true;
        }
        ConfigAdminLogger.LOGGER.debugf("Config skip put: %s => %s", pid, source);
        return false;
    }

    private AtomicLong getSerialId(String pid) {
        AtomicLong serialid = this.serialids.get(pid);
        if (serialid == null) {
            serialid = new AtomicLong();
            this.serialids.put(pid, serialid);
        }
        return serialid;
    }
}

