/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.configadmin.service;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.configadmin.ConfigAdminListener;
import org.jboss.as.configadmin.ConfigAdminLogger;
import org.jboss.as.configadmin.service.ConfigAdminInternal;
import org.jboss.as.configadmin.service.ConfigAdminState;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.spi.util.UnmodifiableDictionary;

public class ConfigAdminServiceImpl
implements ConfigAdminInternal,
Service<ConfigAdminInternal> {
    static final String TRANSIENT_PROPERTY_SKIP_MANAGEMENT_OPERATION = ".transient.skip.mgmnt.op";
    private final InjectedValue<ModelController> injectedModelController = new InjectedValue();
    private final Set<ConfigAdminListener> listeners = new CopyOnWriteArraySet<ConfigAdminListener>();
    private final ConfigAdminState configurations = new ConfigAdminState();
    private ModelControllerClient controllerClient;
    private ExecutorService mgmntOperationExecutor;
    private ExecutorService asyncListnersExecutor;

    private ConfigAdminServiceImpl() {
    }

    public static ServiceController<ConfigAdminInternal> addService(ServiceTarget target, ServiceListener<Object> ... listeners) {
        ConfigAdminServiceImpl service = new ConfigAdminServiceImpl();
        ServiceBuilder builder = target.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.injectedModelController);
        builder.addListener(listeners);
        return builder.install();
    }

    public void start(StartContext context) throws StartException {
        this.mgmntOperationExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setName("ConfigAdmin Management Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.asyncListnersExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setName("ConfigAdmin Listener Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.controllerClient = ((ModelController)this.injectedModelController.getValue()).createClient((Executor)this.mgmntOperationExecutor);
    }

    public void stop(StopContext context) {
        this.mgmntOperationExecutor.shutdown();
        this.asyncListnersExecutor.shutdown();
    }

    public ConfigAdminInternal getValue() throws IllegalStateException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getConfigurations() {
        ConfigAdminState configAdminState = this.configurations;
        synchronized (configAdminState) {
            Set<String> result = this.configurations.keySet();
            ConfigAdminLogger.LOGGER.debugf("Get configurations: %s", result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasConfiguration(String pid) {
        ConfigAdminState configAdminState = this.configurations;
        synchronized (configAdminState) {
            return this.configurations.get(pid) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dictionary<String, String> getConfiguration(String pid) {
        ConfigAdminState configAdminState = this.configurations;
        synchronized (configAdminState) {
            Dictionary<String, String> result = this.configurations.get(pid);
            ConfigAdminLogger.LOGGER.debugf("Get configuration: %s => %s", pid, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dictionary<String, String> putConfiguration(final String pid, Dictionary<String, String> dictionary) {
        ConfigAdminLogger.LOGGER.debugf("Put configuration: %s => %s", pid, dictionary);
        ConfigAdminState configAdminState = this.configurations;
        synchronized (configAdminState) {
            final Dictionary<String, String> previous = this.configurations.get(pid);
            String skipMgmnt = dictionary.get(TRANSIENT_PROPERTY_SKIP_MANAGEMENT_OPERATION);
            if (Boolean.parseBoolean(skipMgmnt)) {
                ConfigAdminLogger.LOGGER.debugf("Put skip management operation: %s => %s", pid, dictionary);
                return previous;
            }
            Dictionary<String, String> modifiable = this.getModifiableDictionary(dictionary);
            this.configurations.put(pid, modifiable, false);
            ModelNode address = this.getSubsystemAddress();
            address.add(new ModelNode().set("configuration", pid));
            ModelNode op = previous != null ? Util.getEmptyOperation((String)"update", (ModelNode)address) : Util.getEmptyOperation((String)"add", (ModelNode)address);
            ModelNode entries = new ModelNode();
            Enumeration<String> keys = modifiable.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = modifiable.get(key);
                entries.get(key).set(value);
            }
            op.get("entries").set(entries);
            Callable<Object> errorHandler = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return ConfigAdminServiceImpl.this.configurations.put(pid, previous, true);
                }
            };
            new ConfigAdminOperationTask(pid, op, errorHandler).submit();
            return previous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putConfigurationInternal(String pid, Dictionary<String, String> dictionary) {
        ConfigAdminLogger.LOGGER.debugf("Put configuration internal: %s => %s", pid, dictionary);
        ConfigAdminState configAdminState = this.configurations;
        synchronized (configAdminState) {
            Dictionary<String, String> modifiable = this.getModifiableDictionary(dictionary);
            if (this.configurations.put(pid, modifiable, false)) {
                new ConfigAdminListenerTask(pid, (Dictionary)modifiable).submit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dictionary<String, String> removeConfiguration(final String pid) {
        ConfigAdminLogger.LOGGER.debugf("Remove configuration: %s", pid);
        ConfigAdminState configAdminState = this.configurations;
        synchronized (configAdminState) {
            final Dictionary<String, String> previous = this.configurations.get(pid);
            if (previous != null) {
                ModelNode address = this.getSubsystemAddress();
                address.add(new ModelNode().set("configuration", pid));
                ModelNode op = Util.getEmptyOperation((String)"remove", (ModelNode)address);
                this.configurations.remove(pid);
                Callable<Object> errorHandler = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ConfigAdminServiceImpl.this.configurations.put(pid, previous, true);
                    }
                };
                new ConfigAdminOperationTask(pid, op, errorHandler).submit();
            }
            return previous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigurationInternal(String pid) {
        ConfigAdminLogger.LOGGER.debugf("Remove configuration internal: %s", pid);
        ConfigAdminState configAdminState = this.configurations;
        synchronized (configAdminState) {
            if (this.configurations.remove(pid)) {
                new ConfigAdminListenerTask(pid, null).submit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ConfigAdminListener listener) {
        ConfigAdminLogger.LOGGER.debugf("Add listener: %s", listener);
        ConfigAdminState configAdminState = this.configurations;
        synchronized (configAdminState) {
            this.listeners.add(listener);
            Set<String> pids = listener.getPIDs();
            if (pids != null) {
                for (String pid : pids) {
                    Dictionary<String, String> props = this.configurations.get(pid);
                    listener.configurationModified(pid, props);
                }
            } else {
                Set<String> configpids = this.configurations.keySet();
                for (String pid : configpids) {
                    Dictionary<String, String> props = this.configurations.get(pid);
                    listener.configurationModified(pid, props);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ConfigAdminListener listener) {
        ConfigAdminLogger.LOGGER.debugf("Remove listener: %s", listener);
        ConfigAdminState configAdminState = this.configurations;
        synchronized (configAdminState) {
            this.listeners.remove(listener);
        }
    }

    private ModelNode getSubsystemAddress() {
        ModelNode address = new ModelNode();
        return address.add(new ModelNode().set("subsystem", "configadmin"));
    }

    private Dictionary<String, String> getModifiableDictionary(Dictionary<String, String> source) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (source != null) {
            Enumeration<String> keys = source.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                ((Dictionary)result).put(key, source.get(key));
            }
        }
        return result;
    }

    class ConfigAdminListenerTask
    implements Runnable {
        private final String pid;
        private final Dictionary<String, String> dictionary;
        private final Set<ConfigAdminListener> snapshot;

        private ConfigAdminListenerTask(String pid, Dictionary<String, String> dictionary) {
            this(pid, dictionary, new HashSet<ConfigAdminListener>(configAdminServiceImpl.listeners));
        }

        private ConfigAdminListenerTask(String pid, Dictionary<String, String> dictionary, Set<ConfigAdminListener> snapshot) {
            this.pid = pid;
            this.snapshot = snapshot;
            if (dictionary != null) {
                dictionary.put(ConfigAdminServiceImpl.TRANSIENT_PROPERTY_SKIP_MANAGEMENT_OPERATION, "true");
                this.dictionary = new UnmodifiableDictionary(dictionary);
            } else {
                this.dictionary = null;
            }
        }

        private void submit() {
            ConfigAdminServiceImpl.this.asyncListnersExecutor.submit(this);
        }

        @Override
        public void run() {
            for (ConfigAdminListener aux : this.snapshot) {
                Set<String> pids = aux.getPIDs();
                if (pids != null && !pids.contains(this.pid)) continue;
                try {
                    aux.configurationModified(this.pid, this.dictionary);
                }
                catch (Exception ex) {
                    ConfigAdminLogger.LOGGER.configurationListenerError(ex, aux);
                }
            }
        }
    }

    class ConfigAdminOperationTask
    implements Runnable {
        private final String pid;
        private final ModelNode operation;
        private final Callable<Object> errorHandler;

        private ConfigAdminOperationTask(String pid, ModelNode operation, Callable<Object> errorHandler) {
            this.errorHandler = errorHandler;
            this.operation = operation;
            this.pid = pid;
        }

        private void submit() {
            ConfigAdminServiceImpl.this.mgmntOperationExecutor.submit(this);
        }

        @Override
        public void run() {
            boolean success = true;
            try {
                ModelNode node = ConfigAdminServiceImpl.this.controllerClient.execute(this.operation);
                ModelNode outcome = node.get("outcome");
                success = "success".equals(outcome.asString());
                if (!success) {
                    ModelNode failure = node.get("failure-description");
                    ConfigAdminLogger.LOGGER.cannotUpdateConfiguration(new IllegalStateException(failure.asString()), this.pid);
                }
            }
            catch (Throwable ex) {
                ConfigAdminLogger.LOGGER.cannotUpdateConfiguration(ex, this.pid);
            }
            if (!success) {
                try {
                    this.errorHandler.call();
                }
                catch (Exception ex) {
                    ConfigAdminLogger.LOGGER.cannotRestoreConfiguration(ex, this.pid);
                }
            }
        }
    }
}

