/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.server;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.singleton.Singleton;
import org.wildfly.clustering.singleton.server.AbstractSingletonService;
import org.wildfly.clustering.singleton.server.DefaultSingletonContext;
import org.wildfly.clustering.singleton.server.ServiceControllerService;
import org.wildfly.clustering.singleton.server.SingletonContext;
import org.wildfly.clustering.singleton.server.SingletonServiceContext;

public class DistributedSingletonService
extends AbstractSingletonService<SingletonContext, org.wildfly.clustering.server.service.Service> {
    public DistributedSingletonService(SingletonServiceContext context, Function<ServiceTarget, ServiceBuilder<?>> builderFactory, List<Map.Entry<ServiceName[], Consumer<Consumer<?>>>> injectors, Consumer<Singleton> singleton) {
        super(context, new ServiceFactory(context.getService(), builderFactory, injectors), DefaultSingletonContext::new, singleton);
    }

    private static class ServiceFactory
    implements Function<ServiceTarget, org.wildfly.clustering.server.service.Service> {
        private final Service service;
        private final Function<ServiceTarget, ServiceBuilder<?>> builderFactory;
        private final List<Map.Entry<ServiceName[], Consumer<Consumer<?>>>> injectors;

        ServiceFactory(Service service, Function<ServiceTarget, ServiceBuilder<?>> builderFactory, List<Map.Entry<ServiceName[], Consumer<Consumer<?>>>> injectors) {
            this.service = service;
            this.builderFactory = builderFactory;
            this.injectors = injectors;
        }

        @Override
        public org.wildfly.clustering.server.service.Service apply(ServiceTarget target) {
            ServiceBuilder<?> builder = this.builderFactory.apply(target);
            for (Map.Entry<ServiceName[], Consumer<Consumer<?>>> entry : this.injectors) {
                entry.getValue().accept(builder.provides(entry.getKey()));
            }
            return new ServiceControllerService(builder.setInstance(this.service).setInitialMode(ServiceController.Mode.NEVER).install());
        }
    }
}

