/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.server;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.dispatcher.CommandDispatcher;
import org.wildfly.clustering.singleton.Singleton;
import org.wildfly.clustering.singleton.SingletonService;
import org.wildfly.clustering.singleton.SingletonState;
import org.wildfly.clustering.singleton.server.AbstractSingletonService;
import org.wildfly.clustering.singleton.server.LegacyDistributedSingletonContext;
import org.wildfly.clustering.singleton.server.LegacySingletonContext;
import org.wildfly.clustering.singleton.server.PrimaryProxyContext;
import org.wildfly.clustering.singleton.server.PrimaryProxyService;
import org.wildfly.clustering.singleton.server.ServiceControllerService;
import org.wildfly.clustering.singleton.server.ServiceValue;
import org.wildfly.clustering.singleton.server.SingletonLogger;
import org.wildfly.clustering.singleton.server.SingletonServiceContext;

@Deprecated
public class LegacyDistributedSingletonService<T>
extends AbstractSingletonService<LegacySingletonContext<T>, ServiceValue<T>>
implements SingletonService<T>,
PrimaryProxyContext<T> {
    private final SingletonServiceContext context;
    private volatile boolean started = false;
    private volatile ServiceController<T> primaryController;
    private volatile ServiceController<T> backupController;

    public LegacyDistributedSingletonService(SingletonServiceContext context, Service<T> primaryService, Service<T> backupService, Consumer<Singleton> singleton) {
        this(context, primaryService, backupService, singleton, new AtomicReference<PrimaryProxyContext<T>>());
    }

    private LegacyDistributedSingletonService(SingletonServiceContext context, Service<T> primaryService, Service<T> backupService, Consumer<Singleton> singleton, AtomicReference<PrimaryProxyContext<T>> primaryProxyContext) {
        super(context, new ServiceLifecycleFactory<T>(context.getServiceName(), primaryService, backupService != null ? backupService : new PrimaryProxyService(primaryProxyContext::getPlain)), LegacyDistributedSingletonContext::new, singleton);
        primaryProxyContext.setPlain(this);
        this.context = context;
    }

    public ServiceName getServiceName() {
        return this.context.getServiceName();
    }

    public SingletonState getSingletonState() {
        return this.get().getSingletonState();
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        ServiceContainer registry = context.getController().getServiceContainer();
        this.primaryController = registry.getService(this.getServiceName().append(new String[]{"primary"}));
        this.backupController = registry.getService(this.getServiceName().append(new String[]{"backup"}));
        this.started = true;
    }

    @Override
    public void stop(StopContext context) {
        this.started = false;
        super.stop(context);
    }

    public T getValue() {
        while (this.started) {
            try {
                return (T)(this.get().isPrimaryProvider() ? this.primaryController : this.backupController).getValue();
            }
            catch (IllegalStateException e) {
                if (this.get().getServiceProviderRegistration().getProviders().size() < this.context.getQuorum()) {
                    throw SingletonLogger.ROOT_LOGGER.notStarted(this.getServiceName().getCanonicalName());
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw e;
                }
                Thread.yield();
            }
        }
        throw SingletonLogger.ROOT_LOGGER.notStarted(this.getServiceName().getCanonicalName());
    }

    @Override
    public CommandDispatcher<GroupMember, LegacySingletonContext<T>> getCommandDispatcher() {
        return this.get().getCommandDispatcher();
    }

    private static class ServiceLifecycleFactory<T>
    implements Function<ServiceTarget, ServiceValue<T>> {
        private final ServiceName name;
        private final Service<T> primaryService;
        private final Service<T> backupService;

        ServiceLifecycleFactory(ServiceName name, Service<T> primaryService, Service<T> backupService) {
            this.name = name;
            this.primaryService = primaryService;
            this.backupService = backupService;
        }

        @Override
        public ServiceValue<T> apply(ServiceTarget target) {
            LegacyServiceLifecycle primaryLifecycle = new LegacyServiceLifecycle(target.addService(this.name.append(new String[]{"primary"}), this.primaryService).setInitialMode(ServiceController.Mode.NEVER).install());
            LegacyServiceLifecycle backupLifecycle = new LegacyServiceLifecycle(target.addService(this.name.append(new String[]{"backup"}), this.backupService).setInitialMode(ServiceController.Mode.ACTIVE).install());
            return new PrimaryBackupLifecycle(primaryLifecycle, backupLifecycle);
        }
    }

    private static class LegacyServiceLifecycle<T>
    extends ServiceControllerService
    implements ServiceValue<T> {
        private final ServiceController<T> controller;

        public LegacyServiceLifecycle(ServiceController<T> controller) {
            super(controller);
            this.controller = controller;
        }

        public T getValue() {
            return (T)this.controller.getValue();
        }
    }

    private static class PrimaryBackupLifecycle<T>
    implements ServiceValue<T> {
        private final ServiceValue<T> primaryLifecycle;
        private final ServiceValue<T> backupLifecycle;

        PrimaryBackupLifecycle(ServiceValue<T> primaryLifecycle, ServiceValue<T> backupLifecycle) {
            this.primaryLifecycle = primaryLifecycle;
            this.backupLifecycle = backupLifecycle;
        }

        public boolean isStarted() {
            return this.primaryLifecycle.isStarted();
        }

        public void start() {
            this.backupLifecycle.stop();
            this.primaryLifecycle.start();
        }

        public void stop() {
            this.primaryLifecycle.stop();
            this.backupLifecycle.start();
        }

        public T getValue() {
            return (T)this.primaryLifecycle.getValue();
        }
    }
}

