/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.server.dispatcher;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.SerializationContext;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.server.Services;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ForkChannelFactory;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationBuilder;
import org.wildfly.clustering.marshalling.jboss.externalizer.LegacyExternalizerConfiguratorFactory;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.DefaultSerializationContext;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.marshalling.protostream.modules.ModuleClassLoaderMarshaller;
import org.wildfly.clustering.server.dispatcher.Command;
import org.wildfly.clustering.server.jgroups.dispatcher.ChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.JChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.service.Installer;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public enum ChannelCommandDispatcherFactoryServiceInstallerFactory implements Function<String, ServiceInstaller>
{
    INSTANCE;


    @Override
    public ServiceInstaller apply(String name) {
        final ServiceDependency channelFactory = ServiceDependency.on((UnaryServiceDescriptor)ChannelFactory.SERVICE_DESCRIPTOR, (String)name).map(ForkChannelFactory.class::cast);
        final ServiceDependency moduleLoader = ServiceDependency.on((ServiceName)Services.JBOSS_SERVICE_MODULE_LOADER);
        final Function<ClassLoader, ByteBufferMarshaller> marshallerFactory = new Function<ClassLoader, ByteBufferMarshaller>(){

            @Override
            public ByteBufferMarshaller apply(ClassLoader loader) {
                final AtomicBoolean supportsProtoStream = new AtomicBoolean(false);
                ImmutableSerializationContext context = (ImmutableSerializationContext)((SerializationContextBuilder)SerializationContextBuilder.newInstance((ClassLoaderMarshaller)new ModuleClassLoaderMarshaller((ModuleLoader)moduleLoader.get()), ctx -> new DefaultSerializationContext((SerializationContext)ctx){

                    public void registerMarshaller(ProtoStreamMarshaller<?> marshaller) {
                        supportsProtoStream.compareAndSet(false, Command.class.isAssignableFrom(marshaller.getJavaClass()));
                        super.registerMarshaller(marshaller);
                    }
                }).load(loader)).build();
                if (supportsProtoStream.get()) {
                    return new ProtoStreamByteBufferMarshaller(context);
                }
                MarshallingConfigurationBuilder builder = (MarshallingConfigurationBuilder)MarshallingConfigurationBuilder.newInstance((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)((ModuleLoader)moduleLoader.get()))).load(loader);
                MarshallingConfiguration configuration = (MarshallingConfiguration)new LegacyExternalizerConfiguratorFactory(loader).apply(builder).build();
                return new JBossByteBufferMarshaller(configuration, loader);
            }
        };
        final JChannelCommandDispatcherFactory.Configuration configuration = new JChannelCommandDispatcherFactory.Configuration(){

            public JChannel getChannel() {
                return ((ForkChannelFactory)channelFactory.get()).getConfiguration().getChannel();
            }

            public ByteBufferMarshaller getMarshaller() {
                ModuleClassLoader loader = ((ForkChannelFactory)channelFactory.get()).getConfiguration().getChannelConfiguration().getModule().getClassLoader();
                return new ProtoStreamByteBufferMarshaller((ImmutableSerializationContext)((SerializationContextBuilder)SerializationContextBuilder.newInstance((ClassLoaderMarshaller)new ModuleClassLoaderMarshaller((ModuleLoader)moduleLoader.get())).load((ClassLoader)loader)).build());
            }

            public Predicate<Message> getUnknownForkPredicate() {
                return arg_0 -> ((ForkChannelFactory)((ForkChannelFactory)channelFactory.get())).isUnknownForkResponse(arg_0);
            }

            public Function<ClassLoader, ByteBufferMarshaller> getMarshallerFactory() {
                return marshallerFactory;
            }
        };
        Supplier<ChannelCommandDispatcherFactory> factory = new Supplier<ChannelCommandDispatcherFactory>(){

            @Override
            public ChannelCommandDispatcherFactory get() {
                return new JChannelCommandDispatcherFactory(configuration);
            }
        };
        return (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).provides(ServiceNameFactory.resolveServiceName((UnaryServiceDescriptor)ClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY, (String)name))).requires(List.of(channelFactory, moduleLoader))).onStop((java.util.function.Consumer)Consumer.close())).blocking()).startWhen(Installer.StartWhen.AVAILABLE)).build();
    }
}

