/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.security.PrivilegedAction;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.Iterator;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.DefaultExternalizer;
import org.wildfly.security.manager.WildFlySecurityManager;

public class EnumMapExternalizer<E extends Enum<E>>
implements Externalizer<EnumMap<E, Object>> {
    public void writeObject(ObjectOutput output, EnumMap<E, Object> map) throws IOException {
        Class<?> enumClass = this.findEnumClass(map);
        output.writeObject(enumClass);
        ?[] enumValues = enumClass.getEnumConstants();
        BitSet keys = new BitSet(enumValues.length);
        for (int i = 0; i < enumValues.length; ++i) {
            keys.set(i, map.containsKey(enumValues[i]));
        }
        DefaultExternalizer.BIT_SET.writeObject(output, keys);
        for (Object value : map.values()) {
            output.writeObject(value);
        }
    }

    public EnumMap<E, Object> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Class enumClass = (Class)input.readObject();
        BitSet keys = (BitSet)DefaultExternalizer.BIT_SET.cast(BitSet.class).readObject(input);
        EnumMap<Enum, Object> map = new EnumMap<Enum, Object>(enumClass);
        T[] enumValues = enumClass.getEnumConstants();
        for (int i = 0; i < enumValues.length; ++i) {
            if (!keys.get(i)) continue;
            map.put((Enum)enumValues[i], input.readObject());
        }
        return map;
    }

    public Class<EnumMap<E, Object>> getTargetClass() {
        return EnumMap.class;
    }

    private Class<?> findEnumClass(final EnumMap<E, Object> map) {
        Iterator<E> values = map.keySet().iterator();
        if (values.hasNext()) {
            return ((Enum)values.next()).getDeclaringClass();
        }
        return (Class)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    Field field = EnumMap.class.getDeclaredField("keyType");
                    field.setAccessible(true);
                    return (Class)field.get(map);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

