/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Collection;
import java.util.Map;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.AttributeTranslation;
import org.jboss.as.clustering.controller.ManagementRegistrar;
import org.jboss.as.clustering.controller.ReadAttributeTranslationHandler;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.WriteAttributeStepHandler;
import org.jboss.as.clustering.controller.WriteAttributeTranslationHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.operations.global.ListOperations;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.as.controller.operations.global.WriteAttributeHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;

public class ResourceRegistrar
implements ManagementRegistrar<ManagementResourceRegistration> {
    private final AddStepHandlerDescriptor descriptor;
    private final ManagementRegistrar<ManagementResourceRegistration> addRegistration;
    private final ManagementRegistrar<ManagementResourceRegistration> removeRegistration;
    private final ManagementRegistrar<ManagementResourceRegistration> writeAttributeRegistration;

    protected ResourceRegistrar(AddStepHandlerDescriptor descriptor, ResourceServiceHandler handler, ManagementRegistrar<ManagementResourceRegistration> addRegistration, ManagementRegistrar<ManagementResourceRegistration> removeRegistration) {
        this(descriptor, addRegistration, removeRegistration, (ManagementRegistrar<ManagementResourceRegistration>)new WriteAttributeStepHandler(descriptor, handler));
    }

    protected ResourceRegistrar(AddStepHandlerDescriptor descriptor, ManagementRegistrar<ManagementResourceRegistration> addRegistration, ManagementRegistrar<ManagementResourceRegistration> removeRegistration, ManagementRegistrar<ManagementResourceRegistration> writeAttributeRegistration) {
        this.descriptor = descriptor;
        this.addRegistration = addRegistration;
        this.removeRegistration = removeRegistration;
        this.writeAttributeRegistration = writeAttributeRegistration;
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        this.descriptor.getCapabilities().keySet().forEach(arg_0 -> ((ManagementResourceRegistration)registration).registerCapability(arg_0));
        registration.registerRequirements(this.descriptor.getResourceCapabilityReferences());
        this.writeAttributeRegistration.register(registration);
        for (Map.Entry<AttributeDefinition, OperationStepHandler> entry : this.descriptor.getCustomAttributes().entrySet()) {
            registration.registerReadWriteAttribute(entry.getKey(), null, entry.getValue());
        }
        Collection<AttributeDefinition> ignoredAttributes = this.descriptor.getIgnoredAttributes();
        if (!ignoredAttributes.isEmpty()) {
            for (AttributeDefinition attributeDefinition : ignoredAttributes) {
                registration.registerReadWriteAttribute(attributeDefinition, null, ModelOnlyWriteAttributeHandler.INSTANCE);
            }
        }
        for (Map.Entry entry : this.descriptor.getAttributeTranslations().entrySet()) {
            AttributeTranslation translation = (AttributeTranslation)entry.getValue();
            registration.registerReadWriteAttribute((AttributeDefinition)entry.getKey(), (OperationStepHandler)new ReadAttributeTranslationHandler(translation), (OperationStepHandler)new WriteAttributeTranslationHandler(translation));
        }
        this.addRegistration.register(registration);
        this.removeRegistration.register(registration);
        this.registerTransformedOperation(registration, WriteAttributeHandler.DEFINITION, WriteAttributeHandler.INSTANCE);
        this.registerTransformedOperation(registration, MapOperations.MAP_PUT_DEFINITION, MapOperations.MAP_PUT_HANDLER);
        this.registerTransformedOperation(registration, MapOperations.MAP_GET_DEFINITION, MapOperations.MAP_GET_HANDLER);
        this.registerTransformedOperation(registration, MapOperations.MAP_REMOVE_DEFINITION, MapOperations.MAP_REMOVE_HANDLER);
        this.registerTransformedOperation(registration, MapOperations.MAP_CLEAR_DEFINITION, MapOperations.MAP_CLEAR_HANDLER);
        this.registerTransformedOperation(registration, ListOperations.LIST_ADD_DEFINITION, ListOperations.LIST_ADD_HANDLER);
        this.registerTransformedOperation(registration, ListOperations.LIST_GET_DEFINITION, ListOperations.LIST_GET_HANDLER);
        this.registerTransformedOperation(registration, ListOperations.LIST_REMOVE_DEFINITION, ListOperations.LIST_REMOVE_HANDLER);
        this.registerTransformedOperation(registration, ListOperations.LIST_CLEAR_DEFINITION, ListOperations.LIST_CLEAR_HANDLER);
    }

    private void registerTransformedOperation(ManagementResourceRegistration registration, OperationDefinition definition, OperationStepHandler handler) {
        OperationStepHandler transformedHandler = (OperationStepHandler)this.descriptor.getOperationTransformation().apply(handler);
        if (handler != transformedHandler) {
            registration.registerOperationHandler(definition, transformedHandler);
        }
    }
}

