/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.concurrent.TimeUnit;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.PerfHeader;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Average;
import org.jgroups.util.MessageBatch;

@MBean(description="Measures latency between PERF instances")
public class PERF
extends Protocol {
    protected Average avg;
    @Property(description="Number of samples to maintain for rolling average")
    protected int avg_size = 1024;

    @ManagedAttribute(description="Average latency in ns", type=AttributeType.TIME, unit=TimeUnit.NANOSECONDS)
    public double latencyInNs() {
        return this.avg.average();
    }

    @ManagedAttribute(description="Average latency in ms", type=AttributeType.TIME, unit=TimeUnit.MILLISECONDS)
    public double latencyInMs() {
        return this.avg.average() / 1000000.0;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.avg = new Average(this.avg_size);
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.avg.clear();
    }

    @Override
    public Object down(Message msg) {
        msg.putHeader(this.id, new PerfHeader(System.nanoTime()));
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Message msg) {
        PerfHeader hdr = (PerfHeader)msg.getHeader(this.id);
        if (hdr == null) {
            this.log.error("%s: no perf header found", this.local_addr);
        } else {
            long time = System.nanoTime() - hdr.start_time;
            if (time <= 0L) {
                this.log.error("%d: time is <= 0", time);
            } else {
                this.avg.add(time);
            }
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            PerfHeader hdr = (PerfHeader)msg.getHeader(this.id);
            if (hdr == null) {
                this.log.error("%s: no perf header found", this.local_addr);
                continue;
            }
            long time = System.nanoTime() - hdr.start_time;
            if (time <= 0L) {
                this.log.error("%d: time is <= 0", time);
                continue;
            }
            this.avg.add(time);
        }
        super.up(batch);
    }
}

