/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.EnumSet;
import java.util.Map;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;

public class PrefixUtil {
    public static Pair<SimpleString, EnumSet<RoutingType>> getAddressAndRoutingTypes(SimpleString address, EnumSet<RoutingType> defaultRoutingTypes, Map<SimpleString, RoutingType> prefixes) {
        for (Map.Entry<SimpleString, RoutingType> entry : prefixes.entrySet()) {
            if (!address.startsWith(entry.getKey())) continue;
            return new Pair<SimpleString, EnumSet<RoutingType>>(PrefixUtil.removePrefix(address, entry.getKey()), EnumSet.of(entry.getValue()));
        }
        return new Pair<SimpleString, EnumSet<RoutingType>>(address, defaultRoutingTypes);
    }

    public static SimpleString getAddress(SimpleString address, Map<SimpleString, RoutingType> prefixes) {
        for (Map.Entry<SimpleString, RoutingType> entry : prefixes.entrySet()) {
            if (!address.startsWith(entry.getKey())) continue;
            return PrefixUtil.removePrefix(address, entry.getKey());
        }
        return address;
    }

    public static SimpleString getPrefix(SimpleString address, Map<SimpleString, RoutingType> prefixes) {
        for (Map.Entry<SimpleString, RoutingType> entry : prefixes.entrySet()) {
            if (!address.startsWith(entry.getKey())) continue;
            return PrefixUtil.removeAddress(address, entry.getKey());
        }
        return null;
    }

    public static SimpleString removePrefix(SimpleString string, SimpleString prefix) {
        return string.subSeq(prefix.length(), string.length());
    }

    public static SimpleString removeAddress(SimpleString string, SimpleString prefix) {
        return string.subSeq(0, prefix.length());
    }

    public static String removeAddress(String string, String prefix) {
        return string.substring(0, prefix.length());
    }

    public static String removePrefix(String string, String prefix) {
        return string.substring(prefix.length());
    }

    public static String getURIPrefix(String address) {
        int index = address.indexOf("://");
        if (index > 0) {
            return address.substring(0, index + 3);
        }
        return "";
    }
}

