/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfigurationHelper;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.utils.ClassloadingUtil;

public class TransportConfigurationUtil {
    private static final Map<String, Map<String, Object>> DEFAULTS = new HashMap<String, Map<String, Object>>();
    private static final Map<String, Object> EMPTY_HELPER = new HashMap<String, Object>();

    public static Map<String, Object> getDefaults(String className) {
        if (className == null) {
            return new HashMap<String, Object>();
        }
        if (!DEFAULTS.containsKey(className)) {
            Object object = TransportConfigurationUtil.instantiateObject(className, TransportConfigurationHelper.class);
            if (object != null && object instanceof TransportConfigurationHelper) {
                TransportConfigurationHelper helper = (TransportConfigurationHelper)object;
                DEFAULTS.put(className, helper.getDefaults());
            } else {
                DEFAULTS.put(className, EMPTY_HELPER);
            }
        }
        return TransportConfigurationUtil.cloneDefaults(DEFAULTS.get(className));
    }

    private static Object instantiateObject(String className, Class expectedType) {
        return AccessController.doPrivileged(() -> {
            try {
                return ClassloadingUtil.newInstanceFromClassLoader(TransportConfigurationUtil.class, className, expectedType);
            }
            catch (IllegalStateException e) {
                return null;
            }
        });
    }

    private static Map<String, Object> cloneDefaults(Map<String, Object> defaults) {
        HashMap<String, Object> cloned = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : defaults.entrySet()) {
            cloned.put(entry.getKey(), entry.getValue());
        }
        return cloned;
    }

    public static boolean isSameHost(TransportConfiguration tc1, TransportConfiguration tc2) {
        if (NettyConnectorFactory.class.getName().equals(tc1.getFactoryClassName())) {
            String host1 = tc1.getParams().get("host") != null ? tc1.getParams().get("host").toString() : "localhost";
            String host2 = tc2.getParams().get("host") != null ? tc2.getParams().get("host").toString() : "localhost";
            String port1 = String.valueOf(tc1.getParams().get("port") != null ? tc1.getParams().get("port") : Integer.valueOf(61616));
            String port2 = String.valueOf(tc2.getParams().get("port") != null ? tc2.getParams().get("port") : Integer.valueOf(61616));
            return host1.equals(host2) && port1.equals(port2);
        }
        if ("org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory".equals(tc1.getFactoryClassName())) {
            String serverId1 = tc1.getParams().get("serverId") != null ? tc1.getParams().get("serverId").toString() : "0";
            String serverId2 = tc2.getParams().get("serverId") != null ? tc2.getParams().get("serverId").toString() : "0";
            return serverId1.equals(serverId2);
        }
        return false;
    }
}

