/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.CommandExecutor;
import org.jboss.as.cli.gui.ManagementModelNode;
import org.jboss.as.cli.gui.OperationDialog;
import org.jboss.as.cli.gui.metacommand.ExploreNodeAction;
import org.jboss.dmr.ModelNode;

public class OperationMenu
extends JPopupMenu {
    private static final String[] genericOps = new String[]{"add", "read-operation-description", "read-resource-description", "read-operation-names"};
    private static final List<String> genericOpList = Arrays.asList(genericOps);
    private static final String[] leafOps = new String[]{"write-attribute", "undefine-attribute"};
    private static final List<String> leafOpList = Arrays.asList(leafOps);
    private CliGuiContext cliGuiCtx;
    private CommandExecutor executor;
    private JTree invoker;

    public OperationMenu(CliGuiContext cliGuiCtx, JTree invoker) {
        this.cliGuiCtx = cliGuiCtx;
        this.executor = cliGuiCtx.getExecutor();
        this.invoker = invoker;
        this.setLightWeightPopupEnabled(true);
        this.setOpaque(true);
    }

    public void show(ManagementModelNode node, int x, int y) {
        this.removeAll();
        this.addExploreOption(node);
        String addressPath = node.addressPath();
        try {
            ModelNode opNames = this.executor.doCommand(addressPath + ":read-operation-names");
            if (opNames.get("outcome").asString().equals("failed")) {
                return;
            }
            for (ModelNode name : opNames.get("result").asList()) {
                String strName = name.asString();
                if (node.isGeneric() && !genericOpList.contains(strName) || node.isLeaf() && !leafOpList.contains(strName) || !node.isGeneric() && !node.isLeaf() && strName.equals("add")) continue;
                ModelNode opDescription = this.getResourceDescription(addressPath, strName);
                this.add(new OperationAction(node, strName, opDescription));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.show(this.invoker, x, y);
    }

    private void addExploreOption(ManagementModelNode node) {
        if (node.isLeaf()) {
            return;
        }
        this.add(new ExploreNodeAction(this.cliGuiCtx));
        this.addSeparator();
    }

    private ModelNode getResourceDescription(String addressPath, String name) {
        try {
            return this.executor.doCommand(addressPath + ":read-operation-description(name=\"" + name + "\")");
        }
        catch (Exception e) {
            return null;
        }
    }

    private class OperationAction
    extends AbstractAction {
        private ManagementModelNode node;
        private String opName;
        private String addressPath;
        private ModelNode opDescription;
        private String strDescription;

        public OperationAction(ManagementModelNode node, String opName, ModelNode opDescription) {
            super(opName);
            this.node = node;
            this.opName = opName;
            this.addressPath = node.addressPath();
            this.opDescription = opDescription;
            if (opDescription != null) {
                this.strDescription = opDescription.get(new String[]{"result", "description"}).asString();
                this.putValue("ShortDescription", this.strDescription);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JTextComponent cmdText = OperationMenu.this.cliGuiCtx.getCommandLine().getCmdText();
            ModelNode requestProperties = this.opDescription.get(new String[]{"result", "request-properties"});
            if (requestProperties == null || !requestProperties.isDefined() || requestProperties.asList().isEmpty()) {
                cmdText.setText(this.addressPath + ":" + this.opName);
                cmdText.requestFocus();
                return;
            }
            if (this.node.isLeaf() && this.opName.equals("undefine-attribute")) {
                ManagementModelNode.UserObject usrObj = (ManagementModelNode.UserObject)this.node.getUserObject();
                cmdText.setText(this.addressPath + ":" + this.opName + "(name=" + usrObj.getName() + ")");
                cmdText.requestFocus();
                return;
            }
            OperationDialog dialog = new OperationDialog(OperationMenu.this.cliGuiCtx, this.node, this.opName, this.strDescription, requestProperties);
            dialog.setLocationRelativeTo(OperationMenu.this.cliGuiCtx.getMainWindow());
            dialog.setVisible(true);
        }
    }
}

