/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.CLIModelControllerClient;
import org.jboss.as.cli.impl.CommaSeparatedCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;

public class ReloadHandler
extends BaseOperationCommand {
    private final ArgumentWithValue adminOnly = new ArgumentWithValue((CommandHandlerWithArguments)this, SimpleTabCompleter.BOOLEAN, "--admin-only");
    private final ArgumentWithValue useCurrentServerConfig = new ArgumentWithValue(this, SimpleTabCompleter.BOOLEAN, "--use-current-server-config"){

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            if (ctx.isDomainMode()) {
                return false;
            }
            return super.canAppearNext(ctx);
        }
    };
    private final ArgumentWithValue host;
    private final ArgumentWithValue restartServers = new ArgumentWithValue(this, SimpleTabCompleter.BOOLEAN, "--restart-servers"){

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            if (!ctx.isDomainMode()) {
                return false;
            }
            return super.canAppearNext(ctx);
        }
    };
    private final ArgumentWithValue useCurrentDomainConfig = new ArgumentWithValue(this, SimpleTabCompleter.BOOLEAN, "--use-current-domain-config"){

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            if (!ctx.isDomainMode()) {
                return false;
            }
            return super.canAppearNext(ctx);
        }
    };
    private final ArgumentWithValue useCurrentHostConfig = new ArgumentWithValue(this, SimpleTabCompleter.BOOLEAN, "--use-current-host-config"){

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            if (!ctx.isDomainMode()) {
                return false;
            }
            return super.canAppearNext(ctx);
        }
    };

    public ReloadHandler(CommandContext ctx) {
        super(ctx, "reload", true);
        this.host = new ArgumentWithValue(this, new CommaSeparatedCompleter(){

            @Override
            protected Collection<String> getAllCandidates(CommandContext ctx) {
                if (!ctx.isDomainMode()) {
                    return Collections.emptyList();
                }
                ModelControllerClient client = ctx.getModelControllerClient();
                if (client == null) {
                    return Collections.emptyList();
                }
                ModelNode op = new ModelNode();
                op.get("address").setEmptyList();
                op.get("operation").set("read-children-names");
                op.get("child-type").set("host");
                try {
                    ModelNode outcome = client.execute(op);
                    if (Util.isSuccess(outcome)) {
                        return Util.getList(outcome);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return Collections.emptyList();
            }
        }, "--host"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        CLIModelControllerClient cliClient;
        block9: {
            ModelControllerClient client = ctx.getModelControllerClient();
            if (client == null) {
                throw new CommandLineException("Connection is now available.");
            }
            if (!(client instanceof CLIModelControllerClient)) {
                throw new CommandLineException("Unsupported ModelControllerClient implementation " + client.getClass().getName());
            }
            cliClient = (CLIModelControllerClient)client;
            ModelNode op = this.buildRequestWithoutHeaders(ctx);
            try {
                ModelNode response = cliClient.execute(op, true);
                if (!Util.isSuccess(response)) {
                    throw new CommandLineException(Util.getFailureDescription(response));
                }
            }
            catch (IOException e) {
                if (!cliClient.isConnected()) break block9;
                StreamUtils.safeClose((Closeable)((Object)cliClient));
                throw new CommandLineException("Failed to execute :reload", e);
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            throw new CommandLineException("Interrupted while pausing before reconnecting.", e);
        }
        try {
            cliClient.ensureConnected(ctx.getConfig().getConnectionTimeout() + 1000);
        }
        catch (CommandLineException e) {
            ctx.disconnectController();
            throw e;
        }
    }

    @Override
    protected ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        ModelNode op = new ModelNode();
        if (ctx.isDomainMode()) {
            if (this.useCurrentServerConfig.isPresent(args)) {
                throw new CommandFormatException(this.useCurrentServerConfig.getFullName() + " is not allowed in the domain mode.");
            }
            String hostName = this.host.getValue(args);
            if (hostName == null) {
                throw new CommandFormatException("Missing required argument " + this.host.getFullName());
            }
            op.get("address").add("host", hostName);
            this.setBooleanArgument(args, op, this.restartServers, "restart-servers");
            this.setBooleanArgument(args, op, this.useCurrentDomainConfig, "use-current-domain-config");
            this.setBooleanArgument(args, op, this.useCurrentHostConfig, "use-current-host-config");
        } else {
            if (this.host.isPresent(args)) {
                throw new CommandFormatException(this.host.getFullName() + " is not allowed in the standalone mode.");
            }
            if (this.useCurrentDomainConfig.isPresent(args)) {
                throw new CommandFormatException(this.useCurrentDomainConfig.getFullName() + " is not allowed in the standalone mode.");
            }
            if (this.useCurrentHostConfig.isPresent(args)) {
                throw new CommandFormatException(this.useCurrentHostConfig.getFullName() + " is not allowed in the standalone mode.");
            }
            if (this.restartServers.isPresent(args)) {
                throw new CommandFormatException(this.restartServers.getFullName() + " is not allowed in the standalone mode.");
            }
            op.get("address").setEmptyList();
            this.setBooleanArgument(args, op, this.useCurrentServerConfig, "use-current-server-config");
        }
        op.get("operation").set("reload");
        this.setBooleanArgument(args, op, this.adminOnly, "admin-only");
        return op;
    }

    protected void setBooleanArgument(ParsedCommandLine args, ModelNode op, ArgumentWithValue arg, String paramName) throws CommandFormatException {
        if (!arg.isPresent(args)) {
            return;
        }
        String value = arg.getValue(args);
        if (value == null) {
            throw new CommandFormatException(arg.getFullName() + " is missing value.");
        }
        if (value.equalsIgnoreCase("true")) {
            op.get(paramName).set(true);
        } else if (value.equalsIgnoreCase("false")) {
            op.get(paramName).set(false);
        } else {
            throw new CommandFormatException("Invalid value for " + arg.getFullName() + ": '" + value + "'");
        }
    }
}

