/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.arquillian.testenricher.osgi.BundleContextAssociation;
import org.jboss.as.arquillian.service.ArquillianConfig;
import org.jboss.as.arquillian.service.ArquillianConfigBuilder;
import org.jboss.as.arquillian.service.ContextManager;
import org.jboss.as.arquillian.service.ContextManagerBuilder;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ArquillianService
implements Service<ArquillianService> {
    public static final String TEST_CLASS_PROPERTY = "org.jboss.as.arquillian.testClass";
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"arquillian", "testrunner"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.arquillian");
    private final InjectedValue<MBeanServer> injectedMBeanServer = new InjectedValue();
    private final Set<ArquillianConfig> deployedTests = new HashSet<ArquillianConfig>();
    private ServiceContainer serviceContainer;
    private ServiceTarget serviceTarget;
    private JMXTestRunner jmxTestRunner;
    AbstractServiceListener<Object> listener;

    public static void addService(ServiceTarget serviceTarget) {
        ArquillianService service = new ArquillianService();
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, service.injectedMBeanServer);
        builder.install();
    }

    ServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }

    public synchronized void start(StartContext context) throws StartException {
        log.debugf("Starting Arquillian Test Runner", new Object[0]);
        MBeanServer mbeanServer = (MBeanServer)this.injectedMBeanServer.getValue();
        this.serviceContainer = context.getController().getServiceContainer();
        this.serviceTarget = context.getChildTarget();
        try {
            this.jmxTestRunner = new ExtendedJMXTestRunner();
            this.jmxTestRunner.registerMBean(mbeanServer);
        }
        catch (Throwable t) {
            throw new StartException("Failed to start Arquillian Test Runner", t);
        }
        final ArquillianService arqService = this;
        this.listener = new AbstractServiceListener<Object>(){

            public void transition(ServiceController<? extends Object> serviceController, ServiceController.Transition transition) {
                switch (transition.getAfter()) {
                    case UP: {
                        DeploymentUnit depUnit;
                        ServiceController parentController;
                        ServiceName parentName;
                        ServiceName serviceName = serviceController.getName();
                        String simpleName = serviceName.getSimpleName();
                        if (Services.JBOSS_DEPLOYMENT.isParentOf(serviceName) && simpleName.equals(Phase.INSTALL.toString())) {
                            parentName = serviceName.getParent();
                            parentController = ArquillianService.this.serviceContainer.getService(parentName);
                            depUnit = (DeploymentUnit)parentController.getValue();
                            ArquillianConfig arqConfig = ArquillianConfigBuilder.processDeployment(arqService, depUnit);
                            if (arqConfig != null) {
                                log.infof("Arquillian deployment detected: %s", (Object)arqConfig);
                                ServiceBuilder<ArquillianConfig> builder = arqConfig.buildService(ArquillianService.this.serviceTarget, serviceController);
                                builder.install();
                            }
                        }
                    }
                    case STARTING: {
                        ServiceName serviceName = serviceController.getName();
                        String simpleName = serviceName.getSimpleName();
                        if (!Services.JBOSS_DEPLOYMENT.isParentOf(serviceName) || !simpleName.equals(Phase.DEPENDENCIES.toString())) break;
                        ServiceName parentName = serviceName.getParent();
                        ServiceController parentController = ArquillianService.this.serviceContainer.getService(parentName);
                        DeploymentUnit depUnit = (DeploymentUnit)parentController.getValue();
                        ArquillianConfigBuilder.handleParseAnnotations(depUnit);
                    }
                }
            }
        };
        this.serviceContainer.addListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(StopContext context) {
        log.debugf("Stopping Arquillian Test Runner", new Object[0]);
        try {
            if (this.jmxTestRunner != null) {
                this.jmxTestRunner.unregisterMBean((MBeanServer)this.injectedMBeanServer.getValue());
            }
        }
        catch (Exception ex) {
            log.errorf((Throwable)ex, "Cannot stop Arquillian Test Runner", new Object[0]);
        }
        finally {
            context.getController().getServiceContainer().removeListener(this.listener);
        }
    }

    public synchronized ArquillianService getValue() throws IllegalStateException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerArquillianConfig(ArquillianConfig arqConfig) {
        Set<ArquillianConfig> set = this.deployedTests;
        synchronized (set) {
            log.debugf("Register Arquillian config: %s", (Object)arqConfig.getServiceName());
            this.deployedTests.add(arqConfig);
            this.deployedTests.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterArquillianConfig(ArquillianConfig arqConfig) {
        Set<ArquillianConfig> set = this.deployedTests;
        synchronized (set) {
            log.debugf("Unregister Arquillian config: %s", (Object)arqConfig.getServiceName());
            this.deployedTests.remove(arqConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArquillianConfig getArquillianConfig(String className, long timeout) {
        Set<ArquillianConfig> set = this.deployedTests;
        synchronized (set) {
            log.debugf("Getting Arquillian config for: %s", (Object)className);
            for (ArquillianConfig arqConfig : this.deployedTests) {
                for (String aux : arqConfig.getTestClasses()) {
                    if (!aux.equals(className)) continue;
                    log.debugf("Found Arquillian config for: %s", (Object)className);
                    return arqConfig;
                }
            }
            if (timeout <= 0L) {
                throw new IllegalStateException("Cannot obtain Arquillian config for: " + className);
            }
            try {
                log.debugf("Waiting on Arquillian config for: %s", (Object)className);
                this.deployedTests.wait(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return this.getArquillianConfig(className, -1L);
    }

    private static final class TCCLSetupAction
    implements SetupAction {
        private final ThreadLocal<ClassLoader> oldClassLoader = new ThreadLocal();
        private final ClassLoader classLoader;

        TCCLSetupAction(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public int priority() {
            return 10000;
        }

        public Set<ServiceName> dependencies() {
            return Collections.emptySet();
        }

        public void setup(Map<String, Object> properties) {
            this.oldClassLoader.set(WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader));
        }

        public void teardown(Map<String, Object> properties) {
            ClassLoader old = this.oldClassLoader.get();
            this.oldClassLoader.remove();
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
        }
    }

    class ExtendedTestClassLoader
    implements JMXTestRunner.TestClassLoader {
        ExtendedTestClassLoader() {
        }

        public Class<?> loadTestClass(String className) throws ClassNotFoundException {
            ArquillianConfig arqConfig = ArquillianService.this.getArquillianConfig(className, -1L);
            if (arqConfig == null) {
                throw new ClassNotFoundException("No Arquillian config found for: " + className);
            }
            BundleContext bundleContext = arqConfig.getBundleContext();
            BundleContextAssociation.setBundleContext((BundleContext)bundleContext);
            return arqConfig.loadClass(className);
        }
    }

    class ExtendedJMXTestRunner
    extends JMXTestRunner {
        ExtendedJMXTestRunner() {
            super((JMXTestRunner.TestClassLoader)new ExtendedTestClassLoader());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] runTestMethod(String className, String methodName) {
            ArquillianConfig arqConfig = ArquillianService.this.getArquillianConfig(className, 30000L);
            Map<String, Object> properties = Collections.singletonMap(ArquillianService.TEST_CLASS_PROPERTY, className);
            ContextManager contextManager = this.initializeContextManager(arqConfig, properties);
            try {
                byte[] byArray = super.runTestMethod(className, methodName);
                return byArray;
            }
            finally {
                contextManager.teardown(properties);
            }
        }

        private ContextManager initializeContextManager(ArquillianConfig config, Map<String, Object> properties) {
            ContextManagerBuilder builder = new ContextManagerBuilder();
            DeploymentUnit depUnit = config.getDeploymentUnit();
            Module module = (Module)depUnit.getAttachment(Attachments.MODULE);
            Bundle bundle = ArquillianConfig.getAssociatedBundle(module);
            if (bundle == null && module != null) {
                builder.add(new TCCLSetupAction((ClassLoader)module.getClassLoader()));
            }
            builder.addAll(depUnit);
            ContextManager contextManager = builder.build();
            contextManager.setup(properties);
            return contextManager;
        }
    }
}

