/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.embedded;

import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;
import org.jboss.as.arquillian.container.CommonDeployableContainer;
import org.jboss.as.arquillian.container.embedded.EmbeddedContainerConfiguration;
import org.jboss.as.arquillian.container.embedded.SecurityActions;
import org.jboss.as.embedded.EmbeddedServerFactory;
import org.jboss.as.embedded.StandaloneServer;

public final class EmbeddedDeployableContainer
extends CommonDeployableContainer<EmbeddedContainerConfiguration> {
    private StandaloneServer server;

    public void setup(EmbeddedContainerConfiguration config) {
        super.setup((CommonContainerConfiguration)config);
        if (config.getCleanServerBaseDir() != null) {
            SecurityActions.setSystemProperty("jboss.embedded.root", config.getCleanServerBaseDir());
        }
        this.server = EmbeddedServerFactory.create((String)config.getJbossHome(), (String)config.getModulePath(), (String)config.getBundlePath(), (String[])new String[0]);
    }

    public Class<EmbeddedContainerConfiguration> getConfigurationClass() {
        return EmbeddedContainerConfiguration.class;
    }

    protected void startInternal() throws LifecycleException {
        try {
            this.server.start();
        }
        catch (Throwable e) {
            throw new LifecycleException("Could not invoke start on: " + this.server, e);
        }
    }

    protected void stopInternal() throws LifecycleException {
        try {
            this.server.stop();
        }
        catch (Throwable e) {
            throw new LifecycleException("Could not invoke stop on: " + this.server, e);
        }
    }
}

