/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.asn1;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedList;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.asn1.ASN1;
import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.asn1.ElytronMessages;

public class DEREncoder
implements ASN1Encoder {
    private static final int[] BITS = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private static final long LARGEST_UNSHIFTED_LONG = 0xCCCCCCCCCCCCCCCL;
    private static final byte[] NULL_CONTENTS = new byte[0];
    private static final TagComparator TAG_COMPARATOR = new TagComparator();
    private static final LexicographicComparator LEXICOGRAPHIC_COMPARATOR = new LexicographicComparator();
    private static final byte[] BOOLEAN_TRUE_AS_BYTES = new byte[]{-1};
    private static final byte[] BOOLEAN_FALSE_AS_BYTES = new byte[]{0};
    private final ArrayDeque<EncoderState> states = new ArrayDeque();
    private final ArrayList<ByteStringBuilder> buffers = new ArrayList();
    private ByteStringBuilder currentBuffer;
    private int currentBufferPos = -1;
    private final ByteStringBuilder target;
    private int implicitTag = -1;
    private static final Charset UTF_32BE = Charset.forName("UTF-32BE");
    private static final DateTimeFormatter GENERALIZED_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmssX");
    private static final BigInteger[] digits = new BigInteger[]{BigInteger.ZERO, BigInteger.ONE, BigInteger.valueOf(2L), BigInteger.valueOf(3L), BigInteger.valueOf(4L), BigInteger.valueOf(5L), BigInteger.valueOf(6L), BigInteger.valueOf(7L), BigInteger.valueOf(8L), BigInteger.valueOf(9L)};

    public DEREncoder() {
        this(new ByteStringBuilder());
    }

    DEREncoder(ByteStringBuilder target) {
        this.target = target;
        this.currentBuffer = target;
    }

    @Override
    public void startSequence() {
        this.startConstructedElement(48);
    }

    @Override
    public void startSet() {
        this.startConstructedElement(49);
    }

    @Override
    public void startSetOf() {
        this.startSet();
    }

    @Override
    public void startExplicit(int number) {
        this.startExplicit(128, number);
    }

    @Override
    public void startExplicit(int clazz, int number) {
        int explicitTag = clazz | 0x20 | number;
        this.startConstructedElement(explicitTag);
    }

    private void startConstructedElement(int tag) {
        EncoderState lastState = this.states.peekLast();
        if (lastState != null && lastState.getTag() == 49) {
            this.updateCurrentBuffer();
            lastState.addChildElement(tag, this.currentBufferPos);
        }
        this.writeTag(tag, this.currentBuffer);
        if (tag != 49) {
            this.updateCurrentBuffer();
        }
        this.states.add(new EncoderState(tag, this.currentBufferPos));
    }

    @Override
    public void endSequence() throws IllegalStateException {
        EncoderState lastState = this.states.peekLast();
        if (lastState == null || lastState.getTag() != 48) {
            throw ElytronMessages.log.noSequenceToEnd();
        }
        this.endConstructedElement();
    }

    @Override
    public void endExplicit() throws IllegalStateException {
        EncoderState lastState = this.states.peekLast();
        if (lastState == null || lastState.getTag() == 48 || lastState.getTag() == 49 || (lastState.getTag() & 0x20) == 0) {
            throw ElytronMessages.log.noExplicitlyTaggedElementToEnd();
        }
        this.endConstructedElement();
    }

    private void endConstructedElement() {
        ByteStringBuilder dest = this.currentBufferPos > 0 ? this.buffers.get(this.currentBufferPos - 1) : this.target;
        int length = this.currentBuffer.length();
        int numLengthOctets = this.writeLength(length, dest);
        dest.append(this.currentBuffer);
        this.currentBuffer.setLength(0);
        this.currentBuffer = dest;
        --this.currentBufferPos;
        this.states.removeLast();
        EncoderState lastState = this.states.peekLast();
        if (lastState != null && lastState.getTag() == 49) {
            lastState.addChildLength(1 + numLengthOctets + length);
        }
    }

    @Override
    public void endSet() throws IllegalStateException {
        this.endSet(TAG_COMPARATOR);
    }

    @Override
    public void endSetOf() throws IllegalStateException {
        this.endSet(LEXICOGRAPHIC_COMPARATOR);
    }

    private void endSet(Comparator<EncoderState> comparator) {
        EncoderState lastState = this.states.peekLast();
        if (lastState == null || lastState.getTag() != 49) {
            throw ElytronMessages.log.noSetToEnd();
        }
        LinkedList<EncoderState> childElements = lastState.getSortedChildElements(comparator);
        int setBufferPos = lastState.getBufferPos();
        ByteStringBuilder dest = setBufferPos >= 0 ? this.buffers.get(setBufferPos) : this.target;
        int childLength = lastState.getChildLength();
        int numLengthOctets = this.writeLength(lastState.getChildLength(), dest);
        for (EncoderState element : childElements) {
            ByteStringBuilder contents = this.buffers.get(element.getBufferPos());
            dest.append(contents);
            contents.setLength(0);
        }
        this.currentBuffer = dest;
        this.currentBufferPos = setBufferPos;
        this.states.removeLast();
        lastState = this.states.peekLast();
        if (lastState != null && lastState.getTag() == 49) {
            lastState.addChildLength(1 + numLengthOctets + childLength);
        }
    }

    @Override
    public void encodeOctetString(String str) {
        this.encodeOctetString(str.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void encodeOctetString(byte[] str) {
        this.writeElement(4, str);
    }

    void encodeOctetString(ByteStringBuilder str) {
        this.writeElement(4, str);
    }

    @Override
    public void encodeIA5String(String str) {
        this.encodeIA5String(str.getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public void encodeIA5String(byte[] str) {
        this.writeElement(22, str);
    }

    void encodeIA5String(ByteStringBuilder str) {
        this.writeElement(22, str);
    }

    @Override
    public void encodePrintableString(byte[] str) {
        for (byte b : str) {
            ASN1.validatePrintableByte(b & 0xFF);
        }
        this.writeElement(19, str);
    }

    @Override
    public void encodePrintableString(String str) {
        int i = 0;
        while (i < str.length()) {
            ASN1.validatePrintableByte(str.codePointAt(i));
            i = str.offsetByCodePoints(i, 1);
        }
        this.writeElement(19, str.getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public void encodeUTF8String(String str) {
        this.writeElement(12, str.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void encodeBMPString(String str) {
        this.writeElement(30, str.getBytes(StandardCharsets.UTF_16BE));
    }

    @Override
    public void encodeUniversalString(String str) {
        this.writeElement(28, str.getBytes(UTF_32BE));
    }

    @Override
    public void encodeBitString(byte[] str) {
        this.encodeBitString(str, 0);
    }

    @Override
    public void encodeBitString(byte[] str, int numUnusedBits) {
        byte[] contents = new byte[str.length + 1];
        contents[0] = (byte)numUnusedBits;
        System.arraycopy(str, 0, contents, 1, str.length);
        this.writeElement(3, contents);
    }

    @Override
    public void encodeBitString(EnumSet<?> enumSet) {
        BitSet bitSet = new BitSet();
        for (Enum anEnum : enumSet) {
            int ord = anEnum.ordinal();
            bitSet.set(ord);
        }
        this.encodeBitString(bitSet);
    }

    @Override
    public void encodeBitString(BitSet bitSet) {
        byte[] array = bitSet.toByteArray();
        int unusedBits = -bitSet.length() & 7;
        for (int i = 0; i < array.length; ++i) {
            array[i] = (byte)(Integer.reverse(array[i]) >> 24);
        }
        this.encodeBitString(array, unusedBits);
    }

    @Override
    public void encodeBitString(String binaryStr) {
        int numBits = binaryStr.length();
        int numBytes = numBits >> 3;
        int remainder = numBits % 8;
        int numUnusedBits = 0;
        if (remainder != 0) {
            ++numBytes;
            numUnusedBits = 8 - remainder;
        }
        byte[] contents = new byte[numBytes + 1];
        contents[0] = (byte)numUnusedBits;
        for (int i = 1; i <= numBytes; ++i) {
            contents[i] = 0;
        }
        char[] binaryStrChars = binaryStr.toCharArray();
        int index = 0;
        for (int i = 1; i <= numBytes && index < numBits; ++i) {
            for (int bit = 7; bit >= 0 && index < numBits; --bit) {
                if (i == numBytes && bit < numUnusedBits || binaryStrChars[index++] != '1') continue;
                int n = i;
                contents[n] = (byte)(contents[n] | BITS[bit]);
            }
        }
        this.writeElement(3, contents);
    }

    @Override
    public void encodeBitString(BigInteger integer) {
        ByteStringBuilder target = new ByteStringBuilder();
        new DEREncoder(target).encodeInteger(integer);
        this.encodeBitString(target.toArray());
    }

    @Override
    public void encodeGeneralizedTime(ZonedDateTime time) {
        this.writeElement(24, GENERALIZED_TIME_FORMAT.format(time).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void encodeObjectIdentifier(String objectIdentifier) throws ASN1Exception {
        char c;
        if (objectIdentifier == null || objectIdentifier.length() == 0) {
            throw ElytronMessages.log.asnOidMustHaveAtLeast2Components();
        }
        int len = objectIdentifier.length();
        int offs = 0;
        int idx = 0;
        long t = 0L;
        int numComponents = 0;
        int first = -1;
        ByteStringBuilder contents = new ByteStringBuilder();
        block0: while (true) {
            if (Character.isDigit(c = objectIdentifier.charAt(offs + idx++))) {
                int digit = Character.digit(c, 10);
                if (t > 0xCCCCCCCCCCCCCCCL) {
                    BigInteger bi = BigInteger.valueOf(t).multiply(BigInteger.TEN).add(digits[digit]);
                    t = 0L;
                    do {
                        if (!Character.isDigit(c = objectIdentifier.charAt(offs + idx++))) {
                            if (c == '.') {
                                if (numComponents == 0) {
                                    first = this.validateFirstOIDComponent(bi);
                                } else {
                                    this.encodeOIDComponent(bi, contents, numComponents, first);
                                }
                                ++numComponents;
                                continue block0;
                            }
                            throw ElytronMessages.log.asnInvalidOidCharacter();
                        }
                        digit = Character.digit(c, 10);
                        bi = bi.multiply(BigInteger.TEN).add(digits[digit]);
                    } while (idx != len);
                    if (numComponents == 0) {
                        throw ElytronMessages.log.asnOidMustHaveAtLeast2Components();
                    }
                    this.encodeOIDComponent(bi, contents, numComponents, first);
                    this.writeElement(6, contents);
                    return;
                }
                t = 10L * t + (long)digit;
            } else if (c == '.') {
                if (numComponents == 0) {
                    first = this.validateFirstOIDComponent(t);
                } else {
                    this.encodeOIDComponent(t, contents, numComponents, first);
                }
                ++numComponents;
                t = 0L;
            } else {
                throw ElytronMessages.log.asnInvalidOidCharacter();
            }
            if (idx == len) break;
        }
        if (c == '.') {
            throw ElytronMessages.log.asnInvalidOidCharacter();
        }
        if (numComponents == 0) {
            throw ElytronMessages.log.asnOidMustHaveAtLeast2Components();
        }
        this.encodeOIDComponent(t, contents, numComponents, first);
        this.writeElement(6, contents);
    }

    @Override
    public void encodeNull() {
        this.writeElement(5, NULL_CONTENTS);
    }

    @Override
    public void encodeImplicit(int number) {
        this.encodeImplicit(128, number);
    }

    @Override
    public void encodeImplicit(int clazz, int number) {
        if (this.implicitTag == -1) {
            this.implicitTag = clazz | number;
        }
    }

    @Override
    public void encodeBoolean(boolean value) {
        this.writeElement(1, value ? BOOLEAN_TRUE_AS_BYTES : BOOLEAN_FALSE_AS_BYTES);
    }

    @Override
    public void encodeInteger(BigInteger integer) {
        this.writeElement(2, integer.toByteArray());
    }

    @Override
    public void writeEncoded(byte[] encoded) {
        EncoderState lastState = this.states.peekLast();
        if (lastState != null && lastState.getTag() == 49) {
            this.updateCurrentBuffer();
            lastState.addChildElement(encoded[0], this.currentBufferPos);
        }
        if (this.implicitTag != -1) {
            this.writeTag(encoded[0], this.currentBuffer);
            this.currentBuffer.append(encoded, 1, encoded.length - 1);
        } else {
            this.currentBuffer.append(encoded);
        }
        if (lastState != null && lastState.getTag() == 49) {
            lastState.addChildLength(this.currentBuffer.length());
        }
    }

    @Override
    public void flush() {
        while (!this.states.isEmpty()) {
            EncoderState lastState = this.states.peekLast();
            if (lastState.getTag() == 48) {
                this.endSequence();
                continue;
            }
            if (lastState.getTag() != 49) continue;
            this.endSet();
        }
    }

    @Override
    public byte[] getEncoded() {
        return this.target.toArray();
    }

    private int validateFirstOIDComponent(long value) throws ASN1Exception {
        if (value < 0L || value > 2L) {
            throw ElytronMessages.log.asnInvalidValueForFirstOidComponent();
        }
        return (int)value;
    }

    private int validateFirstOIDComponent(BigInteger value) throws ASN1Exception {
        if (value.compareTo(BigInteger.valueOf(0L)) == -1 || value.compareTo(BigInteger.valueOf(2L)) == 1) {
            throw ElytronMessages.log.asnInvalidValueForFirstOidComponent();
        }
        return value.intValue();
    }

    private void validateSecondOIDComponent(long second, int first) throws ASN1Exception {
        if (first < 2 && second > 39L) {
            throw ElytronMessages.log.asnInvalidValueForSecondOidComponent();
        }
    }

    private void validateSecondOIDComponent(BigInteger second, int first) throws ASN1Exception {
        if (first < 2 && second.compareTo(BigInteger.valueOf(39L)) == 1) {
            throw ElytronMessages.log.asnInvalidValueForSecondOidComponent();
        }
    }

    private void encodeOIDComponent(long value, ByteStringBuilder contents, int numComponents, int first) throws ASN1Exception {
        if (numComponents == 1) {
            this.validateSecondOIDComponent(value, first);
            this.encodeOIDComponent(value + (long)(40 * first), contents);
        } else {
            this.encodeOIDComponent(value, contents);
        }
    }

    private void encodeOIDComponent(BigInteger value, ByteStringBuilder contents, int numComponents, int first) throws ASN1Exception {
        if (numComponents == 1) {
            this.validateSecondOIDComponent(value, first);
            this.encodeOIDComponent(value.add(BigInteger.valueOf(40 * first)), contents);
        } else {
            this.encodeOIDComponent(value, contents);
        }
    }

    private void encodeOIDComponent(long value, ByteStringBuilder contents) {
        int octet;
        for (int shift = 56; shift > 0; shift -= 7) {
            if (value < 1L << shift) continue;
            octet = (int)(value >>> shift | 0x80L);
            contents.append((byte)octet);
        }
        octet = (int)(value & 0x7FL);
        contents.append((byte)octet);
    }

    private void encodeOIDComponent(BigInteger value, ByteStringBuilder contents) {
        int numBytes = (value.bitLength() + 6) / 7;
        if (numBytes == 0) {
            contents.append((byte)0);
        } else {
            byte[] result = new byte[numBytes];
            BigInteger currValue = value;
            for (int i = numBytes - 1; i >= 0; --i) {
                result[i] = (byte)(currValue.intValue() & 0x7F | 0x80);
                currValue = currValue.shiftRight(7);
            }
            int n = numBytes - 1;
            result[n] = (byte)(result[n] & 0x7F);
            contents.append(result);
        }
    }

    private void writeTag(int tag, ByteStringBuilder dest) {
        int constructed = tag & 0x20;
        if (this.implicitTag != -1) {
            tag = this.implicitTag | constructed;
            this.implicitTag = -1;
        }
        int tagClass = tag & 0xC0;
        int tagNumber = tag & 0x1F;
        if (tagNumber < 31) {
            dest.append((byte)(tagClass | constructed | tagNumber));
        } else {
            dest.append((byte)(tagClass | constructed | 0x1F));
            if (tagNumber < 128) {
                dest.append((byte)tagNumber);
            } else {
                int octet;
                for (int shift = 28; shift > 0; shift -= 7) {
                    if (tagNumber < 1 << shift) continue;
                    octet = tagNumber >>> shift | 0x80;
                    dest.append((byte)octet);
                }
                octet = tagNumber & 0x7F;
                dest.append((byte)octet);
            }
        }
    }

    private int writeLength(int length, ByteStringBuilder dest) throws ASN1Exception {
        int numLengthOctets;
        if (length < 0) {
            throw ElytronMessages.log.asnInvalidLength();
        }
        if (length <= 127) {
            numLengthOctets = 1;
        } else {
            numLengthOctets = 1;
            int value = length;
            while ((value >>>= 8) != 0) {
                ++numLengthOctets;
            }
        }
        if (length > 127) {
            dest.append((byte)(numLengthOctets | 0x80));
        }
        for (int i = (numLengthOctets - 1) * 8; i >= 0; i -= 8) {
            dest.append((byte)(length >> i));
        }
        if (length > 127) {
            return 1 + numLengthOctets;
        }
        return numLengthOctets;
    }

    private void updateCurrentBuffer() {
        ++this.currentBufferPos;
        if (this.currentBufferPos < this.buffers.size()) {
            this.currentBuffer = this.buffers.get(this.currentBufferPos);
        } else {
            ByteStringBuilder buffer = new ByteStringBuilder();
            this.buffers.add(buffer);
            this.currentBuffer = buffer;
        }
    }

    private void writeElement(int tag, byte[] contents) {
        EncoderState lastState = this.states.peekLast();
        if (lastState != null && lastState.getTag() == 49) {
            this.updateCurrentBuffer();
            lastState.addChildElement(tag, this.currentBufferPos);
        }
        this.writeTag(tag, this.currentBuffer);
        this.writeLength(contents.length, this.currentBuffer);
        this.currentBuffer.append(contents);
        if (lastState != null && lastState.getTag() == 49) {
            lastState.addChildLength(this.currentBuffer.length());
        }
    }

    private void writeElement(int tag, ByteStringBuilder contents) {
        EncoderState lastState = this.states.peekLast();
        if (lastState != null && lastState.getTag() == 49) {
            this.updateCurrentBuffer();
            lastState.addChildElement(tag, this.currentBufferPos);
        }
        this.writeTag(tag, this.currentBuffer);
        this.writeLength(contents.length(), this.currentBuffer);
        this.currentBuffer.append(contents);
        if (lastState != null && lastState.getTag() == 49) {
            lastState.addChildLength(this.currentBuffer.length());
        }
    }

    private static class LexicographicComparator
    implements Comparator<EncoderState> {
        private LexicographicComparator() {
        }

        @Override
        public int compare(EncoderState state1, EncoderState state2) {
            ByteStringBuilder bytes1 = state1.getBuffer();
            ByteStringBuilder bytes2 = state2.getBuffer();
            ByteIterator bi1 = bytes1.iterate();
            ByteIterator bi2 = bytes2.iterate();
            while (bi1.hasNext() && bi2.hasNext()) {
                int diff = (bi1.next() & 0xFF) - (bi2.next() & 0xFF);
                if (diff == 0) continue;
                return diff;
            }
            return bytes1.length() - bytes2.length();
        }
    }

    private static class TagComparator
    implements Comparator<EncoderState> {
        private TagComparator() {
        }

        @Override
        public int compare(EncoderState state1, EncoderState state2) {
            return (state1.getTag() | 0x20) - (state2.getTag() | 0x20);
        }
    }

    private class EncoderState {
        private final int tag;
        private final int bufferPos;
        private LinkedList<EncoderState> childElements = new LinkedList();
        private int childLength = 0;

        public EncoderState(int tag, int bufferPos) {
            this.tag = tag;
            this.bufferPos = bufferPos;
        }

        public int getTag() {
            return this.tag;
        }

        public int getBufferPos() {
            return this.bufferPos;
        }

        public ByteStringBuilder getBuffer() {
            return (ByteStringBuilder)DEREncoder.this.buffers.get(this.getBufferPos());
        }

        public int getChildLength() {
            return this.childLength;
        }

        public LinkedList<EncoderState> getSortedChildElements(Comparator<EncoderState> comparator) {
            Collections.sort(this.childElements, comparator);
            return this.childElements;
        }

        public void addChildElement(int tag, int bufferPos) {
            this.childElements.add(new EncoderState(tag, bufferPos));
        }

        public void addChildLength(int length) {
            this.childLength += length;
        }
    }
}

