/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.RequestInformationCallback;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.HttpServerRequest;

public class SetRequestInformationCallbackMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private final HttpServerAuthenticationMechanismFactory delegate;
    private final HashMap<String, Function<HttpServerRequest, String>> httpServerRequestInformationMap;

    public SetRequestInformationCallbackMechanismFactory(HttpServerAuthenticationMechanismFactory delegate, HashMap<String, Function<HttpServerRequest, String>> httpServerRequestInformationMap) {
        this.delegate = (HttpServerAuthenticationMechanismFactory)Assert.checkNotNullParam((String)"delegate", (Object)delegate);
        this.httpServerRequestInformationMap = (HashMap)Assert.checkNotNullParam((String)"httpServerRequestInformationMap", httpServerRequestInformationMap);
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        return this.delegate.getMechanismNames(properties);
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, final CallbackHandler callbackHandler) throws HttpAuthenticationException {
        final HttpServerAuthenticationMechanism mechanism = this.delegate.createAuthenticationMechanism(mechanismName, properties, callbackHandler);
        return mechanism != null ? new HttpServerAuthenticationMechanism(){

            @Override
            public String getMechanismName() {
                return mechanism.getMechanismName();
            }

            @Override
            public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
                try {
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    for (Map.Entry entry : SetRequestInformationCallbackMechanismFactory.this.httpServerRequestInformationMap.entrySet()) {
                        props.put((String)entry.getKey(), ((Function)entry.getValue()).apply(request));
                    }
                    callbackHandler.handle(new Callback[]{new RequestInformationCallback(props)});
                }
                catch (IOException | UnsupportedCallbackException e) {
                    throw new HttpAuthenticationException(e);
                }
                mechanism.evaluateRequest(request);
            }

            @Override
            public void dispose() {
                mechanism.dispose();
            }
        } : null;
    }
}

