/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.Provider;
import java.util.Properties;
import java.util.function.Supplier;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.ldap.DelegatingLdapContext;
import org.wildfly.security.auth.realm.ldap.ElytronMessages;
import org.wildfly.security.auth.realm.ldap.EvidenceVerifier;
import org.wildfly.security.auth.realm.ldap.IdentityEvidenceVerifier;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

class DirectEvidenceVerifier
implements EvidenceVerifier {
    private final boolean allowBlankPassword;

    DirectEvidenceVerifier(boolean allowBlankPassword) {
        this.allowBlankPassword = allowBlankPassword;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return evidenceType == PasswordGuessEvidence.class ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    @Override
    public IdentityEvidenceVerifier forIdentity(final DirContext dirContext, final String distinguishedName, final String url, Attributes attributes) throws RealmUnavailableException {
        return new IdentityEvidenceVerifier(){

            @Override
            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName, Supplier<Provider[]> providers) throws RealmUnavailableException {
                return evidenceType == PasswordGuessEvidence.class && dirContext instanceof LdapContext ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
            }

            @Override
            public boolean verifyEvidence(Evidence evidence, Supplier<Provider[]> providers) throws RealmUnavailableException {
                if (evidence instanceof PasswordGuessEvidence) {
                    char[] password = ((PasswordGuessEvidence)evidence).getGuess();
                    try {
                        if (!DirectEvidenceVerifier.this.allowBlankPassword && password.length == 0) {
                            ElytronMessages.log.debugf("Credential direct evidence verification does not allow blank password.", new Object[0]);
                            boolean bl = false;
                            return bl;
                        }
                        if (url != null) {
                            URI uri = new URI(url);
                            String namingProviderURL = uri.getScheme() + "://" + uri.getAuthority();
                            Properties props = new Properties();
                            dirContext.getEnvironment().forEach(props::put);
                            props.put("java.naming.provider.url", namingProviderURL);
                            props.put("java.naming.security.principal", distinguishedName);
                            props.put("java.naming.security.credentials", password);
                            LdapContext userContext = dirContext instanceof DelegatingLdapContext ? ((DelegatingLdapContext)dirContext).newInitialLdapContext(props, null) : new InitialLdapContext(props, null);
                            userContext.close();
                        } else {
                            LdapContext userContext = ((LdapContext)dirContext).newInstance(null);
                            userContext.addToEnvironment("java.naming.security.principal", distinguishedName);
                            userContext.addToEnvironment("java.naming.security.credentials", password);
                            userContext.reconnect(null);
                            userContext.close();
                        }
                        boolean userContext = true;
                        return userContext;
                    }
                    catch (AuthenticationException e) {
                        ElytronMessages.log.debugf((Throwable)e, "Credential direct evidence verification failed. DN: [%s]", (Object)distinguishedName);
                    }
                    catch (URISyntaxException | NamingException e) {
                        throw ElytronMessages.log.directLdapVerificationFailed(distinguishedName, url, e);
                    }
                    finally {
                        ((PasswordGuessEvidence)evidence).destroy();
                    }
                }
                return false;
            }
        };
    }
}

