/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.auth.callback.SSLCallback;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;
import org.wildfly.security.ssl.TLSServerEndPointChannelBinding;
import org.wildfly.security.x500.X500;

public final class TLSServerEndPointChannelBindingSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    public TLSServerEndPointChannelBindingSaslServerFactory(SaslServerFactory delegate) {
        super(delegate);
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, final CallbackHandler cbh) throws SaslException {
        return super.createSaslServer(mechanism, protocol, serverName, props, new CallbackHandler(){
            private X509Certificate[] certs;

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                ArrayList<Callback> list = new ArrayList<Callback>(Arrays.asList(callbacks));
                Iterator<Callback> iterator = list.iterator();
                while (iterator.hasNext()) {
                    Callback callback = iterator.next();
                    if (callback instanceof SSLCallback) {
                        SSLCallback sslCallback = (SSLCallback)callback;
                        this.certs = X500.asX509CertificateArray(sslCallback.getSslSession().getPeerCertificates());
                        continue;
                    }
                    if (!(callback instanceof ChannelBindingCallback)) continue;
                    TLSServerEndPointChannelBinding.handleChannelBindingCallback((ChannelBindingCallback)callback, this.certs);
                    iterator.remove();
                }
                if (!list.isEmpty()) {
                    cbh.handle(list.toArray(new Callback[list.size()]));
                }
            }
        });
    }
}

