/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jose4j.jwt.JwtClaims;
import org.wildfly.security.http.oidc.JsonWebToken;
import org.wildfly.security.http.oidc.RealmAccessClaim;

public class AccessToken
extends JsonWebToken {
    private static final String ALLOWED_ORIGINS = "allowed-origins";
    private static final String REALM_ACCESS = "realm_access";
    private static final String RESOURCE_ACCESS = "resource_access";
    private static final String TRUSTED_CERTS = "trusted-certs";

    public AccessToken(JwtClaims jwtClaims) {
        super(jwtClaims);
    }

    public List<String> getAllowedOrigins() {
        return this.getStringListClaimValue(ALLOWED_ORIGINS);
    }

    public RealmAccessClaim getRealmAccessClaim() {
        Object realmAccessValue = this.getClaimValue(REALM_ACCESS);
        return realmAccessValue == null ? null : new RealmAccessClaim((Map)realmAccessValue);
    }

    public Map<String, RealmAccessClaim> getResourceAccessClaim() {
        Object resourceAccessValue = this.getClaimValue(RESOURCE_ACCESS);
        if (resourceAccessValue == null) {
            return null;
        }
        Map resourceAccessValueMap = (Map)resourceAccessValue;
        HashMap<String, RealmAccessClaim> resourceAccessClaim = new HashMap<String, RealmAccessClaim>(resourceAccessValueMap.size());
        Iterator iterator = resourceAccessValueMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            Object val = resourceAccessValueMap.get(key = (String)iterator.next());
            resourceAccessClaim.put(key, val == null ? null : new RealmAccessClaim((Map)val));
        }
        return resourceAccessClaim;
    }

    public RealmAccessClaim getResourceAccessClaim(String resource) {
        Map<String, RealmAccessClaim> realmAccessClaimMap = this.getResourceAccessClaim();
        return realmAccessClaimMap == null ? null : realmAccessClaimMap.get(resource);
    }

    public List<String> getTrustedCertsClaim() {
        return this.getStringListClaimValue(TRUSTED_CERTS);
    }
}

