/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism._private;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism.ScramServerErrorCode;
import org.wildfly.security.mechanism.ScramServerException;
import org.wildfly.security.mechanism._private.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String credentialDestroyingFailed = "ELY00007: Credential destroying failed";
    private static final String authenticationFailedEvidenceVerification = "ELY01151: Evidence Verification Failed.";
    private static final String mechMessageAfterComplete = "ELY05001: Authentication mechanism exchange received a message after authentication was already complete";
    private static final String mechUserNameContainsInvalidCharacter = "ELY05002: Authentication mechanism user name contains an invalid or disallowed character";
    private static final String mechAuthorizationFailed0 = "ELY05004: Authentication mechanism authorization failed";
    private static final String mechAuthenticationNotComplete = "ELY05005: Authentication mechanism authentication is not yet complete";
    private static final String mechNoSecurityLayer = "ELY05006: Authentication mechanism does not support security layer (wrapping/unwrapping)";
    private static final String mechInvalidMessageReceived = "ELY05007: Invalid authentication mechanism negotiation message received";
    private static final String mechNoLoginNameGiven = "ELY05008: No authentication mechanism login name was given";
    private static final String mechNoPasswordGiven = "ELY05009: No authentication mechanism password was given";
    private static final String mechMalformedFields = "ELY05010: Authentication mechanism authentication failed due to one or more malformed fields";
    private static final String mechMessageTooLong = "ELY05011: Authentication mechanism message is too long";
    private static final String mechServerSideAuthenticationFailed = "ELY05012: Authentication mechanism server-side authentication failed";
    private static final String mechPasswordNotVerified = "ELY05013: Authentication mechanism password not verified";
    private static final String mechAuthorizationFailed2 = "ELY05014: Authentication mechanism authorization failed: \"%s\" running as \"%s\"";
    private static final String mechChannelBindingChanged = "ELY05018: Channel binding data changed";
    private static final String mechNoTokenGiven = "ELY05019: No token was given";
    private static final String mechInitialChallengeMustBeEmpty = "ELY05022: Initial challenge must be empty";
    private static final String mechUnableToSetChannelBinding = "ELY05023: Unable to set channel binding";
    private static final String mechFailedToDetermineChannelBindingStatus = "ELY05024: Failed to determine channel binding status";
    private static final String mechMutualAuthenticationNotEnabled = "ELY05025: Mutual authentication not enabled";
    private static final String mechMechanismToOidMappingFailed = "ELY05026: Unable to map SASL mechanism name to a GSS-API OID";
    private static final String mechUnableToDisposeGssContext = "ELY05027: Unable to dispose of GSSContext";
    private static final String mechUnableToCreateNameForAcceptor = "ELY05028: Unable to create name for acceptor";
    private static final String mechUnableToCreateGssContext = "ELY05029: Unable to create GSSContext";
    private static final String mechUnableToSetGssContextRequestFlags = "ELY05030: Unable to set GSSContext request flags";
    private static final String mechUnableToAcceptClientMessage = "ELY05031: Unable to accept SASL client message";
    private static final String mechGssApiMechanismMismatch = "ELY05032: GSS-API mechanism mismatch between SASL client and server";
    private static final String mechChannelBindingNotSupported = "ELY05033: Channel binding not supported for this SASL mechanism";
    private static final String mechChannelBindingTypeMismatch = "ELY05034: Channel binding type mismatch between SASL client and server";
    private static final String mechChannelBindingNotProvided = "ELY05035: Channel binding not provided by client";
    private static final String mechUnableToDeterminePeerName = "ELY05036: Unable to determine peer name";
    private static final String mechClientRefusesToInitiateAuthentication = "ELY05037: Authentication mechanism client refuses to initiate authentication";
    private static final String mechNoncesDoNotMatch = "ELY05038: Nonces do not match";
    private static final String invalidNonceLength = "ELY05039: Invalid length of nonce received";
    private static final String mechIterationCountIsTooLow = "ELY05040: Iteration count %d is below the minimum of %d";
    private static final String mechIterationCountIsTooHigh = "ELY05041: Iteration count %d is above the maximum of %d";
    private static final String mechInvalidServerMessage = "ELY05043: Invalid server message";
    private static final String mechInvalidServerMessageWithCause = "ELY05044: Invalid server message";
    private static final String mechInvalidClientMessage = "ELY05045: Invalid client message";
    private static final String mechInvalidClientMessageWithCause = "ELY05046: Invalid client message";
    private static final String mechUnmatchedMechanism = "ELY05047: [%s] Authentication mechanism message is for mismatched mechanism \"%s\"";
    private static final String mechServerAuthenticityCannotBeVerified = "ELY05049: Server authenticity cannot be verified";
    private static final String mechCallbackHandlerDoesNotSupportUserName = "ELY05050: Callback handler does not support user name";
    private static final String mechCallbackHandlerDoesNotSupportCredentialAcquisition = "ELY05051: Callback handler does not support credential acquisition";
    private static final String mechAuthorizationUnsupported = "ELY05052: Callback handler does not support authorization";
    private static final String mechCallbackHandlerFailedForUnknownReason = "ELY05053: Callback handler failed for unknown reason";
    private static final String mechAuthenticationRejectedInvalidProof = "ELY05055: Authentication rejected (invalid proof)";
    private static final String mechClientSentExtraMessage = "ELY05056: Client sent extra message";
    private static final String mechServerSentExtraMessage = "ELY05057: Server sent extra message";
    private static final String mechAuthenticationFailed = "ELY05058: Authentication failed";
    private static final String emptyNumber = "ELY05060: Empty number";
    private static final String invalidNumericCharacter = "ELY05061: Invalid numeric character";
    private static final String tooBigNumber = "ELY05062: Too big number";
    private static final String mechCannotGetTwoWayPasswordChars = "ELY05063: Cannot get clear password from two way password";
    private static final String mechMacAlgorithmNotSupported = "ELY05064: Hashing algorithm not supported";
    private static final String mechKeywordCannotBeEmpty = "ELY05065: keyword cannot be empty";
    private static final String mechNoValueFoundForKeyword = "ELY05066: No value found for keyword: %s";
    private static final String mechKeywordNotFollowedByEqual = "ELY05067: '=' expected after keyword: %s";
    private static final String mechUnmatchedQuoteFoundForValue = "ELY05068: Unmatched quote found for value: %s";
    private static final String mechExpectingCommaOrLinearWhitespaceAfterQuoted = "ELY05069: Expecting comma or linear whitespace after quoted string: %s";
    private static final String mechMessageTypeMustEqual = "ELY05070: MessageType must equal to %d, but it is %d";
    private static final String mechBadSequenceNumberWhileUnwrapping = "ELY05071: Bad sequence number while unwrapping: expected %d, but %d received";
    private static final String mechProblemDuringCrypt = "ELY05072: Problem during crypt";
    private static final String mechProblemDuringDecrypt = "ELY05073: Problem during decrypt";
    private static final String mechUnknownCipher = "ELY05074: Unknown cipher \"%s\"";
    private static final String mechAuthorizationIdChanged = "ELY05075: Authorization ID changed unexpectedly";
    private static final String mechProblemGettingRequiredCipher = "ELY05076: Problem getting required cipher. Check your transformation mapper settings.";
    private static final String mechNoCommonProtectionLayer = "ELY05077: No common protection layer between client and server";
    private static final String mechNoCommonCipher = "ELY05078: No common cipher between client and server";
    private static final String mechNoCiphersOfferedByServer = "ELY05079: No ciphers offered by server";
    private static final String mechNotProvidedUserName = "ELY05080: Callback handler not provided user name";
    private static final String mechMissingDirective = "ELY05083: Missing \"%s\" directive";
    private static final String mechNonceCountMustEqual = "ELY05084: nonce-count must equal to %d, but it is %d";
    private static final String mechUnsupportedCharset = "ELY05085: Server is set to not support %s charset";
    private static final String mechUnknownCharset = "ELY05086: Charset can be only \"utf-8\" or unspecified (to use ISO 8859-1)";
    private static final String mechDisallowedClientRealm = "ELY05087: Client selected realm not offered by server (%s)";
    private static final String mechMismatchedWrongDigestUri = "ELY05088: digest-uri \"%s\" not accepted";
    private static final String mechUnexpectedQop = "ELY05089: Unexpected qop value: \"%s\"";
    private static final String wrappingNotConfigured = "ELY05090: Wrapping is not configured";
    private static final String mechAuthenticationNameTooLong = "ELY05091: Authentication name string is too long";
    private static final String mechAuthenticationNameIsEmpty = "ELY05092: Authentication name is empty";
    private static final String mechAnonymousAuthorizationDenied = "ELY05093: Authorization for anonymous access is denied";
    private static final String requiredNegativePadding = "ELY05094: Required padded length (%d) is less than length of conversion result (%d)";
    private static final String mechInvalidKeyForDigestHMAC = "ELY05095: Invalid key provided for Digest HMAC computing";
    private static final String unableToDetermineSubjectName = "ELY05097: Unable to determine subject name from X.509 certificate";
    private static final String mechUnableToVerifyClientSignature = "ELY05098: Unable to verify client signature";
    private static final String mechUnableToVerifyServerSignature = "ELY05099: Unable to verify server signature";
    private static final String mechCallbackHandlerNotProvidedServerCertificate = "ELY05101: Callback handler not provided server certificate";
    private static final String mechCallbackHandlerNotProvidedClientCertificate = "ELY05102: Callback handler not provided client certificate";
    private static final String mechServerIdentifierMismatch = "ELY05103: Server identifier mismatch";
    private static final String mechClientIdentifierMismatch = "ELY05104: Client identifier mismatch";
    private static final String mechUnableToDetermineClientName = "ELY05105: Unable to determine client name";
    private static final String mechCallbackHandlerNotProvidedPrivateKey = "ELY05106: Callback handler not provided private key";
    private static final String mechUnableToCreateSignature = "ELY05107: Unable to create signature";
    private static final String mechUnableToCreateResponseToken = "ELY05108: Unable to create response token";
    private static final String mechUnableToCreateResponseTokenWithCause = "ELY05109: Unable to create response token";
    private static final String mechGettingSupportedMechanismsFailed = "ELY05112: Getting authentication mechanisms supported by GSS-API failed";
    private static final String unableToInitialiseOid = "ELY05113: Unable to initialize OID of Kerberos V5";
    private static final String mechReceiveBufferIsGreaterThanMaximum = "ELY05114: Receive buffer requested '%d' is greater than supported maximum '%d'";
    private static final String mechUnableToWrapMessage = "ELY05115: Unable to wrap message";
    private static final String mechUnableToUnwrapMessage = "ELY05116: Unable to unwrap message";
    private static final String mechUnableToUnwrapSecurityLayerNegotiationMessage = "ELY05117: Unable to unwrap security layer negotiation message";
    private static final String mechInvalidMessageOnUnwrapping = "ELY05118: Invalid message of length %d on unwrapping";
    private static final String mechNegotiatedMechanismWasNotKerberosV5 = "ELY05119: Negotiated mechanism was not Kerberos V5";
    private static final String mechInsufficientQopsAvailable = "ELY05120: Insufficient levels of protection available for supported security layers";
    private static final String mechUnableToGenerateChallenge = "ELY05121: Unable to generate security layer challenge";
    private static final String mechSelectedUnofferedQop = "ELY05122: Client selected a security layer that was not offered by server";
    private static final String mechNoSecurityLayerButLengthReceived = "ELY05123: No security layer selected but message length received";
    private static final String mechUnableToGetMaximumSizeOfMessage = "ELY05124: Unable to get maximum size of message before wrap";
    private static final String mechUnableToHandleResponseFromServer = "ELY05125: Unable to handle response from server";
    private static final String mechBadLengthOfMessageForNegotiatingSecurityLayer = "ELY05126: Bad length of message for negotiating security layer";
    private static final String mechReceivedMaxMessageSizeWhenNoSecurityLayer = "ELY05127: No security layer supported by server but maximum message size received: \"%d\"";
    private static final String mechFailedToReadChallengeFile = "ELY05128: Failed to read challenge file";
    private static final String mechFailedToCreateChallengeFile = "ELY05129: Failed to create challenge file";
    private static final String mechAuthorizationIdTooLong = "ELY05150: Authentication mechanism authorization ID is too long";
    private static final String mechInvalidOTPAlgorithm = "ELY05151: Invalid OTP algorithm \"%s\"";
    private static final String mechInvalidOTPResponseType = "ELY05152: Invalid OTP response type";
    private static final String mechIncorrectParity = "ELY05153: Incorrect parity in SASL client message";
    private static final String mechInvalidCharacterInSeed = "ELY05154: Invalid character in seed";
    private static final String mechInvalidOTPSeed = "ELY05155: Invalid OTP seed, must be between 1 and 16 characters long";
    private static final String mechInvalidOTPPassPhrase = "ELY05156: Invalid OTP pass phrase, must be between 10 and 63 characters long";
    private static final String mechInvalidOTPSequenceNumber = "ELY05157: Invalid OTP sequence number";
    private static final String mechInvalidOTP = "ELY05158: Invalid OTP";
    private static final String mechOTPPassPhraseAndSeedMustNotMatch = "ELY05159: OTP pass phrase and seed must not match";
    private static final String mechInvalidOTPAlternateDictionary = "ELY05160: Invalid OTP alternate dictionary";
    private static final String mechUnableToRetrievePassword = "ELY05161: Unable to retrieve password for \"%s\"";
    private static final String mechUnableToUpdatePassword = "ELY05162: Unable to update password for \"%s\"";
    private static final String mechServerTimedOut = "ELY05163: Authentication mechanism server timed out";
    private static final String mechUnableToObtainExclusiveAccess = "ELY05164: Unable to obtain exclusive access for \"%s\"";
    private static final String mechOTPReinitializationFailed = "ELY05165: OTP re-initialization failed";
    private static final String scramServerRejectedAuthentication = "ELY05166: Server rejected authentication";
    private static final String mechInvalidOTPPasswordFormatType = "ELY05167: Invalid OTP password format type";
    private static final String mechUnsupportedAlgorithm = "ELY05168: Unsupported algorithm selected \"%s\"";
    private static final String mechResponseTokenMismatch = "ELY05169: [%s] Clients response token does not match expected token";
    private static final String mechProblemDuringCryptResultIsNull = "ELY05170: Problem during crypt: The encrypted result is null. The input data has a length of zero or too short to result in a new block.";
    private static final String mechProblemDuringDecryptResultIsNull = "ELY05171: Problem during decrypt: The decrypted result is null. The input data has a length of zero or too short to result in a new block.";
    private static final String unableToObtainServerCredential = "ELY05173: Unable to obtain server credential.";
    private static final String mechNotChosenRealm = "ELY05174: Callback handler has not chosen realm";
    private static final String mechUnableToDetermineBoundServerName = "ELY05175: Unable to determine bound server name";
    private static final String mechCallbackHandlerUnsupportedCallback = "ELY05176: Unsupported callback";
    private static final String mechOneOfDirectivesHasToBeDefined = "ELY05177: One of \"%s\" and \"%s\" directives has to be defined";
    private static final String incorrectlyFormattedHeader = "ELY06001: An incorrectly formatted '%s'header was encountered.";
    private static final String authenticationFailed2 = "ELY06002: An authentication attempt for user '%s' failed validation using mechanism '%s'.";
    private static final String authenticationFailed0 = "ELY06003: An authentication attempt failed validation.";
    private static final String authorizationFailed = "ELY06006: An authorization check for user '%s' failed.";
    private static final String usernameOrPasswordMissing = "ELY06007: Username or password missing from authentication attempt.";
    private static final String digestMechanismRequireRealm = "ELY06015: Unable to authenticate using DIGEST mechanism - realm name needs to be specified";
    private static final String digestMechanismInvalidRealm = "ELY06019: Unable to authenticate using DIGEST mechanism - mechanism realm name (%s) is not valid";
    private static final String unsuitableScope = "ELY06020: Scope unsuitable for use with authentication state '%s'";
    private static final String unableToIdentifyHttpScope = "ELY06021: Unable to identify suitable HttpScope for mechanism state storage";
    private static final String invalidNonceCount = "ELY06022: Invalid nonce count %s";
    private static final String asnUnrecognisedAlgorithm = "ELY07001: Unrecognized encoding algorithm [%s]";
    private static final String asnInvalidGeneralNameType = "ELY07002: Invalid general name type";
    private static final String asnUnexpectedTag = "ELY07004: Unexpected ASN.1 tag encountered";

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void credentialDestroyingFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.credentialDestroyingFailed$str(), new Object[0]);
    }

    protected String credentialDestroyingFailed$str() {
        return credentialDestroyingFailed;
    }

    protected String authenticationFailedEvidenceVerification$str() {
        return authenticationFailedEvidenceVerification;
    }

    @Override
    public final SecurityException authenticationFailedEvidenceVerification() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.authenticationFailedEvidenceVerification$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechMessageAfterComplete$str() {
        return mechMessageAfterComplete;
    }

    @Override
    public final AuthenticationMechanismException mechMessageAfterComplete() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMessageAfterComplete$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUserNameContainsInvalidCharacter$str() {
        return mechUserNameContainsInvalidCharacter;
    }

    @Override
    public final AuthenticationMechanismException mechUserNameContainsInvalidCharacter() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUserNameContainsInvalidCharacter$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechAuthorizationFailed0$str() {
        return mechAuthorizationFailed0;
    }

    @Override
    public final AuthenticationMechanismException mechAuthorizationFailed(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthorizationFailed0$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechAuthenticationNotComplete$str() {
        return mechAuthenticationNotComplete;
    }

    @Override
    public final IllegalStateException mechAuthenticationNotComplete() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.mechAuthenticationNotComplete$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechNoSecurityLayer$str() {
        return mechNoSecurityLayer;
    }

    @Override
    public final IllegalStateException mechNoSecurityLayer() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.mechNoSecurityLayer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidMessageReceived$str() {
        return mechInvalidMessageReceived;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidMessageReceived() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidMessageReceived$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechNoLoginNameGiven$str() {
        return mechNoLoginNameGiven;
    }

    @Override
    public final AuthenticationMechanismException mechNoLoginNameGiven() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoLoginNameGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechNoPasswordGiven$str() {
        return mechNoPasswordGiven;
    }

    @Override
    public final AuthenticationMechanismException mechNoPasswordGiven() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoPasswordGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechMalformedFields$str() {
        return mechMalformedFields;
    }

    @Override
    public final AuthenticationMechanismException mechMalformedFields(IllegalArgumentException ex) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMalformedFields$str(), new Object[0]), ex);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechMessageTooLong$str() {
        return mechMessageTooLong;
    }

    @Override
    public final AuthenticationMechanismException mechMessageTooLong() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMessageTooLong$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechServerSideAuthenticationFailed$str() {
        return mechServerSideAuthenticationFailed;
    }

    @Override
    public final AuthenticationMechanismException mechServerSideAuthenticationFailed(Exception e) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechServerSideAuthenticationFailed$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechPasswordNotVerified$str() {
        return mechPasswordNotVerified;
    }

    @Override
    public final AuthenticationMechanismException mechPasswordNotVerified() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechPasswordNotVerified$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechAuthorizationFailed2$str() {
        return mechAuthorizationFailed2;
    }

    @Override
    public final AuthenticationMechanismException mechAuthorizationFailed(String userName, String authorizationId) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthorizationFailed2$str(), userName, authorizationId));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechChannelBindingChanged$str() {
        return mechChannelBindingChanged;
    }

    @Override
    public final AuthenticationMechanismException mechChannelBindingChanged() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechChannelBindingChanged$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechNoTokenGiven$str() {
        return mechNoTokenGiven;
    }

    @Override
    public final AuthenticationMechanismException mechNoTokenGiven() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoTokenGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInitialChallengeMustBeEmpty$str() {
        return mechInitialChallengeMustBeEmpty;
    }

    @Override
    public final AuthenticationMechanismException mechInitialChallengeMustBeEmpty() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInitialChallengeMustBeEmpty$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToSetChannelBinding$str() {
        return mechUnableToSetChannelBinding;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToSetChannelBinding(Exception e) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToSetChannelBinding$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechFailedToDetermineChannelBindingStatus$str() {
        return mechFailedToDetermineChannelBindingStatus;
    }

    @Override
    public final AuthenticationMechanismException mechFailedToDetermineChannelBindingStatus(Exception e) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechFailedToDetermineChannelBindingStatus$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechMutualAuthenticationNotEnabled$str() {
        return mechMutualAuthenticationNotEnabled;
    }

    @Override
    public final AuthenticationMechanismException mechMutualAuthenticationNotEnabled() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMutualAuthenticationNotEnabled$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechMechanismToOidMappingFailed$str() {
        return mechMechanismToOidMappingFailed;
    }

    @Override
    public final AuthenticationMechanismException mechMechanismToOidMappingFailed(Exception e) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMechanismToOidMappingFailed$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToDisposeGssContext$str() {
        return mechUnableToDisposeGssContext;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToDisposeGssContext(Exception e) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToDisposeGssContext$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToCreateNameForAcceptor$str() {
        return mechUnableToCreateNameForAcceptor;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToCreateNameForAcceptor(Exception e) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToCreateNameForAcceptor$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToCreateGssContext$str() {
        return mechUnableToCreateGssContext;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToCreateGssContext(Exception e) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToCreateGssContext$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToSetGssContextRequestFlags$str() {
        return mechUnableToSetGssContextRequestFlags;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToSetGssContextRequestFlags(Exception e) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToSetGssContextRequestFlags$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToAcceptClientMessage$str() {
        return mechUnableToAcceptClientMessage;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToAcceptClientMessage(Exception e) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToAcceptClientMessage$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechGssApiMechanismMismatch$str() {
        return mechGssApiMechanismMismatch;
    }

    @Override
    public final AuthenticationMechanismException mechGssApiMechanismMismatch() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechGssApiMechanismMismatch$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechChannelBindingNotSupported$str() {
        return mechChannelBindingNotSupported;
    }

    @Override
    public final AuthenticationMechanismException mechChannelBindingNotSupported() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechChannelBindingNotSupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechChannelBindingTypeMismatch$str() {
        return mechChannelBindingTypeMismatch;
    }

    @Override
    public final AuthenticationMechanismException mechChannelBindingTypeMismatch() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechChannelBindingTypeMismatch$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechChannelBindingNotProvided$str() {
        return mechChannelBindingNotProvided;
    }

    @Override
    public final AuthenticationMechanismException mechChannelBindingNotProvided() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechChannelBindingNotProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToDeterminePeerName$str() {
        return mechUnableToDeterminePeerName;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToDeterminePeerName(Exception e) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToDeterminePeerName$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechClientRefusesToInitiateAuthentication$str() {
        return mechClientRefusesToInitiateAuthentication;
    }

    @Override
    public final AuthenticationMechanismException mechClientRefusesToInitiateAuthentication() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechClientRefusesToInitiateAuthentication$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechNoncesDoNotMatch$str() {
        return mechNoncesDoNotMatch;
    }

    @Override
    public final AuthenticationMechanismException mechNoncesDoNotMatch() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoncesDoNotMatch$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNonceLength$str() {
        return invalidNonceLength;
    }

    @Override
    public final AuthenticationMechanismException invalidNonceLength() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.invalidNonceLength$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechIterationCountIsTooLow$str() {
        return mechIterationCountIsTooLow;
    }

    @Override
    public final AuthenticationMechanismException mechIterationCountIsTooLow(int iterationCount, int minimumIterationCount) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechIterationCountIsTooLow$str(), iterationCount, minimumIterationCount));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechIterationCountIsTooHigh$str() {
        return mechIterationCountIsTooHigh;
    }

    @Override
    public final AuthenticationMechanismException mechIterationCountIsTooHigh(int iterationCount, int maximumIterationCount) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechIterationCountIsTooHigh$str(), iterationCount, maximumIterationCount));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidServerMessage$str() {
        return mechInvalidServerMessage;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidServerMessage() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidServerMessage$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidServerMessageWithCause$str() {
        return mechInvalidServerMessageWithCause;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidServerMessageWithCause(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidServerMessageWithCause$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidClientMessage$str() {
        return mechInvalidClientMessage;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidClientMessage() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidClientMessage$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidClientMessageWithCause$str() {
        return mechInvalidClientMessageWithCause;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidClientMessageWithCause(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidClientMessageWithCause$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnmatchedMechanism$str() {
        return mechUnmatchedMechanism;
    }

    @Override
    public final AuthenticationMechanismException mechUnmatchedMechanism(String mechName, String otherMechName) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnmatchedMechanism$str(), mechName, otherMechName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechServerAuthenticityCannotBeVerified$str() {
        return mechServerAuthenticityCannotBeVerified;
    }

    @Override
    public final AuthenticationMechanismException mechServerAuthenticityCannotBeVerified() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechServerAuthenticityCannotBeVerified$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechCallbackHandlerDoesNotSupportUserName$str() {
        return mechCallbackHandlerDoesNotSupportUserName;
    }

    @Override
    public final AuthenticationMechanismException mechCallbackHandlerDoesNotSupportUserName(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCallbackHandlerDoesNotSupportUserName$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechCallbackHandlerDoesNotSupportCredentialAcquisition$str() {
        return mechCallbackHandlerDoesNotSupportCredentialAcquisition;
    }

    @Override
    public final AuthenticationMechanismException mechCallbackHandlerDoesNotSupportCredentialAcquisition(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCallbackHandlerDoesNotSupportCredentialAcquisition$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechAuthorizationUnsupported$str() {
        return mechAuthorizationUnsupported;
    }

    @Override
    public final AuthenticationMechanismException mechAuthorizationUnsupported(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthorizationUnsupported$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechCallbackHandlerFailedForUnknownReason$str() {
        return mechCallbackHandlerFailedForUnknownReason;
    }

    @Override
    public final AuthenticationMechanismException mechCallbackHandlerFailedForUnknownReason(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCallbackHandlerFailedForUnknownReason$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechAuthenticationRejectedInvalidProof$str() {
        return mechAuthenticationRejectedInvalidProof;
    }

    @Override
    public final AuthenticationMechanismException mechAuthenticationRejectedInvalidProof() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthenticationRejectedInvalidProof$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechClientSentExtraMessage$str() {
        return mechClientSentExtraMessage;
    }

    @Override
    public final AuthenticationMechanismException mechClientSentExtraMessage() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechClientSentExtraMessage$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechServerSentExtraMessage$str() {
        return mechServerSentExtraMessage;
    }

    @Override
    public final AuthenticationMechanismException mechServerSentExtraMessage() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechServerSentExtraMessage$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechAuthenticationFailed$str() {
        return mechAuthenticationFailed;
    }

    @Override
    public final AuthenticationMechanismException mechAuthenticationFailed() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthenticationFailed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String emptyNumber$str() {
        return emptyNumber;
    }

    @Override
    public final NumberFormatException emptyNumber() {
        NumberFormatException result = new NumberFormatException(String.format(this.getLoggingLocale(), this.emptyNumber$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNumericCharacter$str() {
        return invalidNumericCharacter;
    }

    @Override
    public final NumberFormatException invalidNumericCharacter() {
        NumberFormatException result = new NumberFormatException(String.format(this.getLoggingLocale(), this.invalidNumericCharacter$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tooBigNumber$str() {
        return tooBigNumber;
    }

    @Override
    public final NumberFormatException tooBigNumber() {
        NumberFormatException result = new NumberFormatException(String.format(this.getLoggingLocale(), this.tooBigNumber$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechCannotGetTwoWayPasswordChars$str() {
        return mechCannotGetTwoWayPasswordChars;
    }

    @Override
    public final AuthenticationMechanismException mechCannotGetTwoWayPasswordChars(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCannotGetTwoWayPasswordChars$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechMacAlgorithmNotSupported$str() {
        return mechMacAlgorithmNotSupported;
    }

    @Override
    public final AuthenticationMechanismException mechMacAlgorithmNotSupported(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMacAlgorithmNotSupported$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechKeywordCannotBeEmpty$str() {
        return mechKeywordCannotBeEmpty;
    }

    @Override
    public final AuthenticationMechanismException mechKeywordCannotBeEmpty() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechKeywordCannotBeEmpty$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechNoValueFoundForKeyword$str() {
        return mechNoValueFoundForKeyword;
    }

    @Override
    public final AuthenticationMechanismException mechNoValueFoundForKeyword(String keyword) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoValueFoundForKeyword$str(), keyword));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechKeywordNotFollowedByEqual$str() {
        return mechKeywordNotFollowedByEqual;
    }

    @Override
    public final AuthenticationMechanismException mechKeywordNotFollowedByEqual(String keyword) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechKeywordNotFollowedByEqual$str(), keyword));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnmatchedQuoteFoundForValue$str() {
        return mechUnmatchedQuoteFoundForValue;
    }

    @Override
    public final AuthenticationMechanismException mechUnmatchedQuoteFoundForValue(String value) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnmatchedQuoteFoundForValue$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechExpectingCommaOrLinearWhitespaceAfterQuoted$str() {
        return mechExpectingCommaOrLinearWhitespaceAfterQuoted;
    }

    @Override
    public final AuthenticationMechanismException mechExpectingCommaOrLinearWhitespaceAfterQuoted(String value) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechExpectingCommaOrLinearWhitespaceAfterQuoted$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechMessageTypeMustEqual$str() {
        return mechMessageTypeMustEqual;
    }

    @Override
    public final AuthenticationMechanismException mechMessageTypeMustEqual(int expected, int actual) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMessageTypeMustEqual$str(), expected, actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechBadSequenceNumberWhileUnwrapping$str() {
        return mechBadSequenceNumberWhileUnwrapping;
    }

    @Override
    public final AuthenticationMechanismException mechBadSequenceNumberWhileUnwrapping(int expected, int actual) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechBadSequenceNumberWhileUnwrapping$str(), expected, actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechProblemDuringCrypt$str() {
        return mechProblemDuringCrypt;
    }

    @Override
    public final AuthenticationMechanismException mechProblemDuringCrypt(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechProblemDuringCrypt$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechProblemDuringDecrypt$str() {
        return mechProblemDuringDecrypt;
    }

    @Override
    public final AuthenticationMechanismException mechProblemDuringDecrypt(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechProblemDuringDecrypt$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnknownCipher$str() {
        return mechUnknownCipher;
    }

    @Override
    public final AuthenticationMechanismException mechUnknownCipher(String cipher) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnknownCipher$str(), cipher));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechAuthorizationIdChanged$str() {
        return mechAuthorizationIdChanged;
    }

    @Override
    public final AuthenticationMechanismException mechAuthorizationIdChanged() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthorizationIdChanged$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechProblemGettingRequiredCipher$str() {
        return mechProblemGettingRequiredCipher;
    }

    @Override
    public final AuthenticationMechanismException mechProblemGettingRequiredCipher(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechProblemGettingRequiredCipher$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechNoCommonProtectionLayer$str() {
        return mechNoCommonProtectionLayer;
    }

    @Override
    public final AuthenticationMechanismException mechNoCommonProtectionLayer() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoCommonProtectionLayer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechNoCommonCipher$str() {
        return mechNoCommonCipher;
    }

    @Override
    public final AuthenticationMechanismException mechNoCommonCipher() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoCommonCipher$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechNoCiphersOfferedByServer$str() {
        return mechNoCiphersOfferedByServer;
    }

    @Override
    public final AuthenticationMechanismException mechNoCiphersOfferedByServer() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoCiphersOfferedByServer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechNotProvidedUserName$str() {
        return mechNotProvidedUserName;
    }

    @Override
    public final AuthenticationMechanismException mechNotProvidedUserName() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNotProvidedUserName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechMissingDirective$str() {
        return mechMissingDirective;
    }

    @Override
    public final AuthenticationMechanismException mechMissingDirective(String directive) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMissingDirective$str(), directive));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechNonceCountMustEqual$str() {
        return mechNonceCountMustEqual;
    }

    @Override
    public final AuthenticationMechanismException mechNonceCountMustEqual(int expected, int actual) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNonceCountMustEqual$str(), expected, actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnsupportedCharset$str() {
        return mechUnsupportedCharset;
    }

    @Override
    public final AuthenticationMechanismException mechUnsupportedCharset(String charset) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnsupportedCharset$str(), charset));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnknownCharset$str() {
        return mechUnknownCharset;
    }

    @Override
    public final AuthenticationMechanismException mechUnknownCharset() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnknownCharset$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechDisallowedClientRealm$str() {
        return mechDisallowedClientRealm;
    }

    @Override
    public final AuthenticationMechanismException mechDisallowedClientRealm(String clientRealm) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechDisallowedClientRealm$str(), clientRealm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechMismatchedWrongDigestUri$str() {
        return mechMismatchedWrongDigestUri;
    }

    @Override
    public final AuthenticationMechanismException mechMismatchedWrongDigestUri(String actual) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMismatchedWrongDigestUri$str(), actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnexpectedQop$str() {
        return mechUnexpectedQop;
    }

    @Override
    public final AuthenticationMechanismException mechUnexpectedQop(String qop) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnexpectedQop$str(), qop));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String wrappingNotConfigured$str() {
        return wrappingNotConfigured;
    }

    @Override
    public final IllegalStateException wrappingNotConfigured() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.wrappingNotConfigured$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechAuthenticationNameTooLong$str() {
        return mechAuthenticationNameTooLong;
    }

    @Override
    public final AuthenticationMechanismException mechAuthenticationNameTooLong() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthenticationNameTooLong$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechAuthenticationNameIsEmpty$str() {
        return mechAuthenticationNameIsEmpty;
    }

    @Override
    public final AuthenticationMechanismException mechAuthenticationNameIsEmpty() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthenticationNameIsEmpty$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechAnonymousAuthorizationDenied$str() {
        return mechAnonymousAuthorizationDenied;
    }

    @Override
    public final AuthenticationMechanismException mechAnonymousAuthorizationDenied() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAnonymousAuthorizationDenied$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requiredNegativePadding$str() {
        return requiredNegativePadding;
    }

    @Override
    public final IllegalArgumentException requiredNegativePadding(int totalLength, int hexLength) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.requiredNegativePadding$str(), totalLength, hexLength));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidKeyForDigestHMAC$str() {
        return mechInvalidKeyForDigestHMAC;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidKeyForDigestHMAC() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidKeyForDigestHMAC$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDetermineSubjectName$str() {
        return unableToDetermineSubjectName;
    }

    @Override
    public final IllegalStateException unableToDetermineSubjectName(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToDetermineSubjectName$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToVerifyClientSignature$str() {
        return mechUnableToVerifyClientSignature;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToVerifyClientSignature(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToVerifyClientSignature$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToVerifyServerSignature$str() {
        return mechUnableToVerifyServerSignature;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToVerifyServerSignature(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToVerifyServerSignature$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechCallbackHandlerNotProvidedServerCertificate$str() {
        return mechCallbackHandlerNotProvidedServerCertificate;
    }

    @Override
    public final AuthenticationMechanismException mechCallbackHandlerNotProvidedServerCertificate() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCallbackHandlerNotProvidedServerCertificate$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechCallbackHandlerNotProvidedClientCertificate$str() {
        return mechCallbackHandlerNotProvidedClientCertificate;
    }

    @Override
    public final AuthenticationMechanismException mechCallbackHandlerNotProvidedClientCertificate() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCallbackHandlerNotProvidedClientCertificate$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechServerIdentifierMismatch$str() {
        return mechServerIdentifierMismatch;
    }

    @Override
    public final AuthenticationMechanismException mechServerIdentifierMismatch() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechServerIdentifierMismatch$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechClientIdentifierMismatch$str() {
        return mechClientIdentifierMismatch;
    }

    @Override
    public final AuthenticationMechanismException mechClientIdentifierMismatch() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechClientIdentifierMismatch$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToDetermineClientName$str() {
        return mechUnableToDetermineClientName;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToDetermineClientName(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToDetermineClientName$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechCallbackHandlerNotProvidedPrivateKey$str() {
        return mechCallbackHandlerNotProvidedPrivateKey;
    }

    @Override
    public final AuthenticationMechanismException mechCallbackHandlerNotProvidedPrivateKey() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCallbackHandlerNotProvidedPrivateKey$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToCreateSignature$str() {
        return mechUnableToCreateSignature;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToCreateSignature(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToCreateSignature$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToCreateResponseToken$str() {
        return mechUnableToCreateResponseToken;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToCreateResponseToken(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToCreateResponseToken$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToCreateResponseTokenWithCause$str() {
        return mechUnableToCreateResponseTokenWithCause;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToCreateResponseTokenWithCause(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToCreateResponseTokenWithCause$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechGettingSupportedMechanismsFailed$str() {
        return mechGettingSupportedMechanismsFailed;
    }

    @Override
    public final AuthenticationMechanismException mechGettingSupportedMechanismsFailed(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechGettingSupportedMechanismsFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInitialiseOid$str() {
        return unableToInitialiseOid;
    }

    @Override
    public final RuntimeException unableToInitialiseOid(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToInitialiseOid$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechReceiveBufferIsGreaterThanMaximum$str() {
        return mechReceiveBufferIsGreaterThanMaximum;
    }

    @Override
    public final AuthenticationMechanismException mechReceiveBufferIsGreaterThanMaximum(int requested, int maximum) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechReceiveBufferIsGreaterThanMaximum$str(), requested, maximum));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToWrapMessage$str() {
        return mechUnableToWrapMessage;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToWrapMessage(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToWrapMessage$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToUnwrapMessage$str() {
        return mechUnableToUnwrapMessage;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToUnwrapMessage(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToUnwrapMessage$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToUnwrapSecurityLayerNegotiationMessage$str() {
        return mechUnableToUnwrapSecurityLayerNegotiationMessage;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToUnwrapSecurityLayerNegotiationMessage(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToUnwrapSecurityLayerNegotiationMessage$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidMessageOnUnwrapping$str() {
        return mechInvalidMessageOnUnwrapping;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidMessageOnUnwrapping(int length) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidMessageOnUnwrapping$str(), length));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechNegotiatedMechanismWasNotKerberosV5$str() {
        return mechNegotiatedMechanismWasNotKerberosV5;
    }

    @Override
    public final AuthenticationMechanismException mechNegotiatedMechanismWasNotKerberosV5() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNegotiatedMechanismWasNotKerberosV5$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInsufficientQopsAvailable$str() {
        return mechInsufficientQopsAvailable;
    }

    @Override
    public final AuthenticationMechanismException mechInsufficientQopsAvailable() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInsufficientQopsAvailable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToGenerateChallenge$str() {
        return mechUnableToGenerateChallenge;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToGenerateChallenge(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToGenerateChallenge$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechSelectedUnofferedQop$str() {
        return mechSelectedUnofferedQop;
    }

    @Override
    public final AuthenticationMechanismException mechSelectedUnofferedQop() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechSelectedUnofferedQop$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechNoSecurityLayerButLengthReceived$str() {
        return mechNoSecurityLayerButLengthReceived;
    }

    @Override
    public final AuthenticationMechanismException mechNoSecurityLayerButLengthReceived() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoSecurityLayerButLengthReceived$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToGetMaximumSizeOfMessage$str() {
        return mechUnableToGetMaximumSizeOfMessage;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToGetMaximumSizeOfMessage(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToGetMaximumSizeOfMessage$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToHandleResponseFromServer$str() {
        return mechUnableToHandleResponseFromServer;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToHandleResponseFromServer(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToHandleResponseFromServer$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechBadLengthOfMessageForNegotiatingSecurityLayer$str() {
        return mechBadLengthOfMessageForNegotiatingSecurityLayer;
    }

    @Override
    public final AuthenticationMechanismException mechBadLengthOfMessageForNegotiatingSecurityLayer() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechBadLengthOfMessageForNegotiatingSecurityLayer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechReceivedMaxMessageSizeWhenNoSecurityLayer$str() {
        return mechReceivedMaxMessageSizeWhenNoSecurityLayer;
    }

    @Override
    public final AuthenticationMechanismException mechReceivedMaxMessageSizeWhenNoSecurityLayer(int length) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechReceivedMaxMessageSizeWhenNoSecurityLayer$str(), length));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechFailedToReadChallengeFile$str() {
        return mechFailedToReadChallengeFile;
    }

    @Override
    public final AuthenticationMechanismException mechFailedToReadChallengeFile(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechFailedToReadChallengeFile$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechFailedToCreateChallengeFile$str() {
        return mechFailedToCreateChallengeFile;
    }

    @Override
    public final AuthenticationMechanismException mechFailedToCreateChallengeFile(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechFailedToCreateChallengeFile$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechAuthorizationIdTooLong$str() {
        return mechAuthorizationIdTooLong;
    }

    @Override
    public final AuthenticationMechanismException mechAuthorizationIdTooLong() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthorizationIdTooLong$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidOTPAlgorithm$str() {
        return mechInvalidOTPAlgorithm;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTPAlgorithm(String algorithm) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTPAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidOTPResponseType$str() {
        return mechInvalidOTPResponseType;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTPResponseType() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTPResponseType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechIncorrectParity$str() {
        return mechIncorrectParity;
    }

    @Override
    public final AuthenticationMechanismException mechIncorrectParity() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechIncorrectParity$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidCharacterInSeed$str() {
        return mechInvalidCharacterInSeed;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidCharacterInSeed() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidCharacterInSeed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidOTPSeed$str() {
        return mechInvalidOTPSeed;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTPSeed() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTPSeed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidOTPPassPhrase$str() {
        return mechInvalidOTPPassPhrase;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTPPassPhrase() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTPPassPhrase$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidOTPSequenceNumber$str() {
        return mechInvalidOTPSequenceNumber;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTPSequenceNumber() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTPSequenceNumber$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidOTP$str() {
        return mechInvalidOTP;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTP() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTP$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechOTPPassPhraseAndSeedMustNotMatch$str() {
        return mechOTPPassPhraseAndSeedMustNotMatch;
    }

    @Override
    public final AuthenticationMechanismException mechOTPPassPhraseAndSeedMustNotMatch() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechOTPPassPhraseAndSeedMustNotMatch$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidOTPAlternateDictionary$str() {
        return mechInvalidOTPAlternateDictionary;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTPAlternateDictionary() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTPAlternateDictionary$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToRetrievePassword$str() {
        return mechUnableToRetrievePassword;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToRetrievePassword(String userName) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToRetrievePassword$str(), userName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToUpdatePassword$str() {
        return mechUnableToUpdatePassword;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToUpdatePassword(String userName) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToUpdatePassword$str(), userName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechServerTimedOut$str() {
        return mechServerTimedOut;
    }

    @Override
    public final AuthenticationMechanismException mechServerTimedOut() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechServerTimedOut$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToObtainExclusiveAccess$str() {
        return mechUnableToObtainExclusiveAccess;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToObtainExclusiveAccess(String userName) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToObtainExclusiveAccess$str(), userName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechOTPReinitializationFailed$str() {
        return mechOTPReinitializationFailed;
    }

    @Override
    public final AuthenticationMechanismException mechOTPReinitializationFailed(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechOTPReinitializationFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String scramServerRejectedAuthentication$str() {
        return scramServerRejectedAuthentication;
    }

    @Override
    public final ScramServerException scramServerRejectedAuthentication(ScramServerErrorCode errorCode) {
        ScramServerException result = new ScramServerException(String.format(this.getLoggingLocale(), this.scramServerRejectedAuthentication$str(), new Object[0]), errorCode);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidOTPPasswordFormatType$str() {
        return mechInvalidOTPPasswordFormatType;
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTPPasswordFormatType() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTPPasswordFormatType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnsupportedAlgorithm$str() {
        return mechUnsupportedAlgorithm;
    }

    @Override
    public final AuthenticationMechanismException mechUnsupportedAlgorithm(String algorithm) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnsupportedAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechResponseTokenMismatch$str() {
        return mechResponseTokenMismatch;
    }

    @Override
    public final String mechResponseTokenMismatch(String mechName) {
        return String.format(this.getLoggingLocale(), this.mechResponseTokenMismatch$str(), mechName);
    }

    protected String mechProblemDuringCryptResultIsNull$str() {
        return mechProblemDuringCryptResultIsNull;
    }

    @Override
    public final AuthenticationMechanismException mechProblemDuringCryptResultIsNull() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechProblemDuringCryptResultIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechProblemDuringDecryptResultIsNull$str() {
        return mechProblemDuringDecryptResultIsNull;
    }

    @Override
    public final AuthenticationMechanismException mechProblemDuringDecryptResultIsNull() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechProblemDuringDecryptResultIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToObtainServerCredential$str() {
        return unableToObtainServerCredential;
    }

    @Override
    public final AuthenticationMechanismException unableToObtainServerCredential() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.unableToObtainServerCredential$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechNotChosenRealm$str() {
        return mechNotChosenRealm;
    }

    @Override
    public final AuthenticationMechanismException mechNotChosenRealm() {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNotChosenRealm$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechUnableToDetermineBoundServerName$str() {
        return mechUnableToDetermineBoundServerName;
    }

    @Override
    public final AuthenticationMechanismException mechUnableToDetermineBoundServerName(Exception e) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToDetermineBoundServerName$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechCallbackHandlerUnsupportedCallback$str() {
        return mechCallbackHandlerUnsupportedCallback;
    }

    @Override
    public final AuthenticationMechanismException mechCallbackHandlerUnsupportedCallback(Throwable cause) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCallbackHandlerUnsupportedCallback$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechOneOfDirectivesHasToBeDefined$str() {
        return mechOneOfDirectivesHasToBeDefined;
    }

    @Override
    public final AuthenticationMechanismException mechOneOfDirectivesHasToBeDefined(String directive1, String directive2) {
        AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechOneOfDirectivesHasToBeDefined$str(), directive1, directive2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incorrectlyFormattedHeader$str() {
        return incorrectlyFormattedHeader;
    }

    @Override
    public final String incorrectlyFormattedHeader(String headerName) {
        return String.format(this.getLoggingLocale(), this.incorrectlyFormattedHeader$str(), headerName);
    }

    protected String authenticationFailed2$str() {
        return authenticationFailed2;
    }

    @Override
    public final String authenticationFailed(String username, String mechanismName) {
        return String.format(this.getLoggingLocale(), this.authenticationFailed2$str(), username, mechanismName);
    }

    protected String authenticationFailed0$str() {
        return authenticationFailed0;
    }

    @Override
    public final String authenticationFailed() {
        return String.format(this.getLoggingLocale(), this.authenticationFailed0$str(), new Object[0]);
    }

    protected String authorizationFailed$str() {
        return authorizationFailed;
    }

    @Override
    public final String authorizationFailed(String username) {
        return String.format(this.getLoggingLocale(), this.authorizationFailed$str(), username);
    }

    protected String usernameOrPasswordMissing$str() {
        return usernameOrPasswordMissing;
    }

    @Override
    public final String usernameOrPasswordMissing() {
        return String.format(this.getLoggingLocale(), this.usernameOrPasswordMissing$str(), new Object[0]);
    }

    protected String digestMechanismRequireRealm$str() {
        return digestMechanismRequireRealm;
    }

    @Override
    public final HttpAuthenticationException digestMechanismRequireRealm() {
        HttpAuthenticationException result = new HttpAuthenticationException(String.format(this.getLoggingLocale(), this.digestMechanismRequireRealm$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String digestMechanismInvalidRealm$str() {
        return digestMechanismInvalidRealm;
    }

    @Override
    public final HttpAuthenticationException digestMechanismInvalidRealm(String realm) {
        HttpAuthenticationException result = new HttpAuthenticationException(String.format(this.getLoggingLocale(), this.digestMechanismInvalidRealm$str(), realm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsuitableScope$str() {
        return unsuitableScope;
    }

    @Override
    public final IllegalArgumentException unsuitableScope(String scopeName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsuitableScope$str(), scopeName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToIdentifyHttpScope$str() {
        return unableToIdentifyHttpScope;
    }

    @Override
    public final IllegalArgumentException unableToIdentifyHttpScope() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToIdentifyHttpScope$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNonceCount$str() {
        return invalidNonceCount;
    }

    @Override
    public final HttpAuthenticationException invalidNonceCount(int nonceCount) {
        HttpAuthenticationException result = new HttpAuthenticationException(String.format(this.getLoggingLocale(), this.invalidNonceCount$str(), nonceCount));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String asnUnrecognisedAlgorithm$str() {
        return asnUnrecognisedAlgorithm;
    }

    @Override
    public final ASN1Exception asnUnrecognisedAlgorithm(String algorithm) {
        ASN1Exception result = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnUnrecognisedAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String asnInvalidGeneralNameType$str() {
        return asnInvalidGeneralNameType;
    }

    @Override
    public final ASN1Exception asnInvalidGeneralNameType() {
        ASN1Exception result = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnInvalidGeneralNameType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String asnUnexpectedTag$str() {
        return asnUnexpectedTag;
    }

    @Override
    public final ASN1Exception asnUnexpectedTag() {
        ASN1Exception result = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnUnexpectedTag$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

