/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.credential._private.ElytronMessages;
import org.wildfly.security.password.impl.AbstractPasswordImpl;
import org.wildfly.security.password.interfaces.SimpleDigestPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.HashPasswordSpec;

class SimpleDigestPasswordImpl
extends AbstractPasswordImpl
implements SimpleDigestPassword {
    private static final long serialVersionUID = -5673285507422174313L;
    private final String algorithm;
    private final byte[] digest;

    SimpleDigestPasswordImpl(String algorithm, byte[] digest) {
        this.algorithm = algorithm;
        this.digest = digest;
    }

    SimpleDigestPasswordImpl(String algorithm, HashPasswordSpec spec) {
        this(algorithm, (byte[])spec.getDigest().clone());
    }

    SimpleDigestPasswordImpl(SimpleDigestPassword password) {
        this(password.getAlgorithm(), (byte[])password.getDigest().clone());
    }

    SimpleDigestPasswordImpl(String algorithm, ClearPasswordSpec spec) throws InvalidKeySpecException {
        this(algorithm, SimpleDigestPasswordImpl.getDigestOfKS(algorithm, spec.getEncodedPassword()));
    }

    SimpleDigestPasswordImpl(String algorithm, char[] chars) throws InvalidKeySpecException {
        this(algorithm, SimpleDigestPasswordImpl.getDigestOfKS(algorithm, chars));
    }

    @Override
    <S extends KeySpec> S getKeySpec(Class<S> keySpecType) throws InvalidKeySpecException {
        if (keySpecType.isAssignableFrom(HashPasswordSpec.class)) {
            return (S)((KeySpec)keySpecType.cast(new HashPasswordSpec((byte[])this.digest.clone())));
        }
        throw new InvalidKeySpecException();
    }

    static byte[] getDigestOfKS(String algorithm, char[] chars) throws InvalidKeySpecException {
        try {
            return SimpleDigestPasswordImpl.getDigestOf(algorithm, chars);
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.invalidKeySpecNoSuchMessageDigestAlgorithm(algorithm);
        }
    }

    static byte[] getDigestOf(String algorithm, char[] chars) throws NoSuchAlgorithmException {
        MessageDigest md = SimpleDigestPasswordImpl.getMessageDigest(algorithm);
        md.update(new String(chars).getBytes(StandardCharsets.UTF_8));
        return md.digest();
    }

    static MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException {
        switch (algorithm) {
            case "simple-digest-md2": {
                return MessageDigest.getInstance("MD2");
            }
            case "simple-digest-md5": {
                return MessageDigest.getInstance("MD5");
            }
            case "simple-digest-sha-1": {
                return MessageDigest.getInstance("SHA-1");
            }
            case "simple-digest-sha-256": {
                return MessageDigest.getInstance("SHA-256");
            }
            case "simple-digest-sha-384": {
                return MessageDigest.getInstance("SHA-384");
            }
            case "simple-digest-sha-512": {
                return MessageDigest.getInstance("SHA-512");
            }
        }
        throw ElytronMessages.log.noSuchAlgorithmInvalidAlgorithm(algorithm);
    }

    @Override
    boolean verify(char[] guess) throws InvalidKeyException {
        try {
            return Arrays.equals(this.digest, SimpleDigestPasswordImpl.getDigestOf(this.algorithm, guess));
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.invalidKeyNoSuchMessageDigestAlgorithm(this.algorithm);
        }
    }

    @Override
    <T extends KeySpec> boolean convertibleTo(Class<T> keySpecType) {
        return keySpecType.isAssignableFrom(HashPasswordSpec.class);
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered((int)Arrays.hashCode(this.digest), (int)this.algorithm.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleDigestPasswordImpl)) {
            return false;
        }
        SimpleDigestPasswordImpl other = (SimpleDigestPasswordImpl)obj;
        return this.algorithm.equals(other.algorithm) && Arrays.equals(this.digest, other.digest);
    }

    private void readObject(ObjectInputStream ignored) throws NotSerializableException {
        throw new NotSerializableException();
    }

    Object writeReplace() {
        return SimpleDigestPassword.createRaw(this.algorithm, this.digest);
    }

    @Override
    public SimpleDigestPasswordImpl clone() {
        return this;
    }
}

