/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.credential._private.ElytronMessages;
import org.wildfly.security.keystore.LdapGeneralizedTimeUtil;
import org.wildfly.security.util.LdapUtil;

class LdapKeyStoreSpi
extends KeyStoreSpi {
    private final String ENV_BINARY_ATTRIBUTES = "java.naming.ldap.attributes.binary";
    private final String CREATE_TIMESTAMP_ATTRIBUTE = "createTimestamp";
    private final String MODIFY_TIMESTAMP_ATTRIBUTE = "modifyTimestamp";
    private final ExceptionSupplier<DirContext, NamingException> dirContextSupplier;
    private final String searchPath;
    private final int searchScope;
    private final int searchTimeLimit;
    private final String filterAlias;
    private final String filterCertificate;
    private final String filterIterate;
    private final LdapName createPath;
    private final String createRdn;
    private final Attributes createAttributes;
    private final String aliasAttribute;
    private final String certificateAttribute;
    private final String certificateType;
    private final String certificateChainAttribute;
    private final String certificateChainEncoding;
    private final String keyAttribute;
    private final String keyType;
    private Object binaryAttributesBackup;

    LdapKeyStoreSpi(ExceptionSupplier<DirContext, NamingException> dirContextSupplier, String searchPath, int searchScope, int searchTimeLimit, String filterAlias, String filterCertificate, String filterIterate, LdapName createPath, String createRdn, Attributes createAttributes, String aliasAttribute, String certificateAttribute, String certificateType, String certificateChainAttribute, String certificateChainEncoding, String keyAttribute, String keyType) {
        this.dirContextSupplier = dirContextSupplier;
        this.searchPath = searchPath;
        this.searchScope = searchScope;
        this.searchTimeLimit = searchTimeLimit;
        this.filterAlias = filterAlias;
        this.filterCertificate = filterCertificate;
        this.filterIterate = filterIterate;
        this.createPath = createPath;
        this.createRdn = createRdn;
        this.createAttributes = createAttributes;
        this.aliasAttribute = aliasAttribute;
        this.certificateAttribute = certificateAttribute;
        this.certificateType = certificateType;
        this.certificateChainAttribute = certificateChainAttribute;
        this.certificateChainEncoding = certificateChainEncoding;
        this.keyAttribute = keyAttribute;
        this.keyType = keyType;
    }

    private DirContext obtainDirContext() {
        try {
            DirContext context = (DirContext)this.dirContextSupplier.get();
            this.binaryAttributesBackup = context.getEnvironment().get("java.naming.ldap.attributes.binary");
            context.addToEnvironment("java.naming.ldap.attributes.binary", String.join((CharSequence)" ", this.certificateAttribute, this.certificateChainAttribute, this.keyAttribute));
            return context;
        }
        catch (NamingException e) {
            throw ElytronMessages.log.failedToObtainDirContext(e);
        }
    }

    private void returnDirContext(DirContext context) {
        try {
            if (this.binaryAttributesBackup == null) {
                context.removeFromEnvironment("java.naming.ldap.attributes.binary");
            } else {
                context.addToEnvironment("java.naming.ldap.attributes.binary", this.binaryAttributesBackup);
            }
            context.close();
        }
        catch (NamingException e) {
            throw ElytronMessages.log.failedToReturnDirContext(e);
        }
    }

    private SearchControls createSearchControl(String[] returningAttributes) {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(this.searchScope);
        controls.setTimeLimit(this.searchTimeLimit);
        controls.setReturningAttributes(returningAttributes);
        return controls;
    }

    private SearchResult searchAlias(DirContext dirContext, String alias, byte[] cert, String[] returningAttributes) throws NamingException {
        NamingEnumeration<SearchResult> results;
        SearchControls ctls = this.createSearchControl(returningAttributes);
        NamingEnumeration<SearchResult> namingEnumeration = results = cert == null ? dirContext.search(this.searchPath, this.filterAlias, (Object[])new String[]{alias}, ctls) : dirContext.search(this.searchPath, this.filterCertificate, new Object[]{cert}, ctls);
        if (!results.hasMore()) {
            ElytronMessages.log.debugf("Alias [%s] not found in LdapKeyStore", (Object)alias);
            return null;
        }
        return results.next();
    }

    private Attributes obtainAliasOrCertificateAttributes(String alias, byte[] cert, String[] attributes) {
        DirContext context = this.obtainDirContext();
        if (context == null) {
            ElytronMessages.log.trace("Unable to obtain DirContext");
            return null;
        }
        try {
            SearchResult result = this.searchAlias(context, alias, cert, attributes);
            if (result == null) {
                Attributes attributes2 = null;
                return attributes2;
            }
            Attributes attributes3 = result.getAttributes();
            return attributes3;
        }
        catch (NamingException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToObtainAlias(alias, e);
        }
        finally {
            this.returnDirContext(context);
        }
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Attributes attributes = this.obtainAliasOrCertificateAttributes(alias, null, new String[]{this.certificateAttribute});
        if (attributes == null) {
            ElytronMessages.log.tracef("Alias [%s] does not exist", (Object)alias);
            return null;
        }
        try {
            Attribute attribute = LdapUtil.getBinaryAttribute(attributes, this.certificateAttribute);
            if (attribute == null) {
                return null;
            }
            byte[] bytes = (byte[])attribute.get();
            if (bytes == null) {
                return null;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            CertificateFactory certFactory = CertificateFactory.getInstance(this.certificateType);
            return certFactory.generateCertificate(is);
        }
        catch (CertificateException | NamingException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToObtainCertificate(alias, e);
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Attributes attributes = this.obtainAliasOrCertificateAttributes(alias, null, new String[]{this.certificateChainAttribute});
        if (attributes == null) {
            ElytronMessages.log.tracef("Alias [%s] does not exist", (Object)alias);
            return null;
        }
        try {
            Attribute attribute = LdapUtil.getBinaryAttribute(attributes, this.certificateChainAttribute);
            if (attribute == null) {
                return null;
            }
            byte[] bytes = (byte[])attribute.get();
            if (bytes == null) {
                return null;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            CertificateFactory certFactory = CertificateFactory.getInstance(this.certificateType);
            Collection<? extends Certificate> chain = certFactory.generateCertificates(is);
            return chain.toArray(new Certificate[chain.size()]);
        }
        catch (CertificateException | NamingException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToObtainCertificateChain(alias, e);
        }
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Attributes attributes = this.obtainAliasOrCertificateAttributes(alias, null, new String[]{this.keyAttribute});
        if (attributes == null) {
            ElytronMessages.log.tracef("Alias [%s] does not exist", (Object)alias);
            return null;
        }
        try {
            Attribute attribute = LdapUtil.getBinaryAttribute(attributes, this.keyAttribute);
            if (attribute == null) {
                return null;
            }
            byte[] bytes = (byte[])attribute.get();
            if (bytes == null) {
                return null;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            KeyStore keystore = KeyStore.getInstance(this.keyType);
            keystore.load(is, password);
            String firstAlias = keystore.aliases().nextElement();
            return keystore.getKey(firstAlias, password);
        }
        catch (IOException | KeyStoreException | CertificateException | NamingException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToRecoverKey(alias, e);
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        Attributes attributes = this.obtainAliasOrCertificateAttributes(alias, null, new String[]{"createTimestamp", "modifyTimestamp"});
        if (attributes == null) {
            ElytronMessages.log.tracef("Alias [%s] does not exist", (Object)alias);
            return null;
        }
        try {
            Attribute creationAttribute = attributes.get("createTimestamp");
            Attribute modificationAttribute = attributes.get("modifyTimestamp");
            if (modificationAttribute != null && modificationAttribute.get() != null) {
                return LdapGeneralizedTimeUtil.generalizedTimeToDate((String)modificationAttribute.get());
            }
            if (creationAttribute != null && creationAttribute.get() != null) {
                return LdapGeneralizedTimeUtil.generalizedTimeToDate((String)creationAttribute.get());
            }
            ElytronMessages.log.tracef("LDAP entry of alias [%s] does not have create nor modify timestamp attributes", (Object)alias);
            return null;
        }
        catch (ParseException | NamingException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToObtainCreationDate(alias, e);
        }
    }

    private void storeAttributes(String alias, List<ModificationItem> items) throws KeyStoreException {
        DirContext context = this.obtainDirContext();
        try {
            LdapName distinguishName;
            SearchResult result = this.searchAlias(context, alias, null, new String[0]);
            if (result == null) {
                if (this.createPath == null || this.createAttributes == null || this.createRdn == null) {
                    throw ElytronMessages.log.creationNotConfigured(alias);
                }
                distinguishName = (LdapName)this.createPath.clone();
                distinguishName.add(new Rdn(this.createRdn, alias));
                ElytronMessages.log.debugf("Creating keystore alias [%s] with DN [%s] in LDAP", (Object)alias, (Object)distinguishName.toString());
                context.createSubcontext(distinguishName, this.createAttributes);
                items.add(new ModificationItem(2, new BasicAttribute(this.aliasAttribute, alias)));
            } else {
                distinguishName = new LdapName(result.getNameInNamespace());
            }
            context.modifyAttributes(distinguishName, items.toArray(new ModificationItem[items.size()]));
        }
        catch (NamingException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToStore(alias, e);
        }
        finally {
            this.returnDirContext(context);
        }
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        LinkedList<ModificationItem> items = new LinkedList<ModificationItem>();
        try {
            BasicAttribute attribute = new BasicAttribute(this.certificateAttribute);
            attribute.add(cert.getEncoded());
            items.add(new ModificationItem(2, attribute));
        }
        catch (CertificateEncodingException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToSerializeCertificate(alias, e);
        }
        this.storeAttributes(alias, items);
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            KeyStore keystore = KeyStore.getInstance(this.keyType);
            keystore.load(null, password);
            keystore.setKeyEntry(alias, key, password, chain);
            keystore.store(os, password);
            byte[] keystoreBytes = os.toByteArray();
            this.engineSetKeyEntry(alias, keystoreBytes, chain);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToSerializeKey(alias, e);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] keystoreBytes, Certificate[] chain) throws KeyStoreException {
        try {
            LinkedList<ModificationItem> items = new LinkedList<ModificationItem>();
            items.add(new ModificationItem(2, new BasicAttribute(this.keyAttribute, keystoreBytes)));
            CertificateFactory certFactory = CertificateFactory.getInstance(this.certificateType);
            CertPath certPath = certFactory.generateCertPath(Arrays.asList(chain));
            BasicAttribute chainAttr = new BasicAttribute(this.certificateChainAttribute, certPath.getEncoded(this.certificateChainEncoding));
            items.add(new ModificationItem(2, chainAttr));
            BasicAttribute certificateAttr = new BasicAttribute(this.certificateAttribute, chain[0].getEncoded());
            items.add(new ModificationItem(2, certificateAttr));
            this.storeAttributes(alias, items);
        }
        catch (CertificateException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToSerializeCertificate(alias, e);
        }
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        DirContext context = this.obtainDirContext();
        try {
            SearchResult result = this.searchAlias(context, alias, null, new String[0]);
            if (result == null) {
                throw ElytronMessages.log.ldapKeyStoreFailedToDeleteNonExisting(alias);
            }
            context.destroySubcontext(result.getNameInNamespace());
        }
        catch (NamingException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToDelete(alias, e);
        }
        finally {
            this.returnDirContext(context);
        }
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        DirContext context = this.obtainDirContext();
        if (context == null) {
            ElytronMessages.log.trace("Unable to obtain DirContext");
            return false;
        }
        try {
            NamingEnumeration<SearchResult> results = context.search(this.searchPath, this.filterAlias, (Object[])new String[]{alias}, this.createSearchControl(new String[]{this.aliasAttribute}));
            boolean found = results.hasMore();
            results.close();
            boolean bl = found;
            return bl;
        }
        catch (NamingException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToTestAliasExistence(alias, e);
        }
        finally {
            this.returnDirContext(context);
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        DirContext context = this.obtainDirContext();
        if (context == null) {
            ElytronMessages.log.trace("Unable to obtain DirContext");
            return null;
        }
        try {
            NamingEnumeration<SearchResult> results = context.search(this.searchPath, this.filterIterate, null, this.createSearchControl(new String[]{this.aliasAttribute}));
            LinkedList<String> aliases = new LinkedList<String>();
            while (results.hasMore()) {
                Attribute attribute = results.next().getAttributes().get(this.aliasAttribute);
                if (attribute == null) continue;
                aliases.add((String)attribute.get());
            }
            Enumeration<String> enumeration = Collections.enumeration(aliases);
            return enumeration;
        }
        catch (NamingException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToIterateAliases(e);
        }
        finally {
            this.returnDirContext(context);
        }
    }

    @Override
    public int engineSize() {
        DirContext context = this.obtainDirContext();
        if (context == null) {
            ElytronMessages.log.trace("Unable to obtain DirContext");
            return 0;
        }
        try {
            NamingEnumeration<SearchResult> results = context.search(this.searchPath, this.filterIterate, null, this.createSearchControl(new String[]{this.aliasAttribute}));
            int count = 0;
            while (results.hasMore()) {
                results.next();
                ++count;
            }
            int n = count;
            return n;
        }
        catch (NamingException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToIterateAliases(e);
        }
        finally {
            this.returnDirContext(context);
        }
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        Attribute attribute;
        Attributes attributes = this.obtainAliasOrCertificateAttributes(alias, null, new String[]{this.keyAttribute});
        Attribute attribute2 = attribute = attributes == null ? null : LdapUtil.getBinaryAttribute(attributes, this.keyAttribute);
        if (attribute == null) {
            ElytronMessages.log.tracef("Alias [%s] is not key entry", (Object)alias);
            return false;
        }
        try {
            byte[] bytes = (byte[])attribute.get();
            return bytes != null;
        }
        catch (NamingException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToObtainKey(alias, e);
        }
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        Attributes attributes = this.obtainAliasOrCertificateAttributes(alias, null, new String[]{this.certificateAttribute});
        if (attributes == null) {
            return false;
        }
        Attribute attribute = LdapUtil.getBinaryAttribute(attributes, this.certificateAttribute);
        if (attribute == null) {
            return false;
        }
        try {
            byte[] bytes = (byte[])attribute.get();
            return bytes != null;
        }
        catch (NamingException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToObtainKey(alias, e);
        }
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        try {
            Attribute attribute;
            byte[] certBytes = cert.getEncoded();
            Attributes attributes = this.obtainAliasOrCertificateAttributes(null, certBytes, new String[]{this.aliasAttribute});
            Attribute attribute2 = attribute = attributes == null ? null : attributes.get(this.aliasAttribute);
            if (attribute == null) {
                ElytronMessages.log.tracef("Certificate not found in LDAP: [%s]", (Object)cert);
                return null;
            }
            return (String)attribute.get();
        }
        catch (CertificateException | NamingException e) {
            throw ElytronMessages.log.ldapKeyStoreFailedToObtainAliasByCertificate(e);
        }
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }
}

