/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.io.Serializable;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.naming.NamingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.realm.ldap.ElytronMessages;
import org.wildfly.security.auth.server.RealmUnavailableException;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String emptyParameter = "ELY00002: Parameter %s is empty";
    private static final String builderAlreadyBuilt = "ELY00003: This builder has already been built";
    private static final String unrecognizedAlgorithm = "ELY00004: Unrecognized algorithm \"%s\"";
    private static final String credentialDestroyingFailed = "ELY00007: Credential destroying failed";
    private static final String couldNotObtainCredential = "ELY01041: Could not obtain credential";
    private static final String couldNotObtainCredentialWithCause = "ELY01042: Could not obtain credential";
    private static final String insufficientDataToFormDigestAndSalt = "ELY01053: Insufficient data to form a digest and a salt";
    private static final String invalidSalt2 = "ELY01054: Invalid salt \"%s%s\"";
    private static final String invalidRounds = "ELY01055: Invalid rounds \"%s%s%s%s\"";
    private static final String invalidSalt4 = "ELY01056: Invalid salt \"%s%s%s%s\"";
    private static final String noDirContextSupplierSet = "ELY01057: No DirContext supplier set";
    private static final String noPrincipalMappingDefinition = "ELY01058: No principal mapping definition";
    private static final String couldNotObtainPrincipal = "ELY01060: Could not obtain principal";
    private static final String noProviderUrlSet = "ELY01062: No provider URL has been set";
    private static final String invalidName = "ELY01064: Invalid identity name";
    private static final String ldapRealmFailedObtainAttributes = "ELY01079: Ldap-backed realm failed to obtain attributes for entry [%s]";
    private static final String ldapRealmInvalidRdnForAttribute = "ELY01080: Attribute [%s] value [%s] must be in X.500 format in order to obtain RDN [%s].";
    private static final String ldapRealmIdentityNotExists = "ELY01083: Ldap-backed realm cannot to obtain not existing identity \"%s\"";
    private static final String ldapRealmErrorWhileConsumingResultsFromSearch = "ELY01084: Error while consuming results from search. SearchDn [%s], Filter [%s], Filter Args [%s].";
    private static final String ldapRealmsPersisterNotSupported = "ELY01085: LDAP realm persister does not support given credential type";
    private static final String ldapRealmCredentialPersistingFailed = "ELY01086: Persisting credential %s into Ldap-backed realm failed. Identity dn: \"%s\"";
    private static final String ldapRealmCredentialClearingFailed = "ELY01087: Clearing credentials from Ldap-backed realm failed. Identity dn: \"%s\"";
    private static final String unknownLdapPasswordScheme = "ELY01090: Unknown LDAP password scheme";
    private static final String noSuchIdentity = "ELY01096: No such identity";
    private static final String ldapRealmFailedDeleteIdentityFromServer = "ELY01097: Ldap-backed realm failed to delete identity from server";
    private static final String ldapRealmFailedCreateIdentityOnServer = "ELY01098: Ldap-backed realm failed to create identity on server";
    private static final String ldapRealmNotConfiguredToSupportCreatingIdentities = "ELY01099: Ldap-backed realm is not configured to allow create new identities (new identity parent and attributes has to be set)";
    private static final String ldapRealmCannotSetAttributeWithoutMapping = "ELY01100: Ldap-backed realm does not contain mapping to set Elytron attribute \"%s\" of identity \"%s\"";
    private static final String ldapRealmDoesNotSupportSettingFilteredAttribute = "ELY01101: Ldap-backed realm does not support setting of filtered attribute \"%s\" (identity \"%s\")";
    private static final String ldapRealmRequiresExactlyOneRdnAttribute = "ELY01102: Ldap-backed realm requires exactly one value of attribute \"%s\" mapped to RDN (identity \"%s\")";
    private static final String ldapRealmAttributesSettingFailed = "ELY01103: Ldap-backed realm failed to set attributes of identity \"%s\"";
    private static final String ldapRealmIdentitySearchFailed = "ELY01108: Ldap-backed realm identity search failed";
    private static final String ldapRealmNotConfiguredToSupportIteratingOverIdentities = "ELY01109: Ldap-backed realm is not configured to allow iterate over identities (iterator filter has to be set)";
    private static final String ldapRealmFailedToObtainContext = "ELY01125: Ldap-backed realm failed to obtain context";
    private static final String ldapRealmDeferRegistration = "ELY01146: LDAP Realm unable to register listener, defering action.";
    private static final String ldapInvalidLdapName = "ELY01147: Invalid LDAP name [%s]";
    private static final String obtainingDirContextCredentialFromAuthenticationContextFailed = "ELY01150: Obtaining DirContext credentials from AuthenticationContext failed.";
    private static final String directLdapVerificationFailed = "ELY01153: Direct LDAP verification failed with DN [%s] and absolute DN [%s]";
    private static final String threadLocalSslSocketFactoryThreadLocalNotSet = "ELY04025: DirContext tries to connect without ThreadLocalSSLSocketFactory thread local setting";

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String emptyParameter$str() {
        return emptyParameter;
    }

    @Override
    public final IllegalArgumentException emptyParameter(String parameter) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.emptyParameter$str(), parameter));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String builderAlreadyBuilt$str() {
        return builderAlreadyBuilt;
    }

    @Override
    public final IllegalStateException builderAlreadyBuilt() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.builderAlreadyBuilt$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unrecognizedAlgorithm$str() {
        return unrecognizedAlgorithm;
    }

    @Override
    public final IllegalArgumentException unrecognizedAlgorithm(String algorithm) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unrecognizedAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void credentialDestroyingFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.credentialDestroyingFailed$str(), new Object[0]);
    }

    protected String credentialDestroyingFailed$str() {
        return credentialDestroyingFailed;
    }

    protected String couldNotObtainCredential$str() {
        return couldNotObtainCredential;
    }

    @Override
    public final RuntimeException couldNotObtainCredential() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotObtainCredential$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotObtainCredentialWithCause$str() {
        return couldNotObtainCredentialWithCause;
    }

    @Override
    public final RuntimeException couldNotObtainCredentialWithCause(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotObtainCredentialWithCause$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String insufficientDataToFormDigestAndSalt$str() {
        return insufficientDataToFormDigestAndSalt;
    }

    @Override
    public final InvalidKeySpecException insufficientDataToFormDigestAndSalt() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.insufficientDataToFormDigestAndSalt$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSalt2$str() {
        return invalidSalt2;
    }

    @Override
    public final IllegalArgumentException invalidSalt(char lo, char hi) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidSalt2$str(), Character.valueOf(lo), Character.valueOf(hi)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRounds$str() {
        return invalidRounds;
    }

    @Override
    public final IllegalArgumentException invalidRounds(char b0, char b1, char b2, char b3) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidRounds$str(), Character.valueOf(b0), Character.valueOf(b1), Character.valueOf(b2), Character.valueOf(b3)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSalt4$str() {
        return invalidSalt4;
    }

    @Override
    public final IllegalArgumentException invalidSalt(char b0, char b1, char b2, char b3) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidSalt4$str(), Character.valueOf(b0), Character.valueOf(b1), Character.valueOf(b2), Character.valueOf(b3)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDirContextSupplierSet$str() {
        return noDirContextSupplierSet;
    }

    @Override
    public final IllegalStateException noDirContextSupplierSet() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noDirContextSupplierSet$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noPrincipalMappingDefinition$str() {
        return noPrincipalMappingDefinition;
    }

    @Override
    public final IllegalStateException noPrincipalMappingDefinition() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noPrincipalMappingDefinition$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotObtainPrincipal$str() {
        return couldNotObtainPrincipal;
    }

    @Override
    public final RuntimeException couldNotObtainPrincipal() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotObtainPrincipal$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noProviderUrlSet$str() {
        return noProviderUrlSet;
    }

    @Override
    public final IllegalStateException noProviderUrlSet() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noProviderUrlSet$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidName$str() {
        return invalidName;
    }

    @Override
    public final IllegalArgumentException invalidName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapRealmFailedObtainAttributes$str() {
        return ldapRealmFailedObtainAttributes;
    }

    @Override
    public final RuntimeException ldapRealmFailedObtainAttributes(String dn, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.ldapRealmFailedObtainAttributes$str(), dn), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapRealmInvalidRdnForAttribute$str() {
        return ldapRealmInvalidRdnForAttribute;
    }

    @Override
    public final RuntimeException ldapRealmInvalidRdnForAttribute(String attributeName, String value, String rdn, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.ldapRealmInvalidRdnForAttribute$str(), attributeName, value, rdn), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapRealmIdentityNotExists$str() {
        return ldapRealmIdentityNotExists;
    }

    @Override
    public final RealmUnavailableException ldapRealmIdentityNotExists(String identity) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmIdentityNotExists$str(), identity));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapRealmErrorWhileConsumingResultsFromSearch$str() {
        return ldapRealmErrorWhileConsumingResultsFromSearch;
    }

    @Override
    public final RuntimeException ldapRealmErrorWhileConsumingResultsFromSearch(String searchDn, String filter, String filterArgs, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.ldapRealmErrorWhileConsumingResultsFromSearch$str(), searchDn, filter, filterArgs), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapRealmsPersisterNotSupported$str() {
        return ldapRealmsPersisterNotSupported;
    }

    @Override
    public final RealmUnavailableException ldapRealmsPersisterNotSupported() {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmsPersisterNotSupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapRealmCredentialPersistingFailed$str() {
        return ldapRealmCredentialPersistingFailed;
    }

    @Override
    public final RealmUnavailableException ldapRealmCredentialPersistingFailed(String credential, String dn, Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmCredentialPersistingFailed$str(), credential, dn), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapRealmCredentialClearingFailed$str() {
        return ldapRealmCredentialClearingFailed;
    }

    @Override
    public final RealmUnavailableException ldapRealmCredentialClearingFailed(String dn, Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmCredentialClearingFailed$str(), dn), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownLdapPasswordScheme$str() {
        return unknownLdapPasswordScheme;
    }

    @Override
    public final InvalidKeySpecException unknownLdapPasswordScheme() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.unknownLdapPasswordScheme$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSuchIdentity$str() {
        return noSuchIdentity;
    }

    @Override
    public final RealmUnavailableException noSuchIdentity() {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.noSuchIdentity$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapRealmFailedDeleteIdentityFromServer$str() {
        return ldapRealmFailedDeleteIdentityFromServer;
    }

    @Override
    public final RealmUnavailableException ldapRealmFailedDeleteIdentityFromServer(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmFailedDeleteIdentityFromServer$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapRealmFailedCreateIdentityOnServer$str() {
        return ldapRealmFailedCreateIdentityOnServer;
    }

    @Override
    public final RealmUnavailableException ldapRealmFailedCreateIdentityOnServer(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmFailedCreateIdentityOnServer$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapRealmNotConfiguredToSupportCreatingIdentities$str() {
        return ldapRealmNotConfiguredToSupportCreatingIdentities;
    }

    @Override
    public final RealmUnavailableException ldapRealmNotConfiguredToSupportCreatingIdentities() {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmNotConfiguredToSupportCreatingIdentities$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapRealmCannotSetAttributeWithoutMapping$str() {
        return ldapRealmCannotSetAttributeWithoutMapping;
    }

    @Override
    public final RealmUnavailableException ldapRealmCannotSetAttributeWithoutMapping(String attribute, String identity) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmCannotSetAttributeWithoutMapping$str(), attribute, identity));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void ldapRealmDoesNotSupportSettingFilteredAttribute(String attribute, String identity) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.ldapRealmDoesNotSupportSettingFilteredAttribute$str(), (Object)attribute, (Object)identity);
    }

    protected String ldapRealmDoesNotSupportSettingFilteredAttribute$str() {
        return ldapRealmDoesNotSupportSettingFilteredAttribute;
    }

    protected String ldapRealmRequiresExactlyOneRdnAttribute$str() {
        return ldapRealmRequiresExactlyOneRdnAttribute;
    }

    @Override
    public final RealmUnavailableException ldapRealmRequiresExactlyOneRdnAttribute(String attribute, String identity) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmRequiresExactlyOneRdnAttribute$str(), attribute, identity));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapRealmAttributesSettingFailed$str() {
        return ldapRealmAttributesSettingFailed;
    }

    @Override
    public final RealmUnavailableException ldapRealmAttributesSettingFailed(String identity, Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmAttributesSettingFailed$str(), identity), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapRealmIdentitySearchFailed$str() {
        return ldapRealmIdentitySearchFailed;
    }

    @Override
    public final RealmUnavailableException ldapRealmIdentitySearchFailed(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmIdentitySearchFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapRealmNotConfiguredToSupportIteratingOverIdentities$str() {
        return ldapRealmNotConfiguredToSupportIteratingOverIdentities;
    }

    @Override
    public final RealmUnavailableException ldapRealmNotConfiguredToSupportIteratingOverIdentities() {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmNotConfiguredToSupportIteratingOverIdentities$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapRealmFailedToObtainContext$str() {
        return ldapRealmFailedToObtainContext;
    }

    @Override
    public final RealmUnavailableException ldapRealmFailedToObtainContext(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmFailedToObtainContext$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void ldapRealmDeferRegistration() {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.ldapRealmDeferRegistration$str(), new Object[0]);
    }

    protected String ldapRealmDeferRegistration$str() {
        return ldapRealmDeferRegistration;
    }

    protected String ldapInvalidLdapName$str() {
        return ldapInvalidLdapName;
    }

    @Override
    public final RuntimeException ldapInvalidLdapName(String name, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.ldapInvalidLdapName$str(), name), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String obtainingDirContextCredentialFromAuthenticationContextFailed$str() {
        return obtainingDirContextCredentialFromAuthenticationContextFailed;
    }

    @Override
    public final NamingException obtainingDirContextCredentialFromAuthenticationContextFailed(Throwable cause) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.obtainingDirContextCredentialFromAuthenticationContextFailed$str(), new Object[0]));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String directLdapVerificationFailed$str() {
        return directLdapVerificationFailed;
    }

    @Override
    public final RealmUnavailableException directLdapVerificationFailed(String distinguishedName, String absoluteName, Exception e) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.directLdapVerificationFailed$str(), distinguishedName, absoluteName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String threadLocalSslSocketFactoryThreadLocalNotSet$str() {
        return threadLocalSslSocketFactoryThreadLocalNotSet;
    }

    @Override
    public final IllegalStateException threadLocalSslSocketFactoryThreadLocalNotSet() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.threadLocalSslSocketFactoryThreadLocalNotSet$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

