/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CachedIdentityAuthorizeCallback;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.cache.IdentityCache;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.Scope;
import org.wildfly.security.http.impl.UsernamePasswordAuthenticationMechanism;

final class FormAuthenticationMechanism
extends UsernamePasswordAuthenticationMechanism {
    private static final String USERNAME = "j_username";
    private static final String PASSWORD = "j_password";
    private static final String LOCATION_KEY = FormAuthenticationMechanism.class.getName() + ".Location";
    private static final String CACHED_IDENTITY_KEY = FormAuthenticationMechanism.class.getName() + ".elytron-identity";
    private static final String DEFAULT_POST_LOCATION = "j_security_check";
    private final String contextPath;
    private final String loginPage;
    private final String errorPage;
    private final String postLocation;

    FormAuthenticationMechanism(CallbackHandler callbackHandler, Map<String, ?> properties) {
        super((CallbackHandler)Assert.checkNotNullParam((String)"callbackHandler", (Object)callbackHandler));
        Assert.checkNotNullParam((String)"properties", properties);
        String postLocation = (String)properties.get(HttpConstants.CONFIG_POST_LOCATION);
        this.postLocation = postLocation != null ? postLocation : DEFAULT_POST_LOCATION;
        this.contextPath = properties.containsKey(HttpConstants.CONFIG_CONTEXT_PATH) ? (String)properties.get(HttpConstants.CONFIG_CONTEXT_PATH) : "";
        this.loginPage = (String)properties.get(HttpConstants.CONFIG_LOGIN_PAGE);
        this.errorPage = (String)properties.get(HttpConstants.CONFIG_ERROR_PAGE);
    }

    @Override
    public String getMechanismName() {
        return "FORM";
    }

    @Override
    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        if (this.attemptReAuthentication(request)) {
            return;
        }
        if ("POST".equals(request.getRequestMethod()) && this.isAuthenticationRequest(request.getRequestURI().getPath())) {
            this.attemptAuthentication(request);
            return;
        }
        if (this.loginPage != null) {
            request.noAuthenticationInProgress(response -> this.sendLogin(request, response));
        }
    }

    private boolean isAuthenticationRequest(String path) {
        int lastSlash = path.lastIndexOf(47);
        int pathParam = path.indexOf(59, lastSlash > 0 ? lastSlash : 0);
        String target = path.substring(lastSlash >= 0 ? lastSlash + 1 : 0, pathParam > 0 ? pathParam : path.length());
        return target.equals(this.postLocation);
    }

    private IdentityCache createIdentityCache(final HttpServerRequest request) {
        return new IdentityCache(){

            @Override
            public void put(SecurityIdentity identity) {
                HttpScope session = FormAuthenticationMechanism.this.getSessionScope(request, true);
                if (session == null || !session.exists()) {
                    return;
                }
                if (session.supportsChangeID() && session.getAttachment(CACHED_IDENTITY_KEY) == null) {
                    String originalSessionID = session.getID();
                    session.changeID();
                    String newSessionID = session.getID();
                    FormAuthenticationMechanism.this.fixCachedLocation(session, originalSessionID, newSessionID);
                }
                session.setAttachment(CACHED_IDENTITY_KEY, new CachedIdentity(FormAuthenticationMechanism.this.getMechanismName(), identity));
            }

            @Override
            public CachedIdentity get() {
                HttpScope session = FormAuthenticationMechanism.this.getSessionScope(request, false);
                if (session == null || !session.exists()) {
                    return null;
                }
                return (CachedIdentity)session.getAttachment(CACHED_IDENTITY_KEY);
            }

            @Override
            public CachedIdentity remove() {
                HttpScope session = FormAuthenticationMechanism.this.getSessionScope(request, false);
                if (session == null || !session.exists()) {
                    return null;
                }
                CachedIdentity cachedIdentity = this.get();
                session.setAttachment(CACHED_IDENTITY_KEY, null);
                return cachedIdentity;
            }
        };
    }

    private void fixCachedLocation(HttpScope scope, String originalSessionID, String newSessionID) {
        String originalPath = scope.getAttachment(LOCATION_KEY, String.class);
        if (originalPath != null && originalPath.contains(originalSessionID) && !originalSessionID.equals(newSessionID)) {
            String newPath = originalPath.replace(originalSessionID, newSessionID);
            scope.setAttachment(LOCATION_KEY, newPath);
        }
    }

    private void error(String message, HttpServerRequest request) {
        request.authenticationFailed(message, response -> this.sendPage(this.errorPage, request, response));
    }

    private void attemptAuthentication(HttpServerRequest request) throws HttpAuthenticationException {
        String username = request.getFirstParameterValue(USERNAME);
        String password = request.getFirstParameterValue(PASSWORD);
        if (username == null || username.length() == 0 || password == null) {
            this.error(ElytronMessages.httpForm.usernameOrPasswordMissing(), request);
            return;
        }
        char[] passwordChars = password.toCharArray();
        try {
            if (this.authenticate(null, username, passwordChars)) {
                IdentityCache identityCache = this.createIdentityCache(request);
                if (this.authorize(username, request, identityCache)) {
                    ElytronMessages.httpForm.debugf("User [%s] authenticated successfully", username);
                    this.succeed();
                    HttpScope session = this.getSessionScope(request, true);
                    HttpServerMechanismsResponder responder = null;
                    if (session != null && session.exists()) {
                        String postAuthenticationPath;
                        String originalPath = session.getAttachment(LOCATION_KEY, String.class);
                        if (originalPath != null) {
                            postAuthenticationPath = originalPath;
                            ElytronMessages.httpForm.tracef("User redirected to original path [%s]", postAuthenticationPath);
                        } else {
                            URI requestUri = request.getRequestURI();
                            String currentPath = requestUri.getPath();
                            StringBuilder sb = new StringBuilder();
                            String scheme = requestUri.getScheme();
                            sb.append(scheme);
                            sb.append("://");
                            sb.append(requestUri.getHost());
                            int port = requestUri.getPort();
                            if (FormAuthenticationMechanism.appendPort(scheme, port)) {
                                sb.append(':').append(port);
                            }
                            sb.append(currentPath.substring(0, currentPath.indexOf(DEFAULT_POST_LOCATION)));
                            postAuthenticationPath = sb.toString();
                            ElytronMessages.httpForm.tracef("User redirected to default path [%s]", postAuthenticationPath);
                        }
                        session.setAttachment(LOCATION_KEY, null);
                        responder = response -> this.sendRedirect(response, postAuthenticationPath);
                    }
                    request.authenticationComplete(responder, identityCache::remove);
                    return;
                }
                ElytronMessages.httpForm.debugf("User [%s] authorization failed", username);
                this.failAndRedirectToErrorPage(request, username);
                return;
            }
            ElytronMessages.httpForm.debugf("User [%s] authentication failed", username);
            this.failAndRedirectToErrorPage(request, username);
            return;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new HttpAuthenticationException(e);
        }
        finally {
            Arrays.fill(passwordChars, '\u0000');
        }
    }

    private boolean authorize(String username, HttpServerRequest request, IdentityCache identityCache) throws HttpAuthenticationException {
        ElytronMessages.httpForm.tracef("Authorizing username: [%s], Request URI: [%s], Context path: [%s]", username, request.getRequestURI(), this.contextPath);
        if (identityCache != null) {
            CachedIdentityAuthorizeCallback authorizeCallback = new CachedIdentityAuthorizeCallback(username, identityCache);
            try {
                this.callbackHandler.handle(new Callback[]{authorizeCallback});
                return authorizeCallback.isAuthorized();
            }
            catch (IOException | UnsupportedCallbackException e) {
                throw new HttpAuthenticationException(e);
            }
        }
        return super.authorize(username);
    }

    private boolean attemptReAuthentication(HttpServerRequest request) throws HttpAuthenticationException {
        IdentityCache identityCache;
        if (ElytronMessages.httpForm.isTraceEnabled()) {
            HttpScope sessionScope = this.getSessionScope(request, false);
            if (sessionScope != null && sessionScope.exists()) {
                ElytronMessages.httpForm.tracef("Trying to re-authenticate session %s. Request URI: [%s], Context path: [%s]", sessionScope.getID(), request.getRequestURI(), this.contextPath);
            } else {
                ElytronMessages.httpForm.tracef("Trying to re-authenticate. There is no session attached to the following request. Request URI: [%s], Context path: [%s]", request.getRequestURI(), this.contextPath);
            }
        }
        if ((identityCache = this.createIdentityCache(request)) != null) {
            CachedIdentityAuthorizeCallback authorizeCallback = new CachedIdentityAuthorizeCallback(identityCache);
            try {
                this.callbackHandler.handle(new Callback[]{authorizeCallback});
            }
            catch (IOException | UnsupportedCallbackException e) {
                throw new HttpAuthenticationException(e);
            }
            if (authorizeCallback.isAuthorized()) {
                try {
                    this.succeed();
                }
                catch (IOException | UnsupportedCallbackException e) {
                    throw new HttpAuthenticationException(e);
                }
                request.authenticationComplete(null, identityCache::remove);
                request.resumeRequest();
                return true;
            }
        }
        return false;
    }

    private void failAndRedirectToErrorPage(HttpServerRequest request, String username) throws IOException, UnsupportedCallbackException {
        IdentityCache identityCache = this.createIdentityCache(request);
        if (identityCache != null) {
            identityCache.remove();
        }
        this.fail();
        this.error(ElytronMessages.httpForm.authorizationFailed(username), request);
    }

    private void sendLogin(HttpServerRequest request, HttpServerResponse response) throws HttpAuthenticationException {
        if (request.getRequestPath().isEmpty() && !this.contextPath.isEmpty()) {
            this.sendRedirect(response, this.getCompleteRedirectLocation(request, "/"));
            return;
        }
        URI requestURI = request.getRequestURI();
        HttpScope session = this.getSessionScope(request, true);
        if (session != null && session.supportsAttachments()) {
            StringBuilder sb = new StringBuilder();
            String scheme = requestURI.getScheme();
            sb.append(scheme);
            sb.append("://");
            sb.append(requestURI.getHost());
            int port = requestURI.getPort();
            if (FormAuthenticationMechanism.appendPort(scheme, port)) {
                sb.append(':').append(port);
            }
            sb.append(requestURI.getPath());
            if (requestURI.getRawQuery() != null) {
                sb.append("?");
                sb.append(requestURI.getRawQuery());
            }
            if (requestURI.getRawFragment() != null) {
                sb.append("#");
                sb.append(requestURI.getRawFragment());
            }
            session.setAttachment(LOCATION_KEY, sb.toString());
            request.suspendRequest();
        }
        this.sendPage(this.loginPage, request, response);
    }

    private void sendPage(String page, HttpServerRequest request, HttpServerResponse response) throws HttpAuthenticationException {
        if (response.forward(page)) {
            return;
        }
        HttpScope application = request.getScope(Scope.APPLICATION);
        if (application != null && application.supportsResources()) {
            try (InputStream pageStream = application.getResource(page);){
                OutputStream responseStream;
                if (pageStream != null && (responseStream = response.getOutputStream()) != null) {
                    int length;
                    byte[] content = new byte[1024];
                    while ((length = pageStream.read(content)) > 0) {
                        responseStream.write(content, 0, length);
                    }
                    return;
                }
            }
            catch (IOException e) {
                throw new HttpAuthenticationException(e);
            }
        }
        this.sendRedirect(response, this.getCompleteRedirectLocation(request, page));
    }

    private String getCompleteRedirectLocation(HttpServerRequest request, String location) {
        URI requestURI = request.getRequestURI();
        StringBuilder sb = new StringBuilder();
        String scheme = requestURI.getScheme();
        sb.append(scheme);
        sb.append("://");
        sb.append(requestURI.getHost());
        int port = requestURI.getPort();
        if (FormAuthenticationMechanism.appendPort(scheme, port)) {
            sb.append(':').append(port);
        }
        sb.append(this.contextPath);
        sb.append(location);
        return sb.toString();
    }

    private void sendRedirect(HttpServerResponse response, String location) {
        response.addResponseHeader("Location", location);
        response.setStatusCode(302);
    }

    private HttpScope getSessionScope(HttpServerRequest request, boolean createSession) {
        HttpScope scope = request.getScope(Scope.SESSION);
        if (scope != null && !scope.exists() && createSession) {
            scope.create();
        }
        return scope;
    }

    private static boolean appendPort(String scheme, int port) {
        return port > -1 && ("http".equalsIgnoreCase(scheme) && port != 80 || "https".equalsIgnoreCase(scheme) && port != 443);
    }
}

