/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security._private;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.wildfly.security.Version;
import org.wildfly.security.sasl.util.UsernamePasswordHashUtil;

public final class Main {
    private Main() {
    }

    public static void main(String ... args) {
        List<String> argsList = Arrays.asList(args);
        ListIterator<String> argIterator = argsList.listIterator();
        boolean help = false;
        boolean version = false;
        String operationName = null;
        String[] operationArgs = null;
        while (argIterator.hasNext()) {
            String arg = argIterator.next();
            if (arg.charAt(0) == '-') {
                switch (arg) {
                    case "-help": {
                        help = true;
                        break;
                    }
                    case "-version": {
                        version = true;
                        break;
                    }
                    default: {
                        System.err.printf("Unrecognized argument \"%s\"%n", arg);
                        Main.printHelp();
                        System.exit(1);
                        break;
                    }
                }
                continue;
            }
            operationName = arg;
            int index = argIterator.nextIndex();
            int count = args.length - index;
            operationArgs = new String[count];
            System.arraycopy(args, index, operationArgs, 0, count);
            break;
        }
        if (version) {
            System.out.printf("WildFly Elytron version %s%n", Version.getVersion());
        } else if (operationArgs != null) {
            switch (operationName) {
                case "UsernamePasswordHashUtil": {
                    Main.usernamePasswordHash(operationArgs);
                    break;
                }
                default: {
                    System.err.printf("Unrecognized operation \"%s\"%n", operationName);
                    Main.printHelp();
                    System.exit(1);
                    break;
                }
            }
        } else if (args.length == 0 || help) {
            Main.printHelp();
            System.exit(0);
        }
    }

    private static void printHelp() {
        System.out.printf("Usage: java [-jvmoptions...] -jar %s.jar [-options...] <operation-spec> [args...]%n", Version.getJarName());
        System.out.printf("where <operation-spec> is a valid operation specification string%n", new Object[0]);
        System.out.printf("and options include:%n", new Object[0]);
        System.out.printf("     -help          Display this message and exit%n", new Object[0]);
        System.out.printf("     -version       Print the version%n%n", new Object[0]);
    }

    private static void usernamePasswordHash(String[] args) {
        char[] password;
        String realm;
        String userName;
        if (args.length == 2) {
            userName = args[0];
            realm = "";
            password = args[1].toCharArray();
        } else if (args.length == 3) {
            userName = args[0];
            realm = args[1];
            password = args[2].toCharArray();
        } else {
            System.out.printf("Usage: java [-jvmoptions...] -jar %s.jar [-options...] UsernamePasswordHashUtil UserName [Realm] Password%n", Version.getJarName());
            return;
        }
        try {
            UsernamePasswordHashUtil util = new UsernamePasswordHashUtil();
            System.out.println(userName + "=" + util.generateHashedHexURP(userName, realm, password));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

