/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.security.Provider;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.wildfly.common.Assert;

public final class ProviderUtil {
    public static Provider findProvider(Supplier<Provider[]> providerSupplier, Class<?> serviceType, String algorithm) {
        Assert.checkNotNullParam((String)"serviceType", serviceType);
        return ProviderUtil.findProvider(providerSupplier, serviceType.getSimpleName(), algorithm);
    }

    public static Provider findProvider(Supplier<Provider[]> providerSupplier, String serviceType, String algorithm) {
        Provider.Service service = ProviderUtil.findProviderService(providerSupplier, serviceType, algorithm);
        return service == null ? null : service.getProvider();
    }

    public static Provider.Service findProviderService(Supplier<Provider[]> providerSupplier, Class<?> serviceType, String algorithm) {
        Assert.checkNotNullParam((String)"serviceType", serviceType);
        return ProviderUtil.findProviderService(providerSupplier, serviceType.getSimpleName(), algorithm);
    }

    public static Provider.Service findProviderService(Supplier<Provider[]> providerSupplier, String serviceType, String algorithm) {
        Assert.checkNotNullParam((String)"providerSupplier", providerSupplier);
        Assert.checkNotNullParam((String)"serviceType", (Object)serviceType);
        Assert.checkNotNullParam((String)"algorithm", (Object)algorithm);
        for (Provider provider : providerSupplier.get()) {
            Provider.Service providerService = provider.getService(serviceType, algorithm);
            if (providerService == null) continue;
            return providerService;
        }
        return null;
    }

    public static Provider.Service findProviderService(Supplier<Provider[]> providerSupplier, Predicate<Provider.Service> matchPredicate) {
        Assert.checkNotNullParam((String)"providerSupplier", providerSupplier);
        Assert.checkNotNullParam((String)"matchPredicate", matchPredicate);
        for (Provider provider : providerSupplier.get()) {
            for (Provider.Service service : provider.getServices()) {
                if (!matchPredicate.test(service)) continue;
                return service;
            }
        }
        return null;
    }
}

