/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.ParametricPrivilegedExceptionAction;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.client.PeerIdentityContext;
import org.wildfly.security.authz.Attributes;

public abstract class PeerIdentity {
    private final PeerIdentityContext context;
    private final Principal peerPrincipal;

    protected PeerIdentity(Configuration configuration, Principal peerPrincipal) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        Assert.checkNotNullParam((String)"peerPrincipal", (Object)peerPrincipal);
        this.context = configuration.getContext();
        this.peerPrincipal = peerPrincipal;
    }

    protected void preAssociate() {
    }

    protected void postAssociate() {
    }

    private void safePostAssociate() {
        try {
            this.postAssociate();
        }
        catch (Throwable t) {
            ElytronMessages.log.postAssociationFailed(t);
        }
    }

    public boolean isSamePeerIdentityContext(PeerIdentity other) {
        return other != null && this.context == other.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAs(Runnable runnable) {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            this.preAssociate();
            try {
                runnable.run();
            }
            finally {
                this.safePostAssociate();
            }
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(Callable<T> callable) throws Exception {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            T t;
            this.preAssociate();
            try {
                t = callable.call();
                this.safePostAssociate();
            }
            catch (Throwable throwable) {
                this.safePostAssociate();
                throw throwable;
            }
            return t;
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(PrivilegedAction<T> action) {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            T t;
            this.preAssociate();
            try {
                t = action.run();
                this.safePostAssociate();
            }
            catch (Throwable throwable) {
                this.safePostAssociate();
                throw throwable;
            }
            return t;
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            T t;
            this.preAssociate();
            try {
                t = action.run();
                this.safePostAssociate();
            }
            catch (Throwable throwable) {
                try {
                    this.safePostAssociate();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new PrivilegedActionException(e);
                }
            }
            return t;
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, P> T runAs(P parameter, ParametricPrivilegedAction<T, P> action) {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            T t;
            this.preAssociate();
            try {
                t = action.run(parameter);
                this.safePostAssociate();
            }
            catch (Throwable throwable) {
                this.safePostAssociate();
                throw throwable;
            }
            return t;
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, P> T runAs(P parameter, ParametricPrivilegedExceptionAction<T, P> action) throws PrivilegedActionException {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            T t;
            this.preAssociate();
            try {
                t = action.run(parameter);
                this.safePostAssociate();
            }
            catch (Throwable throwable) {
                try {
                    this.safePostAssociate();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new PrivilegedActionException(e);
                }
            }
            return t;
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> R runAsFunction(T parameter, Function<T, R> action) {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            R r;
            this.preAssociate();
            try {
                r = action.apply(parameter);
                this.safePostAssociate();
            }
            catch (Throwable throwable) {
                this.safePostAssociate();
                throw throwable;
            }
            return r;
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U, R> R runAsFunction(T parameter1, U parameter2, BiFunction<T, U, R> action) {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            R r;
            this.preAssociate();
            try {
                r = action.apply(parameter1, parameter2);
                this.safePostAssociate();
            }
            catch (Throwable throwable) {
                this.safePostAssociate();
                throw throwable;
            }
            return r;
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void runAsConsumer(T parameter, Consumer<T> action) {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            this.preAssociate();
            try {
                action.accept(parameter);
            }
            finally {
                this.safePostAssociate();
            }
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U> void runAsConsumer(T parameter1, U parameter2, BiConsumer<T, U> action) {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            this.preAssociate();
            try {
                action.accept(parameter1, parameter2);
            }
            finally {
                this.safePostAssociate();
            }
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAsSupplier(Supplier<T> supplier) throws Exception {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            T t;
            this.preAssociate();
            try {
                t = supplier.get();
                this.safePostAssociate();
            }
            catch (Throwable throwable) {
                this.safePostAssociate();
                throw throwable;
            }
            return t;
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAsAll(Runnable runnable, PeerIdentity ... identities) {
        int i;
        int length = identities.length;
        for (i = 0; i < length; ++i) {
            PeerIdentity identity = identities[i];
            boolean ok = false;
            try {
                identity.preAssociate();
                ok = true;
                continue;
            }
            finally {
                if (!ok) {
                    --i;
                    while (i >= 0) {
                        identities[i].safePostAssociate();
                        --i;
                    }
                }
            }
        }
        try {
            runnable.run();
        }
        finally {
            for (i = length - 1; i >= 0; --i) {
                identities[i].safePostAssociate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runAsAll(Callable<T> callable, PeerIdentity ... identities) throws Exception {
        int length = identities.length;
        for (int i = 0; i < length; ++i) {
            PeerIdentity identity = identities[i];
            boolean ok = false;
            try {
                identity.preAssociate();
                ok = true;
                continue;
            }
            finally {
                if (!ok) {
                    --i;
                    while (i >= 0) {
                        identities[i].safePostAssociate();
                        --i;
                    }
                }
            }
        }
        try {
            T t = callable.call();
            return t;
        }
        finally {
            for (int i = length - 1; i >= 0; --i) {
                identities[i].safePostAssociate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runAsAll(PrivilegedAction<T> privilegedAction, PeerIdentity ... identities) {
        int length = identities.length;
        for (int i = 0; i < length; ++i) {
            PeerIdentity identity = identities[i];
            boolean ok = false;
            try {
                identity.preAssociate();
                ok = true;
                continue;
            }
            finally {
                if (!ok) {
                    --i;
                    while (i >= 0) {
                        identities[i].safePostAssociate();
                        --i;
                    }
                }
            }
        }
        try {
            T t = privilegedAction.run();
            return t;
        }
        finally {
            for (int i = length - 1; i >= 0; --i) {
                identities[i].safePostAssociate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runAsAll(PrivilegedExceptionAction<T> privilegedAction, PeerIdentity ... identities) throws PrivilegedActionException {
        int length = identities.length;
        for (int i = 0; i < length; ++i) {
            PeerIdentity identity = identities[i];
            boolean ok = false;
            try {
                identity.preAssociate();
                ok = true;
                continue;
            }
            finally {
                if (!ok) {
                    --i;
                    while (i >= 0) {
                        identities[i].safePostAssociate();
                        --i;
                    }
                }
            }
        }
        try {
            T i = privilegedAction.run();
            return i;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            for (int i = length - 1; i >= 0; --i) {
                identities[i].safePostAssociate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, P> T runAsAll(P parameter, ParametricPrivilegedAction<T, P> privilegedAction, PeerIdentity ... identities) {
        int length = identities.length;
        for (int i = 0; i < length; ++i) {
            PeerIdentity identity = identities[i];
            boolean ok = false;
            try {
                identity.preAssociate();
                ok = true;
                continue;
            }
            finally {
                if (!ok) {
                    --i;
                    while (i >= 0) {
                        identities[i].safePostAssociate();
                        --i;
                    }
                }
            }
        }
        try {
            T t = privilegedAction.run(parameter);
            return t;
        }
        finally {
            for (int i = length - 1; i >= 0; --i) {
                identities[i].safePostAssociate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, P> T runAsAll(P parameter, ParametricPrivilegedExceptionAction<T, P> privilegedAction, PeerIdentity ... identities) throws PrivilegedActionException {
        int length = identities.length;
        for (int i = 0; i < length; ++i) {
            PeerIdentity identity = identities[i];
            boolean ok = false;
            try {
                identity.preAssociate();
                ok = true;
                continue;
            }
            finally {
                if (!ok) {
                    --i;
                    while (i >= 0) {
                        identities[i].safePostAssociate();
                        --i;
                    }
                }
            }
        }
        try {
            T i = privilegedAction.run(parameter);
            return i;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            for (int i = length - 1; i >= 0; --i) {
                identities[i].safePostAssociate();
            }
        }
    }

    public static <R, T> R runAsAllFunction(T parameter, Function<T, R> privilegedAction, PeerIdentity ... identities) {
        return (R)PeerIdentity.runAsAllFunction(privilegedAction, parameter, Function::apply, identities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, U, R> R runAsAllFunction(T parameter1, U parameter2, BiFunction<T, U, R> privilegedAction, PeerIdentity ... identities) {
        int length = identities.length;
        for (int i = 0; i < length; ++i) {
            PeerIdentity identity = identities[i];
            boolean ok = false;
            try {
                identity.preAssociate();
                ok = true;
                continue;
            }
            finally {
                if (!ok) {
                    --i;
                    while (i >= 0) {
                        identities[i].safePostAssociate();
                        --i;
                    }
                }
            }
        }
        try {
            R r = privilegedAction.apply(parameter1, parameter2);
            return r;
        }
        finally {
            for (int i = length - 1; i >= 0; --i) {
                identities[i].safePostAssociate();
            }
        }
    }

    public static <T> void runAsAllConsumer(T parameter, Consumer<T> privilegedAction, PeerIdentity ... identities) {
        PeerIdentity.runAsAllConsumer(privilegedAction, parameter, Consumer::accept, identities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, U> void runAsAllConsumer(T parameter1, U parameter2, BiConsumer<T, U> privilegedAction, PeerIdentity ... identities) {
        int i;
        int length = identities.length;
        for (i = 0; i < length; ++i) {
            PeerIdentity identity = identities[i];
            boolean ok = false;
            try {
                identity.preAssociate();
                ok = true;
                continue;
            }
            finally {
                if (!ok) {
                    --i;
                    while (i >= 0) {
                        identities[i].safePostAssociate();
                        --i;
                    }
                }
            }
        }
        try {
            privilegedAction.accept(parameter1, parameter2);
        }
        finally {
            for (i = length - 1; i >= 0; --i) {
                identities[i].safePostAssociate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void runAsAllObjIntConsumer(T parameter1, int parameter2, ObjIntConsumer<T> privilegedAction, PeerIdentity ... identities) {
        int i;
        int length = identities.length;
        for (i = 0; i < length; ++i) {
            PeerIdentity identity = identities[i];
            boolean ok = false;
            try {
                identity.preAssociate();
                ok = true;
                continue;
            }
            finally {
                if (!ok) {
                    --i;
                    while (i >= 0) {
                        identities[i].safePostAssociate();
                        --i;
                    }
                }
            }
        }
        try {
            privilegedAction.accept(parameter1, parameter2);
        }
        finally {
            for (i = length - 1; i >= 0; --i) {
                identities[i].safePostAssociate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runAsAllSupplier(Supplier<T> action, PeerIdentity ... identities) {
        int length = identities.length;
        for (int i = 0; i < length; ++i) {
            PeerIdentity identity = identities[i];
            boolean ok = false;
            try {
                identity.preAssociate();
                ok = true;
                continue;
            }
            finally {
                if (!ok) {
                    --i;
                    while (i >= 0) {
                        identities[i].safePostAssociate();
                        --i;
                    }
                }
            }
        }
        try {
            T t = action.get();
            return t;
        }
        finally {
            for (int i = length - 1; i >= 0; --i) {
                identities[i].safePostAssociate();
            }
        }
    }

    public Principal getPeerPrincipal() {
        return this.peerPrincipal;
    }

    public Set<String> getPeerRoles() {
        return Collections.emptySet();
    }

    public boolean hasPeerRole(String roleName) {
        return false;
    }

    public Attributes getPeerAttributes() {
        return Attributes.EMPTY;
    }

    public Attributes.Entry getPeerAttribute(String key) {
        return null;
    }

    protected final PeerIdentityContext getPeerIdentityContext() {
        return this.context;
    }

    public static final class Configuration {
        private final PeerIdentityContext context;
        private final Thread thread = Thread.currentThread();
        private boolean terminated;

        Configuration(PeerIdentityContext context) {
            this.context = context;
        }

        PeerIdentityContext getContext() {
            if (this.thread != Thread.currentThread() || this.terminated) {
                throw new SecurityException();
            }
            return this.context;
        }

        void terminate() {
            this.terminated = true;
        }
    }
}

