/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.auth.callback.MechanismInformationCallback;
import org.wildfly.security.auth.server.MechanismInformation;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public final class SetMechanismInformationSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    public SetMechanismInformationSaslServerFactory(SaslServerFactory delegate) {
        super(delegate);
    }

    @Override
    public SaslServer createSaslServer(final String mechanism, final String protocol, final String serverName, Map<String, ?> props, final CallbackHandler cbh) throws SaslException {
        CallbackHandler wrapper = new CallbackHandler(){
            private volatile boolean informationSent = false;

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                if (!this.informationSent) {
                    this.informationSent = true;
                    cbh.handle(new Callback[]{new MechanismInformationCallback(new MechanismInformation(){

                        @Override
                        public String getProtocol() {
                            return protocol;
                        }

                        @Override
                        public String getMechanismType() {
                            return "SASL";
                        }

                        @Override
                        public String getMechanismName() {
                            return mechanism;
                        }

                        @Override
                        public String getHostName() {
                            return serverName;
                        }
                    })});
                }
                cbh.handle(callbacks);
            }
        };
        return super.createSaslServer(mechanism, protocol, serverName, props, wrapper);
    }
}

