/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.SSLSessionAuthorizationCallback;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism.MechanismUtil;

public class ClientCertAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    private final CallbackHandler callbackHandler;

    ClientCertAuthenticationMechanism(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public String getMechanismName() {
        return "CLIENT_CERT";
    }

    @Override
    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        SSLSession sslSession = request.getSSLSession();
        if (sslSession == null) {
            request.noAuthenticationInProgress();
            return;
        }
        SSLSessionAuthorizationCallback callback = new SSLSessionAuthorizationCallback(sslSession);
        try {
            MechanismUtil.handleCallbacks("CLIENT_CERT", this.callbackHandler, callback);
        }
        catch (AuthenticationMechanismException e) {
            throw e.toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason("CLIENT_CERT", e).toHttpAuthenticationException();
        }
        if (callback.isAuthorized()) {
            try {
                MechanismUtil.handleCallbacks("CLIENT_CERT", this.callbackHandler, AuthenticationCompleteCallback.SUCCEEDED);
                request.authenticationComplete();
            }
            catch (AuthenticationMechanismException e) {
                throw e.toHttpAuthenticationException();
            }
            catch (UnsupportedCallbackException e) {}
        } else {
            try {
                MechanismUtil.handleCallbacks("CLIENT_CERT", this.callbackHandler, AuthenticationCompleteCallback.FAILED);
                request.authenticationFailed(ElytronMessages.log.authenticationFailed("CLIENT_CERT"));
            }
            catch (AuthenticationMechanismException e) {
                throw e.toHttpAuthenticationException();
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                // empty catch block
            }
        }
    }
}

