/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store.impl;

import java.util.Collections;
import java.util.Map;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.CredentialStoreSpi;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.password.interfaces.ClearPassword;

public abstract class CommandCredentialStore
extends CredentialStoreSpi {
    protected Map<String, String> attributes = Collections.emptyMap();
    protected String storeName = "abstract-command";

    @Override
    public void initialize(Map<String, String> attributes) throws CredentialStoreException {
        this.attributes = attributes;
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    public <C extends Credential> boolean exists(String credentialAlias, Class<C> credentialType) throws CredentialStoreException, UnsupportedCredentialTypeException {
        throw ElytronMessages.log.methodNotImplemented("exists", this.getName());
    }

    @Override
    public <C extends Credential> void store(String credentialAlias, C credential) throws CredentialStoreException, UnsupportedCredentialTypeException {
        throw ElytronMessages.log.methodNotImplemented("store", this.getName());
    }

    @Override
    public <C extends Credential> C retrieve(String credentialAlias, Class<C> credentialType) throws CredentialStoreException, UnsupportedCredentialTypeException {
        Assert.checkNotNullParam((String)"credentialAlias", (Object)credentialAlias);
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        if (credentialType.isAssignableFrom(PasswordCredential.class)) {
            try {
                return (C)((Credential)credentialType.cast(new PasswordCredential(ClearPassword.createRaw("clear", this.executePasswordCommand(credentialAlias)))));
            }
            catch (Throwable e) {
                throw ElytronMessages.log.passwordCommandExecutionProblem(this.getName(), e);
            }
        }
        throw ElytronMessages.log.credentialTypeNotSupported(credentialType.getName(), this.getName());
    }

    @Override
    public <C extends Credential> void remove(String credentialAlias, Class<C> credentialType) throws CredentialStoreException, UnsupportedCredentialTypeException {
        throw ElytronMessages.log.methodNotImplemented("remove", this.getName());
    }

    protected String getName() {
        return this.storeName;
    }

    abstract char[] executePasswordCommand(String var1) throws Throwable;
}

