/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.common.Assert;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.credential.Credential;

public final class MechanismConfiguration {
    private final NameRewriter preRealmRewriter;
    private final NameRewriter postRealmRewriter;
    private final NameRewriter finalRewriter;
    private final RealmMapper realmMapper;
    private final Map<String, MechanismRealmConfiguration> mechanismRealms;
    private final SecurityFactory<Credential> serverCredentialFactory;
    public static final MechanismConfiguration EMPTY = new MechanismConfiguration(null, null, null, null, Collections.emptyList(), null);

    MechanismConfiguration(NameRewriter preRealmRewriter, NameRewriter postRealmRewriter, NameRewriter finalRewriter, RealmMapper realmMapper, Collection<MechanismRealmConfiguration> mechanismRealms, SecurityFactory<Credential> serverCredentialFactory) {
        Assert.checkNotNullParam((String)"mechanismRealms", mechanismRealms);
        this.preRealmRewriter = preRealmRewriter;
        this.postRealmRewriter = postRealmRewriter;
        this.finalRewriter = finalRewriter;
        this.realmMapper = realmMapper;
        Iterator<MechanismRealmConfiguration> iterator = mechanismRealms.iterator();
        if (!iterator.hasNext()) {
            this.mechanismRealms = Collections.emptyMap();
        } else {
            MechanismRealmConfiguration item = iterator.next();
            if (!iterator.hasNext()) {
                this.mechanismRealms = Collections.singletonMap(item.getRealmName(), item);
            } else {
                LinkedHashMap<String, MechanismRealmConfiguration> map = new LinkedHashMap<String, MechanismRealmConfiguration>(mechanismRealms.size());
                map.put(item.getRealmName(), item);
                do {
                    item = iterator.next();
                    map.put(item.getRealmName(), item);
                } while (iterator.hasNext());
                this.mechanismRealms = Collections.unmodifiableMap(map);
            }
        }
        this.serverCredentialFactory = serverCredentialFactory;
    }

    public NameRewriter getPreRealmRewriter() {
        return this.preRealmRewriter;
    }

    public NameRewriter getPostRealmRewriter() {
        return this.postRealmRewriter;
    }

    public NameRewriter getFinalRewriter() {
        return this.finalRewriter;
    }

    public RealmMapper getRealmMapper() {
        return this.realmMapper;
    }

    public Collection<String> getMechanismRealmNames() {
        return this.mechanismRealms.keySet();
    }

    public SecurityFactory<Credential> getServerCredentialFactory() {
        return this.serverCredentialFactory;
    }

    public MechanismRealmConfiguration getMechanismRealmConfiguration(String realmName) {
        return this.mechanismRealms.get(realmName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final MechanismRealmConfiguration[] NO_REALM_CONFIGS = new MechanismRealmConfiguration[0];
        private NameRewriter preRealmRewriter;
        private NameRewriter postRealmRewriter;
        private NameRewriter finalRewriter;
        private RealmMapper realmMapper;
        private List<MechanismRealmConfiguration> mechanismRealms;
        private SecurityFactory<Credential> serverCredentialFactory;

        Builder() {
        }

        public Builder setPreRealmRewriter(NameRewriter preRealmRewriter) {
            this.preRealmRewriter = preRealmRewriter;
            return this;
        }

        public Builder setPostRealmRewriter(NameRewriter postRealmRewriter) {
            this.postRealmRewriter = postRealmRewriter;
            return this;
        }

        public Builder setFinalRewriter(NameRewriter finalRewriter) {
            this.finalRewriter = finalRewriter;
            return this;
        }

        public Builder setRealmMapper(RealmMapper realmMapper) {
            this.realmMapper = realmMapper;
            return this;
        }

        public Builder addMechanismRealm(MechanismRealmConfiguration configuration) {
            Assert.checkNotNullParam((String)"configuration", (Object)configuration);
            List<MechanismRealmConfiguration> mechanismRealms = this.mechanismRealms;
            if (mechanismRealms == null) {
                mechanismRealms = this.mechanismRealms = new ArrayList<MechanismRealmConfiguration>(1);
            }
            mechanismRealms.add(configuration);
            return this;
        }

        public Builder setServerCredential(Credential credential) {
            Assert.checkNotNullParam((String)"credential", (Object)credential);
            this.serverCredentialFactory = new FixedSecurityFactory<Credential>(credential);
            return this;
        }

        public Builder setServerCredential(SecurityFactory<Credential> credentialFactory) {
            Assert.checkNotNullParam((String)"credential", credentialFactory);
            this.serverCredentialFactory = credentialFactory;
            return this;
        }

        public MechanismConfiguration build() {
            List<MechanismRealmConfiguration> mechanismRealms = this.mechanismRealms;
            mechanismRealms = mechanismRealms == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(mechanismRealms.toArray(NO_REALM_CONFIGS)));
            return new MechanismConfiguration(this.preRealmRewriter, this.postRealmRewriter, this.finalRewriter, this.realmMapper, mechanismRealms, this.serverCredentialFactory);
        }
    }
}

