/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.asn1;

import java.io.Flushable;
import java.math.BigInteger;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.util.ByteStringBuilder;

public interface ASN1Encoder
extends Flushable {
    public void startSequence();

    public void endSequence() throws IllegalStateException;

    public void startSet();

    public void endSet() throws IllegalStateException;

    public void startSetOf();

    public void endSetOf() throws IllegalStateException;

    public void startExplicit(int var1);

    public void startExplicit(int var1, int var2);

    public void endExplicit() throws IllegalStateException;

    public void encodeOctetString(String var1);

    public void encodeOctetString(byte[] var1);

    public void encodeOctetString(ByteStringBuilder var1);

    public void encodeIA5String(String var1);

    public void encodeIA5String(byte[] var1);

    public void encodeIA5String(ByteStringBuilder var1);

    public void encodePrintableString(byte[] var1);

    public void encodePrintableString(String var1);

    public void encodeBitString(byte[] var1);

    public void encodeBitString(byte[] var1, int var2);

    public void encodeBitString(String var1);

    public void encodeBitString(BigInteger var1);

    public void encodeObjectIdentifier(String var1) throws ASN1Exception;

    public void encodeNull();

    public void encodeImplicit(int var1);

    public void encodeImplicit(int var1, int var2);

    default public void encodeInteger(int integer) {
        this.encodeInteger(BigInteger.valueOf(integer));
    }

    public void encodeInteger(BigInteger var1);

    public void writeEncoded(byte[] var1);

    @Override
    public void flush();
}

