/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.wildfly.security.util._private.Arrays2;

public class ServiceLoaderSupplier<E>
implements Supplier<E[]> {
    private final Class<E> service;
    private final ClassLoader classLoader;
    private int hashCode;
    private volatile E[] result;

    public ServiceLoaderSupplier(Class<E> service, ClassLoader classLoader) {
        this.service = service;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E[] get() {
        if (this.result == null) {
            ServiceLoaderSupplier serviceLoaderSupplier = this;
            synchronized (serviceLoaderSupplier) {
                if (this.result == null) {
                    ArrayList<E> list = new ArrayList<E>();
                    ServiceLoader<E> loader = ServiceLoader.load(this.service, this.classLoader);
                    Iterator<E> iterator = loader.iterator();
                    while (true) {
                        try {
                            while (true) {
                                if (!iterator.hasNext()) {
                                    this.result = list.toArray(Arrays2.createArray(this.service, list.size()));
                                    return (Object[])this.result.clone();
                                }
                                list.add(iterator.next());
                            }
                        }
                        catch (ServiceConfigurationError serviceConfigurationError) {
                            continue;
                        }
                        break;
                    }
                }
            }
        }
        return (Object[])this.result.clone();
    }

    public int hashCode() {
        int hc = this.hashCode;
        if (hc == 0) {
            hc = this.service.hashCode() * 19 + this.classLoader.hashCode();
            if (hc == 0) {
                hc = 1;
            }
            this.hashCode = hc;
            return this.hashCode;
        }
        return hc;
    }

    public boolean equals(Object obj) {
        return obj instanceof ServiceLoaderSupplier && this.equals((ServiceLoaderSupplier)obj);
    }

    private boolean equals(ServiceLoaderSupplier<?> other) {
        return other == this || other.service == this.service && other.classLoader == this.classLoader;
    }
}

