/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store;

import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import java.util.Set;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;

public abstract class CredentialStoreSpi {
    protected boolean initialized = false;

    protected CredentialStoreSpi() {
    }

    public abstract void initialize(Map<String, String> var1, CredentialStore.ProtectionParameter var2, Provider[] var3) throws CredentialStoreException;

    public boolean isInitialized() {
        return this.initialized;
    }

    public abstract boolean isModifiable();

    public boolean exists(String credentialAlias, Class<? extends Credential> credentialType) throws CredentialStoreException {
        return this.retrieve(credentialAlias, credentialType, null, null, null) != null;
    }

    public abstract void store(String var1, Credential var2, CredentialStore.ProtectionParameter var3) throws CredentialStoreException, UnsupportedCredentialTypeException;

    public abstract <C extends Credential> C retrieve(String var1, Class<C> var2, String var3, AlgorithmParameterSpec var4, CredentialStore.ProtectionParameter var5) throws CredentialStoreException;

    public abstract void remove(String var1, Class<? extends Credential> var2, String var3, AlgorithmParameterSpec var4) throws CredentialStoreException;

    public void flush() throws CredentialStoreException {
    }

    public Set<String> getAliases() throws UnsupportedOperationException, CredentialStoreException {
        throw new UnsupportedOperationException();
    }
}

