/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.util.NoSuchElementException;
import org.wildfly.common.Assert;
import org.wildfly.security.util.Alphabet;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.ByteStringBuilder;
import org.wildfly.security.util.NumericIterator;

public abstract class CodePointIterator
extends NumericIterator {
    public static final CodePointIterator EMPTY = new CodePointIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrev() {
            return false;
        }

        @Override
        public int next() {
            throw new NoSuchElementException();
        }

        @Override
        public int peekNext() throws NoSuchElementException {
            throw new NoSuchElementException();
        }

        @Override
        public int prev() {
            throw new NoSuchElementException();
        }

        @Override
        public int peekPrev() throws NoSuchElementException {
            throw new NoSuchElementException();
        }

        @Override
        public int offset() {
            return 0;
        }

        @Override
        public ByteIterator base64Decode(Alphabet.Base64Alphabet alphabet, boolean requirePadding) {
            return ByteIterator.EMPTY;
        }

        @Override
        public String drainToString() {
            return "";
        }
    };

    @Override
    public abstract boolean hasNext();

    @Override
    public abstract boolean hasPrev();

    @Override
    public abstract int next() throws NoSuchElementException;

    @Override
    public abstract int peekNext() throws NoSuchElementException;

    @Override
    public abstract int prev() throws NoSuchElementException;

    @Override
    public abstract int peekPrev() throws NoSuchElementException;

    public abstract int offset();

    public final boolean contentEquals(CodePointIterator other) {
        while (this.hasNext()) {
            if (!other.hasNext()) {
                return false;
            }
            if (this.peekNext() != other.peekNext()) {
                return false;
            }
            this.next();
            other.next();
        }
        return !other.hasNext();
    }

    public boolean contentEquals(String other) {
        return this.contentEquals(CodePointIterator.ofString(other));
    }

    public final CodePointIterator limitedTo(final int size) {
        if (size <= 0 || !this.hasNext()) {
            return EMPTY;
        }
        return new CodePointIterator(){
            int offset = 0;

            @Override
            public boolean hasNext() {
                return this.offset < size && CodePointIterator.this.hasNext();
            }

            @Override
            public boolean hasPrev() {
                return this.offset > 0;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.offset;
                return CodePointIterator.this.next();
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return CodePointIterator.this.peekNext();
            }

            @Override
            public int prev() {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                --this.offset;
                return CodePointIterator.this.prev();
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                return CodePointIterator.this.peekPrev();
            }

            @Override
            public int offset() {
                return this.offset;
            }
        };
    }

    public final CodePointIterator delimitedBy(final int ... delims) {
        if (delims == null || delims.length == 0 || !this.hasNext()) {
            return EMPTY;
        }
        for (int delim : delims) {
            if (Character.isValidCodePoint(delim)) continue;
            return EMPTY;
        }
        return new CodePointIterator(){
            int offset = 0;

            @Override
            public boolean hasNext() {
                return CodePointIterator.this.hasNext() && !this.isDelim(CodePointIterator.this.peekNext());
            }

            @Override
            public boolean hasPrev() {
                return this.offset > 0;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.offset;
                return CodePointIterator.this.next();
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return CodePointIterator.this.peekNext();
            }

            @Override
            public int prev() {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                --this.offset;
                return CodePointIterator.this.prev();
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                return CodePointIterator.this.peekPrev();
            }

            @Override
            public int offset() {
                return this.offset;
            }

            private boolean isDelim(int c) {
                for (int delim : delims) {
                    if (delim != c) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public StringBuilder drainTo(StringBuilder b) {
        while (this.hasNext()) {
            b.appendCodePoint(this.next());
        }
        return b;
    }

    public StringBuilder drainTo(StringBuilder b, String prefix, int delim, int n) {
        int i = 0;
        boolean insertPrefix = prefix != null;
        boolean insertDelim = Character.isValidCodePoint(delim);
        if (this.hasNext()) {
            if (insertPrefix) {
                b.append(prefix);
            }
            b.appendCodePoint(this.next());
            ++i;
            while (this.hasNext()) {
                if (i == n) {
                    if (insertDelim) {
                        b.appendCodePoint(delim);
                    }
                    if (insertPrefix) {
                        b.append(prefix);
                    }
                    b.appendCodePoint(this.next());
                    i = 1;
                    continue;
                }
                b.appendCodePoint(this.next());
                ++i;
            }
        }
        return b;
    }

    public StringBuilder drainTo(StringBuilder b, int delim, int n) {
        return this.drainTo(b, null, delim, n);
    }

    public StringBuilder drainTo(StringBuilder b, String prefix, int n) {
        return this.drainTo(b, prefix, -1, n);
    }

    public String drainToString() {
        return this.hasNext() ? this.drainTo(new StringBuilder()).toString() : "";
    }

    public String drainToString(String prefix, int delim, int n) {
        return this.hasNext() ? this.drainTo(new StringBuilder(), prefix, delim, n).toString() : "";
    }

    public String drainToString(int delim, int n) {
        return this.hasNext() ? this.drainTo(new StringBuilder(), null, delim, n).toString() : "";
    }

    public String drainToString(String prefix, int n) {
        return this.hasNext() ? this.drainTo(new StringBuilder(), prefix, -1, n).toString() : "";
    }

    @Override
    public ByteIterator base64Decode(Alphabet.Base64Alphabet alphabet, boolean requirePadding) {
        return super.base64Decode(alphabet, requirePadding);
    }

    public ByteIterator base64Decode(Alphabet.Base64Alphabet alphabet) {
        return super.base64Decode(alphabet, true);
    }

    public ByteIterator base64Decode() {
        return super.base64Decode(Alphabet.Base64Alphabet.STANDARD, true);
    }

    @Override
    public ByteIterator base32Decode(Alphabet.Base32Alphabet alphabet, boolean requirePadding) {
        return super.base32Decode(alphabet, requirePadding);
    }

    public ByteIterator base32Decode(Alphabet.Base32Alphabet alphabet) {
        return super.base32Decode(alphabet, true);
    }

    public ByteIterator base32Decode() {
        return super.base32Decode(Alphabet.Base32Alphabet.STANDARD, true);
    }

    @Override
    public ByteIterator hexDecode() {
        return super.hexDecode();
    }

    public ByteIterator asLatin1() {
        return new ByteIterator(){

            @Override
            public boolean hasNext() {
                return CodePointIterator.this.hasNext();
            }

            @Override
            public boolean hasPrev() {
                return CodePointIterator.this.hasPrev();
            }

            @Override
            public int next() throws NoSuchElementException {
                int v = CodePointIterator.this.next();
                return v > 255 ? 63 : v;
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                int v = CodePointIterator.this.peekNext();
                return v > 255 ? 63 : v;
            }

            @Override
            public int prev() throws NoSuchElementException {
                int v = CodePointIterator.this.prev();
                return v > 255 ? 63 : v;
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                int v = CodePointIterator.this.peekPrev();
                return v > 255 ? 63 : v;
            }

            @Override
            public int offset() {
                return CodePointIterator.this.offset();
            }
        };
    }

    public ByteIterator asUtf8() {
        return this.asUtf8(false);
    }

    public ByteIterator asUtf8(final boolean escapeNul) {
        return new ByteIterator(){
            private int st;
            private int cp = -1;
            private int offset;

            @Override
            public boolean hasNext() {
                return this.st != 0 || CodePointIterator.this.hasNext();
            }

            @Override
            public boolean hasPrev() {
                return this.st != 0 || CodePointIterator.this.hasPrev();
            }

            @Override
            public int next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.offset;
                switch (this.st) {
                    case 0: {
                        int cp = CodePointIterator.this.next();
                        if (cp == 0 && !escapeNul || cp < 128) {
                            return cp;
                        }
                        if (cp < 2048) {
                            this.cp = cp;
                            this.st = 1;
                            return 0xC0 | cp >> 6;
                        }
                        if (cp < 65536) {
                            this.cp = cp;
                            this.st = 2;
                            return 0xE0 | cp >> 12;
                        }
                        if (cp < 0x110000) {
                            this.cp = cp;
                            this.st = 4;
                            return 0xF0 | cp >> 18;
                        }
                        this.cp = 65533;
                        this.st = 2;
                        return 239;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        this.st = 0;
                        return 0x80 | this.cp & 0x3F;
                    }
                    case 2: {
                        this.st = 3;
                        return 0x80 | this.cp >> 6 & 0x3F;
                    }
                    case 4: {
                        this.st = 5;
                        return 0x80 | this.cp >> 12 & 0x3F;
                    }
                    case 5: {
                        this.st = 6;
                        return 0x80 | this.cp >> 6 & 0x3F;
                    }
                }
                throw Assert.impossibleSwitchCase((int)this.st);
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                switch (this.st) {
                    case 0: {
                        int cp = CodePointIterator.this.peekNext();
                        if (cp < 128) {
                            return cp;
                        }
                        if (cp < 2048) {
                            return 0xC0 | cp >> 6;
                        }
                        if (cp < 65536) {
                            return 0xE0 | cp >> 12;
                        }
                        if (cp < 0x110000) {
                            return 0xF0 | cp >> 18;
                        }
                        return 239;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        return 0x80 | this.cp & 0x3F;
                    }
                    case 2: 
                    case 5: {
                        return 0x80 | this.cp >> 6 & 0x3F;
                    }
                    case 4: {
                        return 0x80 | this.cp >> 12 & 0x3F;
                    }
                }
                throw Assert.impossibleSwitchCase((int)this.st);
            }

            @Override
            public int prev() throws NoSuchElementException {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                --this.offset;
                switch (this.st) {
                    case 0: {
                        int cp = CodePointIterator.this.prev();
                        if (cp == 0 && !escapeNul || cp < 128) {
                            return cp;
                        }
                        if (cp < 2048) {
                            this.cp = cp;
                            this.st = 1;
                            return 0x80 | cp & 0x3F;
                        }
                        if (cp < 65536) {
                            this.cp = cp;
                            this.st = 3;
                            return 0x80 | cp & 0x3F;
                        }
                        if (cp < 0x110000) {
                            this.cp = cp;
                            this.st = 6;
                            return 0x80 | cp & 0x3F;
                        }
                        this.cp = 65533;
                        this.st = 3;
                        return 189;
                    }
                    case 1: {
                        this.st = 0;
                        return 0xC0 | this.cp >> 6;
                    }
                    case 2: {
                        this.st = 0;
                        return 0xE0 | this.cp >> 12;
                    }
                    case 3: {
                        this.st = 2;
                        return 0x80 | this.cp >> 6 & 0x3F;
                    }
                    case 4: {
                        this.st = 0;
                        return 0xF0 | this.cp >> 18;
                    }
                    case 5: {
                        this.st = 4;
                        return 0x80 | this.cp >> 12 & 0x3F;
                    }
                    case 6: {
                        this.st = 5;
                        return 0x80 | this.cp >> 6 & 0x3F;
                    }
                }
                throw Assert.impossibleSwitchCase((int)this.st);
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                switch (this.st) {
                    case 0: {
                        int cp = CodePointIterator.this.peekPrev();
                        if (cp == 0 && !escapeNul || cp < 128) {
                            return cp;
                        }
                        if (cp < 2048) {
                            return 0x80 | cp & 0x3F;
                        }
                        if (cp < 65536) {
                            return 0x80 | cp & 0x3F;
                        }
                        if (cp < 0x110000) {
                            return 0x80 | cp & 0x3F;
                        }
                        return 189;
                    }
                    case 1: {
                        return 0xC0 | this.cp >> 6;
                    }
                    case 2: {
                        return 0xE0 | this.cp >> 12;
                    }
                    case 3: 
                    case 6: {
                        return 0x80 | this.cp >> 6 & 0x3F;
                    }
                    case 4: {
                        return 0xF0 | this.cp >> 18;
                    }
                    case 5: {
                        return 0x80 | this.cp >> 12 & 0x3F;
                    }
                }
                throw Assert.impossibleSwitchCase((int)this.st);
            }

            @Override
            public ByteStringBuilder appendTo(ByteStringBuilder builder) {
                if (this.st == 0) {
                    int oldLen = builder.length();
                    builder.appendUtf8(CodePointIterator.this);
                    this.offset += builder.length() - oldLen;
                } else {
                    super.appendTo(builder);
                }
                return builder;
            }

            @Override
            public int offset() {
                return this.offset;
            }
        };
    }

    public static CodePointIterator ofString(String string) {
        return CodePointIterator.ofString(string, 0, string.length());
    }

    public static CodePointIterator ofString(final String string, final int offs, final int len) {
        if (len == 0) {
            return EMPTY;
        }
        return new CodePointIterator(){
            private int idx = 0;
            private int offset = 0;

            @Override
            public boolean hasNext() {
                return this.idx < len;
            }

            @Override
            public boolean hasPrev() {
                return this.offset > 0;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    ++this.offset;
                    int n = string.codePointAt(this.idx + offs);
                    return n;
                }
                finally {
                    this.idx = string.offsetByCodePoints(this.idx + offs, 1) - offs;
                }
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return string.codePointAt(this.idx + offs);
            }

            @Override
            public int prev() {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                this.idx = string.offsetByCodePoints(this.idx + offs, -1) - offs;
                --this.offset;
                return string.codePointAt(this.idx + offs);
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                return string.codePointBefore(this.idx + offs);
            }

            @Override
            public int offset() {
                return this.offset;
            }

            @Override
            public StringBuilder drainTo(StringBuilder b) {
                try {
                    StringBuilder stringBuilder = b.append(string, this.idx + offs, offs + len);
                    return stringBuilder;
                }
                finally {
                    this.offset += string.codePointCount(this.idx + offs, offs + len);
                    this.idx = len;
                }
            }

            @Override
            public String drainToString() {
                try {
                    String string2 = string.substring(this.idx + offs, offs + len);
                    return string2;
                }
                finally {
                    this.offset += string.codePointCount(this.idx + offs, offs + len);
                    this.idx = len;
                }
            }
        };
    }

    public static CodePointIterator ofChars(char[] chars) {
        return CodePointIterator.ofChars(chars, 0, chars.length);
    }

    public static CodePointIterator ofChars(char[] chars, int offs) {
        return CodePointIterator.ofChars(chars, offs, chars.length - offs);
    }

    public static CodePointIterator ofChars(final char[] chars, final int offs, final int len) {
        if (len <= 0) {
            return EMPTY;
        }
        return new CodePointIterator(){
            private int idx = 0;
            private int offset = 0;

            @Override
            public boolean hasNext() {
                return this.idx < len;
            }

            @Override
            public boolean hasPrev() {
                return this.idx > 0;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    ++this.offset;
                    int n = Character.codePointAt(chars, offs + this.idx);
                    return n;
                }
                finally {
                    this.idx = Character.offsetByCodePoints(chars, offs, len, offs + this.idx, 1) - offs;
                }
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Character.codePointAt(chars, offs + this.idx);
            }

            @Override
            public int prev() {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                this.idx = Character.offsetByCodePoints(chars, offs, len, offs + this.idx, -1) - offs;
                --this.offset;
                return Character.codePointAt(chars, offs + this.idx);
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                return Character.codePointBefore(chars, offs + this.idx);
            }

            @Override
            public int offset() {
                return this.offset;
            }
        };
    }

    public static CodePointIterator ofUtf8Bytes(byte[] bytes) {
        return CodePointIterator.ofUtf8Bytes(bytes, 0, bytes.length);
    }

    public static CodePointIterator ofUtf8Bytes(byte[] bytes, int offs, int len) {
        if (len <= 0) {
            return EMPTY;
        }
        return ByteIterator.ofBytes(bytes, offs, len).asUtf8String();
    }

    public static CodePointIterator ofLatin1Bytes(byte[] bytes) {
        return CodePointIterator.ofLatin1Bytes(bytes, 0, bytes.length);
    }

    public static CodePointIterator ofLatin1Bytes(byte[] bytes, int offs, int len) {
        if (len <= 0) {
            return EMPTY;
        }
        return ByteIterator.ofBytes(bytes, offs, len).asLatin1String();
    }
}

