/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;

public class HttpAuthenticator {
    private final Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
    private final HttpExchangeSpi httpExchangeSpi;
    private final boolean required;
    private final boolean ignoreOptionalFailures;
    private volatile boolean authenticated = false;

    private HttpAuthenticator(Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier, HttpExchangeSpi httpExchangeSpi, boolean required, boolean ignoreOptionalFailures) {
        this.mechanismSupplier = mechanismSupplier;
        this.httpExchangeSpi = httpExchangeSpi;
        this.required = required;
        this.ignoreOptionalFailures = ignoreOptionalFailures;
    }

    public boolean authenticate() throws HttpAuthenticationException {
        return new AuthenticationExchange().authenticate();
    }

    private boolean isAuthenticated() {
        return this.authenticated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
        private HttpExchangeSpi httpExchangeSpi;
        private boolean required;
        private boolean ignoreOptionalFailures;

        Builder() {
        }

        public Builder setMechanismSupplier(Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier) {
            this.mechanismSupplier = mechanismSupplier;
            return this;
        }

        public Builder setHttpExchangeSpi(HttpExchangeSpi httpExchangeSpi) {
            this.httpExchangeSpi = httpExchangeSpi;
            return this;
        }

        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder setIgnoreOptionalFailures(boolean ignoreOptionalFailures) {
            this.ignoreOptionalFailures = ignoreOptionalFailures;
            return this;
        }

        public HttpAuthenticator build() {
            return new HttpAuthenticator(this.mechanismSupplier, this.httpExchangeSpi, this.required, this.ignoreOptionalFailures);
        }
    }

    private class AuthenticationExchange
    implements HttpServerRequest,
    HttpServerResponse {
        private volatile HttpServerAuthenticationMechanism currentMechanism;
        private volatile boolean authenticationAttempted = false;
        private volatile int responseCode = -1;
        private volatile boolean responseCodeAllowed = false;
        private volatile List<HttpServerMechanismsResponder> responders;
        private volatile HttpServerMechanismsResponder successResponder;

        private AuthenticationExchange() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean authenticate() throws HttpAuthenticationException {
            List authenticationMechanisms = (List)HttpAuthenticator.this.mechanismSupplier.get();
            this.responders = new ArrayList<HttpServerMechanismsResponder>(authenticationMechanisms.size());
            try {
                Iterator iterator = authenticationMechanisms.iterator();
                while (iterator.hasNext()) {
                    HttpServerAuthenticationMechanism nextMechanism;
                    this.currentMechanism = nextMechanism = (HttpServerAuthenticationMechanism)iterator.next();
                    nextMechanism.evaluateRequest(this);
                    if (!HttpAuthenticator.this.isAuthenticated()) continue;
                    if (this.successResponder != null) {
                        this.successResponder.sendResponse(this);
                    }
                    boolean bl = true;
                    return bl;
                }
                this.currentMechanism = null;
                if (HttpAuthenticator.this.required || this.authenticationAttempted && !HttpAuthenticator.this.ignoreOptionalFailures) {
                    this.responseCodeAllowed = true;
                    if (this.responders.size() > 0) {
                        this.responders.forEach(r -> r.sendResponse(this));
                        if (this.responseCode > 0) {
                            HttpAuthenticator.this.httpExchangeSpi.setResponseCode(this.responseCode);
                        } else {
                            HttpAuthenticator.this.httpExchangeSpi.setResponseCode(200);
                        }
                    } else {
                        HttpAuthenticator.this.httpExchangeSpi.setResponseCode(403);
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                authenticationMechanisms.forEach(m -> m.dispose());
            }
        }

        @Override
        public List<String> getRequestHeaderValues(String headerName) {
            return HttpAuthenticator.this.httpExchangeSpi.getRequestHeaderValues(headerName);
        }

        @Override
        public String getFirstRequestHeaderValue(String headerName) {
            return HttpAuthenticator.this.httpExchangeSpi.getFirstRequestHeaderValue(headerName);
        }

        @Override
        public void noAuthenticationInProgress(HttpServerMechanismsResponder responder) {
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public void authenticationInProgress(HttpServerMechanismsResponder responder) {
            this.authenticationAttempted = true;
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public void authenticationComplete(SecurityIdentity securityIdentity, HttpServerMechanismsResponder responder) {
            HttpAuthenticator.this.authenticated = true;
            HttpAuthenticator.this.httpExchangeSpi.authenticationComplete(securityIdentity, this.currentMechanism.getMechanismName());
            this.successResponder = responder;
        }

        @Override
        public void authenticationFailed(String message, HttpServerMechanismsResponder responder) {
            this.authenticationAttempted = true;
            HttpAuthenticator.this.httpExchangeSpi.authenticationFailed(message, this.currentMechanism.getMechanismName());
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public void badRequest(HttpAuthenticationException failure, HttpServerMechanismsResponder responder) {
            this.authenticationAttempted = true;
            HttpAuthenticator.this.httpExchangeSpi.badRequest(failure, this.currentMechanism.getMechanismName());
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public void addResponseHeader(String headerName, String headerValue) {
            HttpAuthenticator.this.httpExchangeSpi.addResponseHeader(headerName, headerValue);
        }

        @Override
        public void setResponseCode(int responseCode) {
            if (!this.responseCodeAllowed) {
                throw ElytronMessages.log.responseCodeNotNow();
            }
            if (this.responseCode < 0 || responseCode != 200) {
                this.responseCode = responseCode;
            }
        }
    }
}

