/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.MechanismAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.Evidence;

abstract class AbstractMechanismAuthenticationFactory<M, F, E extends Exception>
implements MechanismAuthenticationFactory<M, F, E> {
    private final SecurityDomain securityDomain;
    private final Map<String, MechanismConfiguration> mechanismConfigurations;
    private final F factory;

    AbstractMechanismAuthenticationFactory(SecurityDomain securityDomain, Map<String, MechanismConfiguration> mechanismConfigurations, F factory) {
        this.securityDomain = securityDomain;
        this.mechanismConfigurations = mechanismConfigurations;
        this.factory = factory;
    }

    @Override
    public SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    @Override
    public F getFactory() {
        return this.factory;
    }

    @Override
    public M createMechanism(String name, UnaryOperator<F> factoryTransformation) throws E {
        MechanismConfiguration configuration = this.mechanismConfigurations.get(name);
        if (configuration == null) {
            configuration = MechanismConfiguration.EMPTY;
        }
        return this.doCreate(name, new ServerAuthenticationContext(this.securityDomain, configuration).createCallbackHandler(), factoryTransformation);
    }

    abstract M doCreate(String var1, CallbackHandler var2, UnaryOperator<F> var3) throws E;

    abstract Collection<Class<? extends Evidence>> getSupportedEvidenceTypes(String var1);

    abstract Collection<String> getSupportedEvidenceAlgorithmNames(Class<? extends AlgorithmEvidence> var1, String var2);

    abstract Collection<Class<? extends Credential>> getSupportedCredentialTypes(String var1);

    abstract Collection<String> getSupportedCredentialAlgorithmNames(Class<? extends AlgorithmCredential> var1, String var2);

    abstract boolean usesCredentials(String var1);

    @Override
    public Collection<String> getMechanismNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        block0: for (String mechName : this.getAllSupportedMechNames()) {
            MechanismConfiguration mechConfig = this.mechanismConfigurations.get(mechName);
            if (mechConfig == null) continue;
            if (!this.usesCredentials(mechName)) {
                names.add(mechName);
                continue;
            }
            SecurityDomain securityDomain = this.securityDomain;
            for (Class<Evidence> clazz : this.getSupportedEvidenceTypes(mechName)) {
                if (AlgorithmEvidence.class.isAssignableFrom(clazz)) {
                    for (String algorithmName : this.getSupportedEvidenceAlgorithmNames(clazz.asSubclass(AlgorithmEvidence.class), mechName)) {
                        if ((!"*".equals(algorithmName) || !securityDomain.getEvidenceVerifySupport(clazz).mayBeSupported()) && !securityDomain.getEvidenceVerifySupport(clazz, algorithmName).mayBeSupported()) continue;
                        names.add(mechName);
                        continue block0;
                    }
                    continue;
                }
                if (!securityDomain.getEvidenceVerifySupport(clazz).mayBeSupported()) continue;
                names.add(mechName);
                continue block0;
            }
            for (Class<Object> clazz : this.getSupportedCredentialTypes(mechName)) {
                if (AlgorithmCredential.class.isAssignableFrom(clazz)) {
                    for (String algorithmName : this.getSupportedCredentialAlgorithmNames(clazz.asSubclass(AlgorithmCredential.class), mechName)) {
                        if ((!"*".equals(algorithmName) || !securityDomain.getCredentialAcquireSupport(clazz).mayBeSupported()) && !securityDomain.getCredentialAcquireSupport(clazz, algorithmName).mayBeSupported()) continue;
                        names.add(mechName);
                        continue block0;
                    }
                    continue;
                }
                if (!securityDomain.getCredentialAcquireSupport(clazz).mayBeSupported()) continue;
                names.add(mechName);
                continue block0;
            }
        }
        return names;
    }

    abstract Collection<String> getAllSupportedMechNames();

    static abstract class Builder<M, F, E extends Exception>
    implements MechanismAuthenticationFactory.Builder<M, F, E> {
        private SecurityDomain securityDomain;
        private Map<String, MechanismConfiguration> mechanismConfigurations = new LinkedHashMap<String, MechanismConfiguration>();
        private F factory;

        Builder() {
        }

        @Override
        public Builder<M, F, E> setSecurityDomain(SecurityDomain securityDomain) {
            Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain);
            this.securityDomain = securityDomain;
            return this;
        }

        @Override
        public Builder<M, F, E> addMechanism(String mechanismName, MechanismConfiguration mechanismConfiguration) {
            Assert.checkNotNullParam((String)"mechanismName", (Object)mechanismName);
            Assert.checkNotNullParam((String)"mechanismConfiguration", (Object)mechanismConfiguration);
            this.mechanismConfigurations.put(mechanismName, mechanismConfiguration);
            return this;
        }

        @Override
        public Builder<M, F, E> setFactory(F factory) {
            Assert.checkNotNullParam((String)"factory", factory);
            this.factory = factory;
            return this;
        }

        SecurityDomain getSecurityDomain() {
            return this.securityDomain;
        }

        Map<String, MechanismConfiguration> getMechanismConfigurations() {
            return this.mechanismConfigurations;
        }

        F getFactory() {
            return this.factory;
        }
    }
}

