/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.provider.ldap.DirContextFactory;
import org.wildfly.security.auth.provider.ldap.EvidenceVerifier;
import org.wildfly.security.auth.provider.ldap.IdentityEvidenceVerifier;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

class DirectEvidenceVerifier
implements EvidenceVerifier {
    private static final DirectEvidenceVerifier INSTANCE = new DirectEvidenceVerifier();

    private DirectEvidenceVerifier() {
    }

    static DirectEvidenceVerifier getInstance() {
        return INSTANCE;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(DirContextFactory contextFactory, Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return evidenceType == PasswordGuessEvidence.class ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    @Override
    public IdentityEvidenceVerifier forIdentity(final DirContextFactory contextFactory, final String distinguishedName) throws RealmUnavailableException {
        return new IdentityEvidenceVerifier(){

            @Override
            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return evidenceType == PasswordGuessEvidence.class ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                if (evidence instanceof PasswordGuessEvidence) {
                    char[] password = ((PasswordGuessEvidence)evidence).getGuess();
                    DirContext dirContext = null;
                    try {
                        dirContext = contextFactory.obtainDirContext(callbacks -> {
                            for (Callback callback : callbacks) {
                                Callback nameCallback;
                                if (NameCallback.class.isInstance(callback)) {
                                    nameCallback = (NameCallback)callback;
                                    ((NameCallback)nameCallback).setName(distinguishedName);
                                    continue;
                                }
                                if (!PasswordCallback.class.isInstance(callback)) continue;
                                nameCallback = (PasswordCallback)callback;
                                ((PasswordCallback)nameCallback).setPassword(password);
                            }
                        }, null);
                        boolean bl = true;
                        contextFactory.discardContext(dirContext);
                        return bl;
                    }
                    catch (NamingException e) {
                        try {
                            ElytronMessages.log.debugf("Credential verification failed.", e);
                            contextFactory.discardContext(dirContext);
                        }
                        catch (Throwable throwable) {
                            contextFactory.discardContext(dirContext);
                            throw throwable;
                        }
                    }
                }
                return false;
            }
        };
    }
}

