/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.ParametricPrivilegedExceptionAction;
import org.wildfly.security.Version;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.DefaultAuthenticationContextProvider;
import org.wildfly.security.auth.client.InvalidAuthenticationConfigurationException;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.client.RuleConfigurationPair;

public final class AuthenticationContext {
    private static final ThreadLocal<AuthenticationContext> currentIdentityContext;
    private final RuleConfigurationPair[] rules;
    private static final RuleConfigurationPair[] NO_RULES;
    static final AuthenticationContext EMPTY;

    private AuthenticationContext() {
        this(NO_RULES, false);
    }

    AuthenticationContext(RuleConfigurationPair[] rules, boolean clone) {
        this.rules = clone ? (RuleConfigurationPair[])rules.clone() : rules;
    }

    public static AuthenticationContext empty() {
        return EMPTY;
    }

    public static AuthenticationContext captureCurrent() {
        return currentIdentityContext.get();
    }

    public AuthenticationContext with(MatchRule rule, AuthenticationConfiguration configuration) {
        if (configuration == null || rule == null) {
            return this;
        }
        RuleConfigurationPair[] rules = this.rules;
        int length = rules.length;
        if (length == 0) {
            return new AuthenticationContext(new RuleConfigurationPair[]{new RuleConfigurationPair(rule, configuration)}, false);
        }
        RuleConfigurationPair[] copy = Arrays.copyOf(rules, length + 1);
        copy[length] = new RuleConfigurationPair(rule, configuration);
        return new AuthenticationContext(copy, false);
    }

    public AuthenticationContext with(AuthenticationContext other) {
        if (other == null) {
            return this;
        }
        RuleConfigurationPair[] rules = this.rules;
        RuleConfigurationPair[] otherRules = other.rules;
        int length = rules.length;
        int otherLength = otherRules.length;
        if (length == 0) {
            return other;
        }
        if (otherLength == 0) {
            return this;
        }
        RuleConfigurationPair[] copy = Arrays.copyOf(rules, length + otherLength);
        System.arraycopy(otherRules, 0, copy, length, otherLength);
        return new AuthenticationContext(copy, false);
    }

    public AuthenticationContext with(int idx, MatchRule rule, AuthenticationConfiguration configuration) throws IndexOutOfBoundsException {
        if (configuration == null || rule == null) {
            return this;
        }
        RuleConfigurationPair[] rules = this.rules;
        int length = rules.length;
        if (idx < 0 || idx > length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return new AuthenticationContext(new RuleConfigurationPair[]{new RuleConfigurationPair(rule, configuration)}, false);
        }
        RuleConfigurationPair[] copy = Arrays.copyOf(rules, length + 1);
        System.arraycopy(copy, idx, copy, idx + 1, length - idx);
        copy[idx] = new RuleConfigurationPair(rule, configuration);
        return new AuthenticationContext(copy, false);
    }

    public AuthenticationContext replacing(int idx, MatchRule rule, AuthenticationConfiguration configuration) throws IndexOutOfBoundsException {
        if (configuration == null || rule == null) {
            return this;
        }
        RuleConfigurationPair[] rules = this.rules;
        int length = rules.length;
        if (idx < 0 || idx > length) {
            throw new IndexOutOfBoundsException();
        }
        RuleConfigurationPair[] copy = (RuleConfigurationPair[])rules.clone();
        copy[idx] = new RuleConfigurationPair(rule, configuration);
        return new AuthenticationContext(copy, false);
    }

    public AuthenticationContext with(int idx, AuthenticationContext other) throws IndexOutOfBoundsException {
        RuleConfigurationPair[] rules = this.rules;
        int length = rules.length;
        if (idx == length) {
            return this.with(other);
        }
        if (idx == 0) {
            return other.with(this);
        }
        if (idx < 0 || idx > length) {
            throw new IndexOutOfBoundsException();
        }
        if (other == null) {
            return this;
        }
        RuleConfigurationPair[] otherRules = other.rules;
        int otherLength = otherRules.length;
        if (otherLength == 0) {
            return this;
        }
        if (length == 0) {
            return other;
        }
        RuleConfigurationPair[] copy = Arrays.copyOf(rules, length + otherLength);
        System.arraycopy(copy, idx, copy, idx + otherLength, length - idx);
        System.arraycopy(otherRules, 0, copy, idx, otherLength);
        return new AuthenticationContext(copy, false);
    }

    public AuthenticationContext without(int idx) throws IndexOutOfBoundsException {
        RuleConfigurationPair[] copy;
        RuleConfigurationPair[] rules = this.rules;
        int length = rules.length;
        if (idx < 0 || idx >= length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 1) {
            assert (idx == 0);
            return EMPTY;
        }
        if (idx == 0) {
            copy = Arrays.copyOfRange(rules, 1, length - 1);
        } else if (idx == length - 1) {
            copy = Arrays.copyOfRange(rules, 0, length - 1);
        } else {
            copy = Arrays.copyOfRange(rules, 0, length - 1);
            System.arraycopy(rules, idx + 1, copy, idx, length - idx - 1);
        }
        return new AuthenticationContext(copy, false);
    }

    int ruleMatching(URI uri) {
        int rulesLength = this.rules.length;
        for (int i = 0; i < rulesLength; ++i) {
            if (!this.rules[i].getMatchRule().matches(uri)) continue;
            return i;
        }
        return -1;
    }

    MatchRule getMatchRule(int idx) {
        RuleConfigurationPair[] rules = this.rules;
        int length = rules.length;
        if (idx < 0 || idx >= length) {
            throw new IndexOutOfBoundsException();
        }
        return rules[idx].getMatchRule();
    }

    AuthenticationConfiguration getAuthenticationConfiguration(int idx) {
        RuleConfigurationPair[] rules = this.rules;
        int length = rules.length;
        if (idx < 0 || idx >= length) {
            throw new IndexOutOfBoundsException();
        }
        return rules[idx].getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(PrivilegedAction<T> action) {
        Assert.checkNotNullParam((String)"action", action);
        AuthenticationContext oldSubj = currentIdentityContext.get();
        if (oldSubj == this) {
            return action.run();
        }
        currentIdentityContext.set(this);
        try {
            T t = action.run();
            return t;
        }
        finally {
            currentIdentityContext.set(oldSubj);
        }
    }

    public <T> T run(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        Assert.checkNotNullParam((String)"action", action);
        AuthenticationContext oldSubj = currentIdentityContext.get();
        if (oldSubj == this) {
            try {
                return action.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        currentIdentityContext.set(this);
        try {
            T e = action.run();
            return e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            currentIdentityContext.set(oldSubj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, P> T run(P parameter, ParametricPrivilegedAction<T, P> action) {
        Assert.checkNotNullParam((String)"action", action);
        AuthenticationContext oldSubj = currentIdentityContext.get();
        if (oldSubj == this) {
            return action.run(parameter);
        }
        currentIdentityContext.set(this);
        try {
            T t = action.run(parameter);
            return t;
        }
        finally {
            currentIdentityContext.set(oldSubj);
        }
    }

    public <T, P> T run(P parameter, ParametricPrivilegedExceptionAction<T, P> action) throws PrivilegedActionException {
        Assert.checkNotNullParam((String)"action", action);
        AuthenticationContext oldSubj = currentIdentityContext.get();
        if (oldSubj == this) {
            try {
                return action.run(parameter);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        currentIdentityContext.set(this);
        try {
            T e = action.run(parameter);
            return e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            currentIdentityContext.set(oldSubj);
        }
    }

    static {
        Version.getVersion();
        currentIdentityContext = new ThreadLocal<AuthenticationContext>(){

            @Override
            protected AuthenticationContext initialValue() {
                try {
                    return DefaultAuthenticationContextProvider.DEFAULT;
                }
                catch (ExceptionInInitializerError error) {
                    throw new InvalidAuthenticationConfigurationException(error.getCause());
                }
            }
        };
        NO_RULES = new RuleConfigurationPair[0];
        EMPTY = new AuthenticationContext();
    }
}

