/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.util.HashMap;
import java.util.Map;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

class SetMechanismPropertiesConfiguration
extends AuthenticationConfiguration {
    private final Map<String, String> mechanismProperties;

    SetMechanismPropertiesConfiguration(AuthenticationConfiguration parent, Map<String, String> mechanismProperties) {
        super(parent);
        this.mechanismProperties = new HashMap<String, String>(mechanismProperties);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetMechanismPropertiesConfiguration(newParent, this.mechanismProperties);
    }

    @Override
    void configureSaslProperties(Map<String, Object> properties) {
        super.configureSaslProperties(properties);
        properties.putAll(this.mechanismProperties);
    }

    @Override
    boolean halfEqual(AuthenticationConfiguration other) {
        return this.mechanismProperties.equals(other.getMechanismProperties()) && this.parentHalfEqual(other);
    }

    @Override
    Map<String, String> getMechanismProperties() {
        return this.mechanismProperties;
    }

    @Override
    int calcHashCode() {
        return HashMath.multiHashUnordered((int)this.parentHashCode(), (int)10267, (int)this.mechanismProperties.hashCode());
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        this.parentAsString(sb);
        sb.append("mechanism-properties=[ ");
        if (this.mechanismProperties != null) {
            this.mechanismProperties.entrySet().forEach(e -> sb.append((String)e.getKey()).append('=').append((String)e.getValue()).append(' '));
        }
        sb.append("],");
        return sb;
    }
}

