/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmChoiceCallback;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;

class SetChoiceAuthenticationConfiguration
extends AuthenticationConfiguration
implements AuthenticationConfiguration.HandlesCallbacks {
    private final Predicate<ChoiceCallback> operation;

    SetChoiceAuthenticationConfiguration(AuthenticationConfiguration parent, Predicate<ChoiceCallback> operation) {
        super(parent.without(SetCallbackHandlerAuthenticationConfiguration.class));
        this.operation = operation;
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws UnsupportedCallbackException, IOException {
        Callback callback = callbacks[index];
        if (callback instanceof ChoiceCallback && !(callback instanceof RealmChoiceCallback) && this.operation.test((ChoiceCallback)callback)) {
            return;
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetChoiceAuthenticationConfiguration(newParent, this.operation);
    }

    @Override
    boolean halfEqual(AuthenticationConfiguration other) {
        return Objects.equals(this.operation, other.getChoiceOperation()) && other.parentHalfEqual(other);
    }

    @Override
    int calcHashCode() {
        return HashMath.multiHashUnordered((int)this.parentHashCode(), (int)22817, (int)Objects.hashCode(this.operation));
    }

    @Override
    Predicate<ChoiceCallback> getChoiceOperation() {
        return this.operation;
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        return this.parentAsString(sb).append("choice=").append(this.operation).append(',');
    }
}

