/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.principal.AnonymousPrincipal;

class SetAnonymousAuthenticationConfiguration
extends AuthenticationConfiguration
implements AuthenticationConfiguration.UserSetting {
    SetAnonymousAuthenticationConfiguration(AuthenticationConfiguration parent) {
        super(parent.without(AuthenticationConfiguration.UserSetting.class, SetCallbackHandlerAuthenticationConfiguration.class));
    }

    @Override
    boolean saslSupportedByConfiguration(String mechanismName) {
        return "ANONYMOUS".equals(mechanismName) || super.saslSupportedByConfiguration(mechanismName);
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws UnsupportedCallbackException, IOException {
        Callback callback = callbacks[index];
        if (callback instanceof NameCallback) {
            ((NameCallback)callback).setName(this.getPrincipal().getName());
        } else {
            super.handleCallback(callbacks, index);
        }
    }

    @Override
    Principal getPrincipal() {
        return AnonymousPrincipal.getInstance();
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetAnonymousAuthenticationConfiguration(newParent);
    }

    @Override
    boolean halfEqual(AuthenticationConfiguration other) {
        return other.delegatesThrough(SetAnonymousAuthenticationConfiguration.class) && this.parentHalfEqual(other);
    }

    @Override
    int calcHashCode() {
        return HashMath.multiHashUnordered((int)this.parentHashCode(), (int)70729, (int)0);
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        return this.parentAsString(sb).append("AnonymousAuthentication,");
    }
}

