/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.key.KeyUtil;

public final class KeyPairCredential
implements AlgorithmCredential {
    private final KeyPair keyPair;

    public KeyPairCredential(KeyPair keyPair) {
        Assert.checkNotNullParam((String)"keyPair", (Object)keyPair);
        PublicKey publicKey = keyPair.getPublic();
        if (publicKey == null) {
            throw ElytronMessages.log.publicKeyIsNull();
        }
        PrivateKey privateKey = keyPair.getPrivate();
        if (privateKey == null) {
            throw ElytronMessages.log.privateKeyIsNull();
        }
        if (!publicKey.getAlgorithm().equals(privateKey.getAlgorithm())) {
            throw ElytronMessages.log.mismatchedPublicPrivateKeyAlgorithms();
        }
        if (!KeyUtil.hasSameParameters(publicKey, privateKey)) {
            throw ElytronMessages.log.mismatchedPublicPrivateKeyParameters();
        }
        this.keyPair = keyPair;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    @Override
    public boolean supportsParameters(Class<? extends AlgorithmParameterSpec> paramSpecClass) {
        return KeyUtil.getParameters(this.keyPair.getPublic(), paramSpecClass) != null;
    }

    @Override
    public <P extends AlgorithmParameterSpec> P getParameters(Class<P> paramSpecClass) {
        return KeyUtil.getParameters(this.keyPair.getPublic(), paramSpecClass);
    }

    @Override
    public boolean impliesSameParameters(AlgorithmCredential other) {
        return KeyUtil.hasParameters(this.keyPair.getPublic(), other.getParameters());
    }

    @Override
    public String getAlgorithm() {
        return this.keyPair.getPublic().getAlgorithm();
    }

    @Override
    public KeyPairCredential clone() {
        PrivateKey clone;
        PrivateKey privateKey = this.keyPair.getPrivate();
        return privateKey == (clone = KeyUtil.cloneKey(PrivateKey.class, privateKey)) ? this : new KeyPairCredential(new KeyPair(this.keyPair.getPublic(), clone));
    }
}

