/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.util;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.FastUnsupportedCallbackException;
import org.wildfly.security.credential.GSSCredentialCredential;

public final class GSSCredentialSecurityFactory
implements SecurityFactory<GSSCredentialCredential> {
    private static final boolean IS_IBM = System.getProperty("java.vendor").contains("IBM");
    private static final String KRB5LoginModule = "com.sun.security.auth.module.Krb5LoginModule";
    private static final String IBMKRB5LoginModule = "com.ibm.security.auth.module.Krb5LoginModule";
    public static final Oid KERBEROS_V5;
    public static final Oid SPNEGO;
    private final int minimumRemainingLifetime;
    private final ExceptionSupplier<GSSCredential, GeneralSecurityException> rawSupplier;
    private volatile GSSCredential cachedCredential;

    GSSCredentialSecurityFactory(int minimumRemainingLifetime, ExceptionSupplier<GSSCredential, GeneralSecurityException> rawSupplier) {
        this.minimumRemainingLifetime = minimumRemainingLifetime;
        this.rawSupplier = rawSupplier;
    }

    @Override
    public GSSCredentialCredential create() throws GeneralSecurityException {
        GSSCredential currentCredential = this.cachedCredential;
        try {
            if (currentCredential != null && currentCredential.getRemainingLifetime() >= this.minimumRemainingLifetime) {
                ElytronMessages.log.tracef("Used cached GSSCredential [%s]", currentCredential);
                return new GSSCredentialCredential(currentCredential);
            }
            ElytronMessages.log.tracef("No valid cached credential, obtaining new one...", new Object[0]);
            currentCredential = (GSSCredential)this.rawSupplier.get();
            ElytronMessages.log.tracef("Obtained GSSCredential [%s]", currentCredential);
            this.cachedCredential = currentCredential;
            return new GSSCredentialCredential(currentCredential);
        }
        catch (GSSException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        try {
            KERBEROS_V5 = new Oid("1.2.840.113554.1.2.2");
            SPNEGO = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException e) {
            throw new RuntimeException("Unable to initialise Oid", e);
        }
    }

    public static class Builder {
        private boolean built = false;
        private List<Oid> mechanismOids = new ArrayList<Oid>();
        private String principal;
        private File keyTab;
        private boolean isServer;
        private int minimumRemainingLifetime;
        private int requestLifetime;
        private boolean debug;

        Builder() {
        }

        public Builder setKeyTab(File keyTab) {
            this.assertNotBuilt();
            this.keyTab = keyTab;
            return this;
        }

        public Builder setIsServer(boolean isServer) {
            this.assertNotBuilt();
            this.isServer = isServer;
            return this;
        }

        public Builder setMinimumRemainingLifetime(int minimumRemainingLifetime) {
            this.assertNotBuilt();
            this.minimumRemainingLifetime = minimumRemainingLifetime;
            return this;
        }

        public Builder setRequestLifetime(int requestLifetime) {
            this.assertNotBuilt();
            this.requestLifetime = requestLifetime;
            return this;
        }

        public Builder addMechanismOid(Oid oid) {
            this.assertNotBuilt();
            this.mechanismOids.add((Oid)Assert.checkNotNullParam((String)"oid", (Object)oid));
            return this;
        }

        public Builder setPrincipal(String principal) {
            this.assertNotBuilt();
            this.principal = principal;
            return this;
        }

        public Builder setDebug(boolean debug) {
            this.assertNotBuilt();
            this.debug = debug;
            return this;
        }

        public SecurityFactory<GSSCredentialCredential> build() throws IOException {
            this.assertNotBuilt();
            Configuration configuration = this.createConfiguration();
            this.built = true;
            return new GSSCredentialSecurityFactory(this.minimumRemainingLifetime > 0 ? this.minimumRemainingLifetime : 0, (ExceptionSupplier<GSSCredential, GeneralSecurityException>)((ExceptionSupplier)() -> this.createGSSCredential(configuration)));
        }

        private GSSCredential createGSSCredential(Configuration configuration) throws GeneralSecurityException {
            final Subject subject = new Subject();
            try {
                LoginContext lc = new LoginContext("KDC", subject, c -> {
                    throw new FastUnsupportedCallbackException(c[0]);
                }, configuration);
                ElytronMessages.log.tracef("Logging in using LoginContext and subject [%s]", subject);
                lc.login();
                ElytronMessages.log.tracef("Logging in using LoginContext and subject [%s] succeed", subject);
                final GSSManager manager = GSSManager.getInstance();
                return Subject.doAs(subject, new PrivilegedExceptionAction<GSSCredential>(){

                    @Override
                    public GSSCredential run() throws Exception {
                        Set<KerberosPrincipal> principals = subject.getPrincipals(KerberosPrincipal.class);
                        if (principals.size() < 1) {
                            throw ElytronMessages.log.noKerberosPrincipalsFound();
                        }
                        if (principals.size() > 1) {
                            throw ElytronMessages.log.tooManyKerberosPrincipalsFound();
                        }
                        KerberosPrincipal principal = principals.iterator().next();
                        ElytronMessages.log.tracef("Creating GSSName for Principal '%s'", principal);
                        GSSName name = manager.createName(principal.getName(), GSSName.NT_USER_NAME, KERBEROS_V5);
                        return manager.createCredential(name, requestLifetime, mechanismOids.toArray(new Oid[mechanismOids.size()]), isServer ? 2 : 1);
                    }
                });
            }
            catch (LoginException e) {
                throw ElytronMessages.log.unableToPerformInitialLogin(e);
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof GeneralSecurityException) {
                    throw (GeneralSecurityException)e.getCause();
                }
                throw new GeneralSecurityException(e.getCause());
            }
        }

        private Configuration createConfiguration() throws IOException {
            HashMap<String, String> options = new HashMap<String, String>();
            if (this.debug) {
                options.put("debug", "true");
            }
            options.put("principal", this.principal);
            if (IS_IBM) {
                options.put("noAddress", "true");
                options.put("credsType", this.isServer ? "acceptor" : "initiator");
                options.put("useKeytab", this.keyTab.toURI().toURL().toString());
            } else {
                options.put("storeKey", "true");
                options.put("useKeyTab", "true");
                options.put("keyTab", this.keyTab.getAbsolutePath());
                options.put("isInitiator", this.isServer ? "false" : "true");
            }
            ElytronMessages.log.tracef("Created LoginContext configuration: %s", ((Object)options).toString());
            final AppConfigurationEntry[] aceArray = new AppConfigurationEntry[]{new AppConfigurationEntry(IS_IBM ? GSSCredentialSecurityFactory.IBMKRB5LoginModule : GSSCredentialSecurityFactory.KRB5LoginModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            return new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    assert ("KDC".equals(name));
                    return aceArray;
                }
            };
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw ElytronMessages.log.builderAlreadyBuilt();
            }
        }
    }
}

