/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.ssl.WrappingX509ExtendedTrustManager;

class SecurityDomainTrustManager
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager delegate;
    private final SecurityDomain securityDomain;
    private final boolean authenticationOptional;

    SecurityDomainTrustManager(X509ExtendedTrustManager delegate, SecurityDomain securityDomain, boolean authenticationOptional) {
        this.delegate = delegate;
        this.securityDomain = securityDomain;
        this.authenticationOptional = authenticationOptional;
    }

    SecurityDomainTrustManager(X509TrustManager delegate, SecurityDomain securityDomain, boolean authenticationOptional) {
        this(delegate instanceof X509ExtendedTrustManager ? (X509ExtendedTrustManager)delegate : new WrappingX509ExtendedTrustManager(delegate), securityDomain, authenticationOptional);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, socket);
        this.doClientTrustCheck(chain, authType, ((SSLSocket)socket).getHandshakeSession());
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, sslEngine);
        this.doClientTrustCheck(chain, authType, sslEngine.getHandshakeSession());
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType);
        this.doClientTrustCheck(chain, authType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClientTrustCheck(X509Certificate[] chain, String authType, SSLSession handshakeSession) throws CertificateException {
        block12: {
            Assert.checkNotNullParam((String)"chain", (Object)chain);
            Assert.checkNotNullParam((String)"authType", (Object)authType);
            if (chain.length == 0) {
                throw ElytronMessages.log.emptyChainNotTrusted();
            }
            X509PeerCertificateChainEvidence evidence = new X509PeerCertificateChainEvidence(chain);
            X500Principal principal = evidence.getPrincipal();
            ServerAuthenticationContext authenticationContext = this.securityDomain.createNewAuthenticationContext();
            boolean ok = false;
            try {
                SupportLevel evidenceSupport = authenticationContext.getEvidenceVerifySupport(X509PeerCertificateChainEvidence.class, evidence.getAlgorithm());
                boolean verified = false;
                boolean authorized = false;
                if (evidenceSupport.mayBeSupported() && (verified = authenticationContext.verifyEvidence(evidence)) && (authorized = authenticationContext.authorize())) {
                    ElytronMessages.log.tracef("Authentication succeed for principal [%s]", principal);
                    authenticationContext.succeed();
                    if (handshakeSession != null) {
                        handshakeSession.putValue("org.wildfly.security.ssl.identity", authenticationContext.getAuthorizedIdentity());
                    }
                    ok = true;
                    return;
                }
                ElytronMessages.log.tracef("Credential validation: evidence support = %s  verified = %b  authorized = %b", (Object)evidenceSupport, verified, authorized);
                if (this.authenticationOptional) {
                    ElytronMessages.log.tracef("Credential validation failed: certificate is not trusted for principal [%s], ignoring as authentication is optional", principal);
                    break block12;
                }
                throw ElytronMessages.log.notTrusted(principal);
            }
            catch (RealmUnavailableException e) {
                if (this.authenticationOptional) {
                    ElytronMessages.log.tracef(e, "Certificate not trusted due to realm failure for principal [%s]", principal);
                    break block12;
                }
                throw ElytronMessages.log.notTrustedRealmProblem(e, principal);
            }
            finally {
                if (!ok) {
                    authenticationContext.fail();
                }
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType, sslEngine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }
}

